/***************************************************************************
                          DialogCntPnl.cpp  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <iostream.h>

#include <qframe.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qstringlist.h>
#include <qevent.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qscrollbar.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qfile.h>

#include <kiconloader.h>
#include <kfiledialog.h>
#include <klistview.h>


#include "DialogCntPnl.h"
#include "../CdboDialogBase.h"

/* 
 *  Constructs a DialogCntPnl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
DialogCntPnl::DialogCntPnl( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "DialogCntPnl" );
    resize( 749, 285 ); 
    setMinimumSize( QSize( 0, 285 ) );
    setMaximumSize( QSize( 32767, 285 ) );
    DialogCntPnlLayout = new QHBoxLayout( this );
    DialogCntPnlLayout->setSpacing( 0 );
    DialogCntPnlLayout->setMargin( 0 );

    mainFrm = new QFrame( this, "mainFrm" );
    mainFrm->setFrameShape( QFrame::StyledPanel );
    mainFrm->setFrameShadow( QFrame::Raised );
    mainFrmLayout = new QGridLayout( mainFrm ); 
    mainFrmLayout->setSpacing( 5 );
    mainFrmLayout->setMargin( 9 );

    GroupBox42_2 = new QGroupBox( mainFrm, "GroupBox42_2" );
    GroupBox42_2->setFrameShape( QGroupBox::Box );
    GroupBox42_2->setFrameShadow( QGroupBox::Sunken );
    GroupBox42_2->setLineWidth( 1 );
    GroupBox42_2->setMargin( 0 );
    GroupBox42_2->setTitle( tr( "Process Output" ) );
    GroupBox42_2->setAlignment( int( QGroupBox::AlignTop | QGroupBox::AlignHCenter ) );
    GroupBox42_2->setColumnLayout(0, Qt::Vertical );
    GroupBox42_2->layout()->setSpacing( 0 );
    GroupBox42_2->layout()->setMargin( 0 );
    GroupBox42_2Layout = new QVBoxLayout( GroupBox42_2->layout() );
    GroupBox42_2Layout->setAlignment( Qt::AlignTop );
    GroupBox42_2Layout->setSpacing( 0 );
    GroupBox42_2Layout->setMargin( 6 );

    outputView = new KListView( GroupBox42_2, "outputView" );
    outputView->addColumn( tr( "Type" ) );
    outputView->addColumn( tr( "Message" ) );
    outputView->setFrameShape( QListView::Box );
    outputView->setFrameShadow( QListView::Plain );
    outputView->setLineWidth( 1 );
    outputView->setShowSortIndicator( false );

	outputView->setSorting(-1);
	//outputView->setColumnWidth(0,80);
	//outputView->setColumnWidth(1,462);

    QToolTip::add(  outputView, tr( "Process output monitor" ) );
    QWhatsThis::add(  outputView, tr( "Process output monitor" ) );
    GroupBox42_2Layout->addWidget( outputView );

    Frame11_2_2_2 = new QFrame( GroupBox42_2, "Frame11_2_2_2" );
    Frame11_2_2_2->setFrameShape( QFrame::StyledPanel );
    Frame11_2_2_2->setFrameShadow( QFrame::Raised );
    Frame11_2_2_2Layout = new QHBoxLayout( Frame11_2_2_2 ); 
    Frame11_2_2_2Layout->setSpacing( 1 );
    Frame11_2_2_2Layout->setMargin( 1 );

    statusLbl = new QLabel( Frame11_2_2_2, "statusLbl" );
    statusLbl->setMinimumSize( QSize( 160, 0 ) );
    statusLbl->setFrameShape( QLabel::Panel );
    statusLbl->setFrameShadow( QLabel::Sunken );
    statusLbl->setText( tr( "No recording device!" ) );
    statusLbl->setAlignment( int( QLabel::AlignCenter ) );
    Frame11_2_2_2Layout->addWidget( statusLbl );

    elapsedTimeLbl = new QLabel( Frame11_2_2_2, "elapsedTimeLbl" );
    elapsedTimeLbl->setMinimumSize( QSize( 112, 0 ) );
    elapsedTimeLbl->setFrameShape( QLabel::Panel );
    elapsedTimeLbl->setFrameShadow( QLabel::Sunken );
    elapsedTimeLbl->setText( tr( "Elapsed Time:" ) );
    elapsedTimeLbl->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Frame11_2_2_2Layout->addWidget( elapsedTimeLbl );

    eTimeLbl = new QLabel( Frame11_2_2_2, "eTimeLbl" );
    eTimeLbl->setMaximumSize( QSize( 80, 32767 ) );
    eTimeLbl->setFrameShape( QLabel::Panel );
    eTimeLbl->setFrameShadow( QLabel::Sunken );
    eTimeLbl->setText( tr( " 00 min" ) );
    eTimeLbl->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    Frame11_2_2_2Layout->addWidget( eTimeLbl );

    timeRemLbl = new QLabel( Frame11_2_2_2, "timeRemLbl" );
    timeRemLbl->setMinimumSize( QSize( 112, 0 ) );
    timeRemLbl->setFrameShape( QLabel::Panel );
    timeRemLbl->setFrameShadow( QLabel::Sunken );
    timeRemLbl->setText( tr( "Time Remaining:" ) );
    timeRemLbl->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
    Frame11_2_2_2Layout->addWidget( timeRemLbl );

    rTimeLbl = new QLabel( Frame11_2_2_2, "rTimeLbl" );
    rTimeLbl->setMaximumSize( QSize( 90, 32767 ) );
    rTimeLbl->setFrameShape( QLabel::Panel );
    rTimeLbl->setFrameShadow( QLabel::Sunken );
    rTimeLbl->setText( tr( " Unknown" ) );
    rTimeLbl->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    Frame11_2_2_2Layout->addWidget( rTimeLbl );
    GroupBox42_2Layout->addWidget( Frame11_2_2_2 );

    mainFrmLayout->addMultiCellWidget( GroupBox42_2, 0, 1, 0, 0 );

    controlPanel_2 = new QFrame( mainFrm, "controlPanel_2" );
    controlPanel_2->setMinimumSize( QSize( 0, 258 ) );
    controlPanel_2->setMaximumSize( QSize( 32767, 260 ) );
    controlPanel_2->setFrameShape( QFrame::Box );
    controlPanel_2->setFrameShadow( QFrame::Sunken );
    QWhatsThis::add(  controlPanel_2, tr( "Control panel." ) );
    controlPanel_2Layout = new QVBoxLayout( controlPanel_2 ); 
    controlPanel_2Layout->setSpacing( 1 );
    controlPanel_2Layout->setMargin( 7 );

    startBtn = new QPushButton( controlPanel_2, "startBtn" );
    startBtn->setMinimumSize( QSize( 120, 40 ) );
    startBtn->setMaximumSize( QSize( 120, 40 ) );
    QFont startBtn_font(  startBtn->font() );
    startBtn_font.setBold( TRUE );
    startBtn->setFont( startBtn_font ); 
    startBtn->setText( tr( "Start!" ) );
    QToolTip::add(  startBtn, tr( "Start erase!" ) );
    controlPanel_2Layout->addWidget( startBtn );

    cancelBtn = new QPushButton( controlPanel_2, "cancelBtn" );
    cancelBtn->setEnabled( FALSE );
    cancelBtn->setMinimumSize( QSize( 120, 40 ) );
    cancelBtn->setMaximumSize( QSize( 120, 40 ) );
    QFont cancelBtn_font(  cancelBtn->font() );
    cancelBtn_font.setBold( TRUE );
    cancelBtn->setFont( cancelBtn_font ); 
    cancelBtn->setText( tr( "&Cancel" ) );
    controlPanel_2Layout->addWidget( cancelBtn );

    settingsBtn = new QPushButton( controlPanel_2, "settingsBtn" );
    settingsBtn->setMinimumSize( QSize( 120, 40 ) );
    settingsBtn->setMaximumSize( QSize( 120, 40 ) );
    QFont settingsBtn_font(  settingsBtn->font() );
    settingsBtn_font.setBold( TRUE );
    settingsBtn->setFont( settingsBtn_font ); 
    settingsBtn->setText( tr( "&Settings" ) );
    QToolTip::add(  settingsBtn, tr( "CD Bake Oven Settings" ) );
    controlPanel_2Layout->addWidget( settingsBtn );

    dumpBtn = new QPushButton( controlPanel_2, "dumpBtn" );
    dumpBtn->setMinimumSize( QSize( 120, 40 ) );
    dumpBtn->setMaximumSize( QSize( 120, 40 ) );
    QFont dumpBtn_font(  dumpBtn->font() );
    dumpBtn_font.setBold( TRUE );
    dumpBtn->setFont( dumpBtn_font ); 
    dumpBtn->setText( tr( "D&ump" ) );
    controlPanel_2Layout->addWidget( dumpBtn );

    helpBtn = new QPushButton( controlPanel_2, "helpBtn" );
    helpBtn->setMinimumSize( QSize( 120, 40 ) );
    helpBtn->setMaximumSize( QSize( 120, 40 ) );
    QFont helpBtn_font(  helpBtn->font() );
    helpBtn_font.setBold( TRUE );
    helpBtn->setFont( helpBtn_font ); 
    helpBtn->setText( tr( "&Help" ) );
    controlPanel_2Layout->addWidget( helpBtn );

    quitBtn = new QPushButton( controlPanel_2, "quitBtn" );
    quitBtn->setMinimumSize( QSize( 120, 40 ) );
    quitBtn->setMaximumSize( QSize( 120, 40 ) );
    QFont quitBtn_font(  quitBtn->font() );
    quitBtn_font.setBold( TRUE );
    quitBtn->setFont( quitBtn_font ); 
    quitBtn->setText( tr( "C&lose" ) );
    quitBtn->setDefault( TRUE );
    QToolTip::add(  quitBtn, tr( "Closes this dialog" ) );

    controlPanel_2Layout->addWidget( quitBtn );

    mainFrmLayout->addWidget( controlPanel_2, 1, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    mainFrmLayout->addItem( spacer, 0, 1 );
    DialogCntPnlLayout->addWidget( mainFrm );
	
	// signals and slots connections
    connect( dumpBtn, SIGNAL( clicked() ), this, SLOT( dumpSlot() ) );
    connect( helpBtn, SIGNAL( clicked() ), this, SLOT( helpSlot() ) );
	

}

//======================================================
DialogCntPnl::~DialogCntPnl(){
}
//---------------------------------------------------------------------------------------------
void DialogCntPnl::output(int type, QString message){
	QString mtype, pixmap;
	switch(type){
		case CdboDialogBase::ErrorMessage:{
			mtype = "Error: ";
			pixmap = "error";
			break;
		}
		case CdboDialogBase::ProcessMessage:{
			mtype = "Process: ";
			pixmap = "process";
			break;
		}
		case CdboDialogBase::InfoMessage:{
			mtype = "Info: ";
			pixmap = "info";
			break;
		}
		case CdboDialogBase::StatusOkMessage:{
			mtype = "Status: ";
			pixmap = "ok";
			break;
		}
		case CdboDialogBase::StatusNotOkMessage:{
			mtype = "Status: ";
			pixmap = "remove";
			break;
		}
	}
	QStringList list(QStringList::split("\n",message));
	QString buff;
	for(int i = 0; i < (int)list.count(); i++){
	//for(int i = (int)list.count(); i >= 0; i--){
		if(list[i].isEmpty()) continue;
		if(list[i].find("seconds.") !=-1 && list[i].find("Last") ==-1){
			buff = outputView->lastChild()->text(1);
			if(buff.find("Last") ==-1){
				outputView->lastChild()->setText( 1, list[i]);
				continue;
			}
		}
		if(list[i].find("done, estimate finish") !=-1){
			buff = outputView->lastChild()->text(1);
			if(buff.find("done, estimate finish") !=-1){
				outputView->lastChild()->setText( 1, list[i]);
				continue;
			}
			buff = outputView->lastChild()->itemAbove()->text(1);
			if(buff.find("done, estimate finish") !=-1){
				outputView->lastChild()->itemAbove()->setText( 1, list[i]);
				continue;
			}
		}
		if(list[i].find("MB written") !=-1){
			buff = outputView->lastChild()->text(1);
			if(buff.find("MB written") !=-1){
				outputView->lastChild()->setText( 1, list[i]);
				continue;
			}
			buff = outputView->lastChild()->itemAbove()->text(1);
			if(buff.find("MB written") !=-1){
				outputView->lastChild()->itemAbove()->setText( 1, list[i]);
				continue;
			}
			
		}
		
		if(list[i].find("Excluded by match:") !=-1)
			continue;
		
		if(list[i].find("%") !=-1 && list[i].find("/") > 1){
			outputView->lastChild()->setText( 1, list[i]);
			continue;
		}
		QListViewItem * item = new QListViewItem(outputView, outputView->lastChild());
  		item->setPixmap( 0, UserIcon(pixmap, KIcon::SizeSmall ));
    		item->setText( 0, mtype);
    		item->setText( 1, list[i]);
    		
    		if(outputView->verticalScrollBar()->value() == outputView->verticalScrollBar()->maxValue())
    			outputView->ensureItemVisible(item);
    }
}
//===============================================
void DialogCntPnl::dumpSlot(){
	if(!outputView->firstChild())
		return;
    QString fileToOpen = KFileDialog::getSaveFileName(QDir::homeDirPath(),
				"*|All files",
				this,
				"Save Process Output As...");
	if(!fileToOpen || fileToOpen == "")
		return;
	QFile file(fileToOpen);
	
	if(file.exists())
		file.remove();
	if(!file.open(IO_ReadWrite))
		return;
		
	QTextStream stream(&file);
	for(QListViewItem *i = outputView->firstChild(); i; i = i->nextSibling()){
		stream << i->text(1);
		stream << "\n";
	}
	file.close();
}
//---------------------------------------------------------------------------------------------
void DialogCntPnl::startForwardTimer(){
	eTimeId = startTimer(1000);
	timer.start();
}
//---------------------------------------------------------------------------------------------
void DialogCntPnl::timerEvent(QTimerEvent *event){
	if(event->timerId() == eTimeId){
		int i = timer.elapsed() / 1000;
		if(i < 59)
			eTimeLbl->setText(" " + QString::number( i ) + " sec");
		else
			eTimeLbl->setText(" " + QString::number( i / 60 ) + " min " +
				QString::number( i % 60 ) + " sec");
	}
}
//---------------------------------------------------------------------------------------------
void DialogCntPnl::stopForwardTimer(){
	killTimer(eTimeId);
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool DialogCntPnl::event( QEvent* ev )
{
    bool ret = QWidget::event( ev );
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont startBtn_font(  startBtn->font() );
	startBtn_font.setBold( TRUE );
	startBtn->setFont( startBtn_font );
	QFont cancelBtn_font(  cancelBtn->font() );
	cancelBtn_font.setBold( TRUE );
	cancelBtn->setFont( cancelBtn_font );
	QFont settingsBtn_font(  settingsBtn->font() );
	settingsBtn_font.setBold( TRUE );
	settingsBtn->setFont( settingsBtn_font );
	QFont dumpBtn_font(  dumpBtn->font() );
	dumpBtn_font.setBold( TRUE );
	dumpBtn->setFont( dumpBtn_font );
	QFont helpBtn_font(  helpBtn->font() );
	helpBtn_font.setBold( TRUE );
	helpBtn->setFont( helpBtn_font );
	QFont quitBtn_font(  quitBtn->font() );
	quitBtn_font.setBold( TRUE );
	quitBtn->setFont( quitBtn_font );
    }
    return ret;
}
/////////// SLOTS ////////////////////////////////////////////////////////////////////////////////
void DialogCntPnl::settingsSlot()
{
    qWarning( "DialogCntPnl::settingsSlot(): Not implemented yet!" );
}
//===============================================
void DialogCntPnl::cancelSlot(){
    qWarning( "DialogCntPnl::cancelSlot(): Not implemented yet!" );
}
//===============================================
void DialogCntPnl::helpSlot(){
    qWarning( "DialogCntPnl::helpSlot(): Not implemented yet!" );
}
//===============================================
void DialogCntPnl::quitSlot(){
    qWarning( "DialogCntPnl::quitSlot(): Not implemented yet!" );
}
//===============================================
void DialogCntPnl::startSlot(){
    qWarning( "DialogCntPnl::startSlot(): Not implemented yet!" );
}
