/****************************************************************************
                             Hyper's CD Catalog
		A multiplatform qt and xml based catalog program

 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <qstring.h>
#include <qvariant.h>
#include <qobject.h>
#include <qdialog.h>
#include <qstringlist.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QLineEdit;
class QPushButton;
class DataBase;
class QLabel;
class QWidget;
class CdCatMainWidget;
class QSpinBox;
class QFrame;
class QFont;
class QComboBox;
class QColor;

class CdCatConfig : public QObject
 {
  Q_OBJECT
  public:
   char errormsg[512];

   CdCatConfig(void);

   int startProgram(DataBase **dbp,QWidget *mw);
   int writeConfig();
   int readConfig ();
   void setParameter(char *par);

  public:
  
   bool    startpar;
   QString startfn;
   
   //Configureable items:
   int     fsize;
   int     historysize;
   bool    autoload;
   QString autoloadfn;
   bool    nice;
   bool    autosave;
   bool    ownfont;
   
   bool    readtag;
   bool    v1_over_v2;
   bool    readinfo;
   
   bool    readavii;
   
   bool    readcontent;
   QString readcfiles;
   unsigned long readclimit;
   
   QStringList hlist;
   QSize   windowSize;
   QPoint  windowPos;
   int windowSize_height;
   int windowSize_width;
   QString cdrompath;
   int  mainP1;
   int  mainP2;
   int  mainP3;

   bool find_cs;
   bool find_em;
   bool find_di;
   bool find_fi;
   bool find_co;
   bool find_ct;
   bool find_mco;
   bool find_mar;
   bool find_mti;
   bool find_mal;
   int  findX;
   int  findY;
   int  findWidth;
   int  findHeight;

   QColor *comm_bg,*comm_stext,*comm_vtext,*comm_fr;
   QFont *defaultfont;
#ifndef _WIN32
   bool    mounteject;
#else   
   QString lang;
#endif
   
  bool linkf;

  /*end configureable items*/

 };

/*****************************************************************************/

class ConfigDialog : public QDialog
{
    Q_OBJECT

public:
    ConfigDialog( CdCatMainWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~ConfigDialog();

    CdCatMainWidget *p;
    QLineEdit* filename;
    QPushButton* searchButton;
    QFrame* line1;
    QSpinBox *spinFontSize;
    QSpinBox *spinHistorySize;
    QLabel* lab;
    QLabel *labHistorySize;
    QCheckBox* cbNice;
    QLineEdit* cdrompath_lineedit;
    QLabel* cdrom_lab;
    QFrame* line2;
    QFrame* line3;
    QFrame* line4;
    QFrame* line5;
    QFrame* line6;
    QFrame* line7;
    QFrame* line8;
    QPushButton* riButton;
    QPushButton* okButton;
    QPushButton* cancelButton;
    QCheckBox* cbAutoload;
    QCheckBox* cbAutosave;
    QCheckBox* cbOwnFont;


protected:
    QGridLayout* ConfigDialogBaseLayout;
    QHBoxLayout* layout1;
    QHBoxLayout* layout2;
    QHBoxLayout* layout3;
    QHBoxLayout* layout4;
    QHBoxLayout* layout5;
    QHBoxLayout* layout6;
    QHBoxLayout* layout7;
    QHBoxLayout* layout8;


#ifndef _WIN32
    QCheckBox* cbMoEj;
#else
    QHBoxLayout* layout9;
    QComboBox  * cbLang;
    QLabel     * langLabel;     
#endif

   QPushButton* searchButton2; // maybe problem for moc

public slots:
    virtual void okExit();
    virtual void ffdbutton();
    virtual void runri();


protected slots:
    virtual void languageChange();
    void ownFontToggled();
    virtual void cdrombutton();
};

#endif // CONFIGDIALOG_H
