;;; This file is part of Cedilla.
;;; Copyright (C) 2002-2006 by Juliusz Chroboczek.

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.

;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.

(in-package "CEDILLA")

;;; Check the beginning of unicode.lisp for the definitions of the
;;; data structures used and for an explanation of the #U and #u
;;; reader macros.

(eval-when (compile eval)
  (setup-cedilla-readtable))

(define-alternatives
  (#u00AD #\-)
  (#u0110 #uD0)
  (#u0110 (:bar . #\D))
  (#u0111 (:bar . #\d))
  (#u0126 (:bar . #\H))
  (#u0127 (:bar . #\h))
  (#u0166 (:bar . #\T))
  (#u0167 (:bar . #\t))
  (#u0197 (:bar . #\I))
  (#u01B5 (:bar . #\Z))
  (#u01B6 (:bar . #\z))
  (#u01E4 (:bar . #\G))
  (#u01E5 (:bar . #\g))
  (#u0268 (:bar . #\i))
  (#u0300 #u60)
  (#u0302 #u5E)
  (#u0302 #u2C6)
  (#u0304 #\-)
  (#u0305 #\-)
  (#u0305 #u00AF)
  (#u0305 #u2014)
  ;; Don't include this as it would cause the dot of a dotted i to be
  ;; removed when composing.
  ;;  ((#u0307 . #\i) #\i)
  (#u030B (:double-h . #u301))
  (#u030C #u2C7)
  (#u030D #\')
  (#u030E #\")
  (#u030F (:double-h . #u300))
  (#u0310 (:simplify . (#u307 . #u306)))
  (#u0311 (:mirror-v . #u306))
  (#u0312 #u2018)
  (#u0313 #\,)
  (#u0313 #u1FBF)
  (#u0314 (:mirror-h . #u313))
  (#u0315 #\,)
  (#u0316 #\`)
  (#u0317 #uB4)
  (#u0318 (:small . #u22A3))
  (#u0319 (:small . #u22A2))
  (#u031D (:small . #u22A5))
  (#u031E (:small . #u22A4))
  (#u031F (:small . #\+))
  (#u0320 (:small . #\-))
  (#u0323 #u2D9)
  (#u0324 #uA8)
  (#u0325 #u2DA)
  (#u0326 #\,)
  (#u0329 #\')
  (#u032C #u2C7)
  (#u032D #u2C6)
  (#u032E #u2D8)
  (#u032F #u311)
  (#u0330 #u2DC)
  (#u0331 #\-)
  (#u0331 #uAF)
  (#u0332 #\-)
  (#u0332 #u2014)
  (#u0332 #uAF)
  (#u0333 (:double-v . #u305))
  (#u0334 #u2DC)
  (#u0335 #\-)
  (#u0336 #u2014)
  (#u0336 #uAF)
  (#u0337 #\/)
  (#u0338 #\/)
  (#u0338 #u2044)
  (#u033B (:small . #u25A1))
  (#u033D (:small . #uD7))
  (#u033E (:rotate . #\~))
  (#u033F (:double-v . #u305))
  (#u0342 #u2DC)
  (#u0345 (:small . #u3B9))
  (#u0347 (:small . #\=))
  (#u0348 #\")
  (#u034A (:small . (:simplify . #u2241)))
  (#u034B (:small . (:simplify . #u223B)))
  (#u034C (:small . #u2248))
  (#u034D (:small . (:simplify . #u2194)))
  (#u034E (:small . #u2191))
  (#u0360 (:double-v . #u303))
  (#u0361 (:double-v . #u311))
  (#u0362 (:small . #u21C9))
  (#u0363 (:small . #\a))
  (#u0364 (:small . #\e))
  (#u0365 (:small . #\i))
  (#u0366 (:small . #\o))
  (#u0367 (:small . #\u))
  (#u0368 (:small . #\c))
  (#u0369 (:small . #\d))
  (#u036A (:small . #\h))
  (#u036B (:small . #\m))
  (#u036C (:small . #\r))
  (#u036D (:small . #\t))
  (#u036E (:small . #\v))
  (#u036F (:small . #\x))
  (#u1FFE #u2018)
  (#u200C #u200B)
  (#u200D #u200B)
  (#u20D2 #\|)
  (#u20D3 (:small . #\|))
  (#u20D6 #u2190)
  (#u20D7 #u2192)
  (#u20D8 #u2DA)
  (#u20DB (:small . #u2234))
  (#u20DC (:small . "::"))
  (#u2127 (:mirror-v . #u2126))
  (#u2129 (:turn . #u3B9))
  (#u2132 (:turn . #\F))
  (#u213A (:rotate . #\Q))
  (#u21C7 (:double-v . #u2190))
  (#u21C9 (:double-v . #u2192))
  (#u2218 #u25CB)
  (#u2295 (:small-circle . #\+))
  (#u2296 (:small-circle . #\-))
  (#u2297 (:small-circle . #uD7))
  (#u2298 (:small-circle . #\/))
  (#u2299 (:small-circle . #uB7))
  (#u229A (:small-circle . #u2218))
  (#u229B (:small-circle . #\*))
  (#u229C (:small-circle . #\=))
  (#u229D (:small-circle . #\-))
  (#u229E (:square . #\+))
  (#u229F (:square . #\-))
  (#u22A0 (:square . #uD7))
  (#u22A1 (:square . #uB7))
  (#u22A2 (:rotate-right . #u22A5))
  (#u22A3 (:rotate . #u22A5))
  (#u22A4 (:turn . #u22A5))
)

(define-fallbacks
  (#u0138 (:lowercase . #\K))
  (#u018F (:stretch . #u0259))
  (#u01DD (:turn . #\e))
  (#u0258 (:mirror-h . #\e))
  (#u0259 (:turn . #\e))
  (#u02B4 (:super . (:turn . #\r)))
  (#u02B6 (:super . (:mirror-v . #\R)))
  (#u02B9 #\')
  (#u02BA #.(coerce '(#u02B9 #u02B9) 'vector))
  (#u02BB (#u312 . #\Space))
  (#u02BC #\')
  (#u02BD (#u314 . #\Space))
  (#u02C6 #\^)
  (#u02C7 (#u030C . #\Space))
  (#u02C8 #\')
  (#u02C9 (#u304 . #\Space))
  (#u02CA (#u301 . #\Space))
  (#u02CB (#u300 . #\Space))
  (#u02CC (#u329 . #\Space))
  (#u02CD (#u331 . #\Space))
  (#u02CE (#u316 . #\Space))
  (#u02CF (#u317 . #\Space))
  (#u02EE #.(coerce '(#u2BC #u2BC) 'vector))
  (#u2010 #\-)
  (#u2011 #\-)
  (#u2012 #\-)
  (#u2013 #\-)
  (#u2014 #\-)
  (#u2015 #u2014)
  (#u2016 (:double-h . #\|))
  (#u201A #\,)
  (#u201B #u2018)
  (#u201E #.(coerce '(#u201A #u201A) 'string))
  (#u201F #u201C)
  (#u2032 #\')
  (#u2035 #u2018)
  (#u2043 #\-)
  (#u2044 #\/)
  (#u20D0 #u20D6)
  (#u20D1 #u20D7)
  (#u212E #\e)
  (#u220A (:small . #u2208))
  (#u220B (:mirror-h . #u2208))
  (#u220D (:small . #u220B))
  (#u2210 (:mirror-v . #u220F))
  (#u2212 #\-)
  (#u2213 (:mirror-v . #u00B1))
  (#u2214 (#u0307 . #\+))
  (#u2216 #\\)
  (#u221B #.(coerce '(#u00B3 #u221A) 'vector))
  (#u221C #.(coerce '(#u2074 #u221A) 'vector))
  (#u2223 #\|)
  (#u2225 #u2016)
  (#u2225 #u2016)
  (#u2235 (:mirror-v . #u2234))
  (#u2236 #\:)
  (#u2237 (:double-h . #u2236))
  (#u2238 (#u0307 . #\-))
  (#u223C #\~)
  (#u223D (:mirror-h . #u223C))
  (#u2240 (:rotate . #\~))
  (#u2242 (#U0304 . #\~))
  (#u2243 (#U0331 . #\~))
  (#u2250 (#u0307 . #\=))
  (#u2266 (#u0347 . #\<))
  (#u2267 (#u0347 . #\>))
  (#u226A (:double-h . #\<))
  (#u226B (:double-h . #\>))
  (#u22A6 #u22A2)
  (#u22A7 (:double-v . #u22A2))
  (#u22A8 (:double-v . #u22A2))
  (#u22A9 (:double-h . #u22A2))
  (#u22C4 #u25C7)
  (#u22C6 #u2217)
  )

(define-alternate-glyph-names
  ;; Alternatives that don't go through Unicode
  (#u0305 "overscore")
  (#u0306 "cyrbreve")
  (#u0307 "dot")
  (#u030F "dblgrave")
  (#u0311 "invbreve")
  (#u0332 "overscore")
  (#u0336 "overscore")
  (#u0394 "Delta")
  (#u03BC "mu")
)
