try:
	import dbus
	from dbus.mainloop.glib import DBusGMainLoop
	HAVE_DBUS = True
except ImportError:
	HAVE_DBUS = False

import gtk
import gobject
import os

#import webbrowser

cwd = os.getcwd()
from lib.common import *
from lib.gconfhelper import GconfHelper
from lib import utils

ICON = os.path.join(cwd, NOTIFY_ICON)
GLADE_FILE = os.path.join(GLADE_BASE_PATH, "popup_notification_window.glade")

notification_instances = 0
class NotificationWindow:
	def __init__(self, title, text, icon = ICON, msec = 3000):
		global notification_instances
		notification_instances += 1

		widgets = gtk.glade.XML(GLADE_FILE, domain="planimo")
		self.window = widgets.get_widget('popup_notification_window')
		close_button = widgets.get_widget('close_button')
		event_type_label = widgets.get_widget('event_type_label')
		
		event_description_label = widgets.get_widget('event_description_label')
		eventbox = widgets.get_widget('eventbox')
		image = widgets.get_widget('notification_image')
		

		event_type_label.set_markup(
			'<span foreground="black" weight="bold">%s</span>' % title)

		self.window.modify_bg(gtk.STATE_NORMAL, 
					gtk.gdk.color_parse('#dab255'))


		bg_color = '#ffffbf'
		popup_bg_color = gtk.gdk.color_parse(bg_color)
		close_button.modify_bg(gtk.STATE_NORMAL, popup_bg_color)
		eventbox.modify_bg(gtk.STATE_NORMAL, popup_bg_color)
		event_description_label.set_markup(
			'<span foreground="black">%s</span>' % text)	
			
		# set the image
		image.set_from_file(icon)
		
		# position the window to bottom-right of screen
		window_width, window_height = self.window.get_size()
		pos_x = gtk.gdk.screen_width() - window_width - 1
		pos_y = gtk.gdk.screen_height() - \
				notification_instances * (window_height + 2)
		self.window.move(pos_x, pos_y)

		widgets.signal_autoconnect(self)
		self.window.show_all()
		gobject.timeout_add(msec, self.on_timeout)

	def on_close_button_clicked(self, widget):
		global notification_instances

		self.window.destroy()
		notification_instances -= 1

	def on_timeout(self):
		global notification_instances

		self.window.destroy()
		notification_instances -= 1


class Notifier:
	def __init__(self):
		self.gconf_helper = GconfHelper()

		if HAVE_DBUS:
			dbus_loop = DBusGMainLoop()
	                self.session_bus = dbus.SessionBus(mainloop = dbus_loop)

			obj = self.session_bus.get_object("org.freedesktop.Notifications", 
							"/org/freedesktop/Notifications")
			self.notif = dbus.Interface(obj, "org.freedesktop.Notifications")
			self.notif.connect_to_signal("ActionInvoked", self.action_cb)
	
	def action_cb(self, id, act):
		if act == "openbrowser":
			utils.open_browser(GMAIL_URL)
		elif act == "mailreader":
			utils.open_mail_reader()

	def notify(self, title, message, 
			icon = ICON, error = False, 
			msec = 3000, force = False,
			buttons = True):

		if error:
			notify_errors = self.gconf_helper.get_key("notify_errors")
			if not notify_errors and not force: return
		if not error:
			mustplaysound = self.gconf_helper.get_key("play_sounds_on_new_mails")
			if mustplaysound:
				utils.playsnd(SND_NOTIFY)

			runcommand = self.gconf_helper.get_key("exec_command")
			if runcommand:
				cmd = self.gconf_helper.get_key("new_mail_command")
				cmdline = cmd.split()
				utils.invoke_subprocess(cmdline)

		mustnotify = self.gconf_helper.get_key("display_notifications")
		if not mustnotify and not force: return

		iconfile = "file://" + icon
		
		if buttons:
			actions = ["openbrowser", _("Go to Gmail Account"),\
					"mailreader", _("Open mail reader")]
		else:
			actions = []

		if not HAVE_DBUS:
			# Revert to classic window
			NotificationWindow(title, message, icon, msec)
		else:
			# new api
			try:
				self.notif.Notify(
					"cgmail",
					dbus.UInt32(0), 
					iconfile, 
					title, 
					message,
					actions, 
					[], 
					dbus.Int32(msec)
					)
			except Exception, detail:
				# Nothing to do with dbus: 
				# Revert to classic window
				print "Warning: Error while trying to use notification-daemon.\n Reverting to classic method.\n Please upgrade your dbus and libnotify version", detail
				NotificationWindow(title, message, icon, msec)

if __name__ == "__main__":
	n = Notifier()
	msg = '<span size="larger">Test</span> ok'
	n.notify("Title", msg, True, msec=10000)

	import gobject
	loop = gobject.MainLoop()
	loop.run()

