/***************************************************************************
                          interface_widget_pattern_editor.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_PATTERN_EDITOR_H
#define INTERFACE_WIDGET_PATTERN_EDITOR_H

#include <gtk--/widget.h>
#include <gtk--/window.h>

#include "editor.h"
#include "player_data.h"

/**
  *@author Juan Linietsky
  */


/******************************
 pattern_view.h
 --------

pattern viewer/editing widget
********************************/


class Tracker : public Gtk::Widget {

	
	/* Color info */

	enum Tracker_Colormap {

		Col_BackGround,
		Col_ForeGround,
		Col_Cursor,
		Col_Row_Hilite_Minor,
		Col_Row_Hilite_Major,
		Col_BackGround_Selected,
		Col_Row_Hilite_Selected,
		Col_ForeGround_Selected,
		Col_SepChannels,
		Col_SepNewChannels,
		Col_Mask,
		Col_ForeGround_Inactive,
		Max_Colors
	};

	static int color_values[];

       	Gdk_Color colors[Max_Colors];
	void allocate_colormap ();

	Gdk_GC	GC[Max_Colors];

	/* Font */
 	Gdk_Font *font;

	void adjust_editor();
	void print_single_row(int rowofs);
	void print_rows();
        void print_number(int rowofs,bool hilite_number,bool mark_number);
	void print_cursor();
        void print_top();
	void print_no_tracks();
        void print_osciloscopes();
	int old_row_to_draw;

	Editor *editor;
	Player_Data *player;

public:

	Gdk_Window window;

        void update_info_areas(int p_row_being_played,int p_pattern_being_played);

	// Events/overrides
	void realize_impl();
	gint do_expose_event(GdkEventExpose* p0);
	void draw_impl(GdkRectangle* p0);
        gint button_press_event_impl(GdkEventButton* p0) {

		grab_focus(); // is this the best way to do it? I cant figure it out!

		return 0;
	}
	void link_to_editor(Editor *p_editor);
	void link_to_player(Player_Data *p_player);
	void set_font(Gdk_Font *p_font) { 
		
		font=p_font; 
		
		if (editor!=NULL) {
			editor->set_font_width(font->string_width("X"));
			editor->set_font_height(font->ascent()+font->descent());
		}
	};

	Tracker();
	~Tracker();
};

#endif
