/*
 * CCDCurveMenu.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  CCDCurveMenu.cpp
*/

#include <cassert>
#include <FL/Fl_Box.H>
#include <FL/Fl_Menu_Bar.H>

#include "Br.hpp"               // `Br'
#include "CCDCurveMenu.hpp"


/**====================================================================
 *
 * CCDCurvePanel  --  class 
 *
 *=====================================================================*/
/**------------------------------------------------------------
 * Ctor... 
 * 
 * Is the `end()' in the Ctor ok? Makes including of further widgets by a 
 *  user a bit more inconveniently. And a inheritor *must* have now in its 
 *  Ctor an `begin()', if he includes something!
 *------------------------------------------------------------*/
CCDCurvePanel::CCDCurvePanel(int X, int Y, int W, int H, const char* la)
  : Fl_Group (X,Y,W,H, la)
{ 
  CTOR(label())
  // in Distributor(en) einloggen...
  Br.distrib_event.login((Callback*)event_msg_, this);

  bool top = true;
  int ya,yb;
  if (top) {ya=Y; yb=Y+30;} else {ya=Y+H-30; yb=Y;}
  
  begin();
//     { Fl_Menu_Bar* mb = new Fl_Menu_Bar(X,ya,W,30); 
//       mb->menu(menu_menubar_);
//       mb->user_data(this);       // this-Zeiger deponieren
//     }
//     //plot_ = new CurvePlotClass (X,yb, W, H-30);
//     plot_ -> box(FL_FLAT_BOX); 
    plot_ = new CurvePlotClass (X,Y,W,H);
    plot_ -> end(); // else following children would be inserted into plot_ 
    
    build_plot();  // using the current CCD-curves in Br.camera (if any)
  end();
  
  callback((Fl_Callback*)cb_window_, this);
  resizable(plot_);
}

/**--------------
 * Dtor... 
 *---------------*/
CCDCurvePanel::~CCDCurvePanel()
{
  DTOR(label()) 
  // aus Distributor(en) ausloggen...
  Br.distrib_event.logout(this);
}


/**---------------------------------------
 * build_plot()         without redraw()!
 *----------------------------------------*/
void CCDCurvePanel::build_plot ()
{
  plot_ -> clear();                   // --> empty_look(true)
  if (Br.ccd_curves_ready()) {
    plot_ -> make_current_cartes();   // wichtig fuer add()
    plot_ -> start_insert();          // init_minmax() + empty_look(false)
    plot_ -> add(Br.camera()->crvX_r);
    plot_ -> add(Br.camera()->crvX_g);
    plot_ -> add(Br.camera()->crvX_b);
    plot_ -> style(STYLE_LINES);
  }
}

/**--------------------------------
 * Calling when window is closed...
 *---------------------------------*/
void CCDCurvePanel::cb_window()   
{
  WINCALL(label())
  hide();           // BTW: this is the default
}

/**----------------------------------
 * Callback for the "Update" item...                    UNUSED
 *-----------------------------------*/
void CCDCurvePanel::cb_update (Fl_Menu_*) 
{
  update_plot();
}

/**--------------------------------------------------
 * event_msg()  --  Distributor callback
 *---------------------------------------------------*/
void CCDCurvePanel::event_msg (BracketingCore::Event e)
{
  SPUR_BR_EVENT(("CCDCurvePanel::%s(%d) [visible=%d]: ",
                 __func__, e, visible()));
  switch (e)
  {
  case BracketingCore::CAMERA_INIT:  
  case BracketingCore::CAMERA_DELETED:
  case BracketingCore::CCD_OUTDATED:
      SPUR_BR_EVENT(("%s\n", br_eventnames[e]));
      // Do not clear, mark curves only as "outdated"...
      if (!plot_->empty_look() && outdated_str_) {
        int x,y,w,h;
        w = (int)fl_width(outdated_str_);
        h = fl_height();
        x = plot_-> left() + 15;
        y = plot_-> top() + 10;
        // I don't know, why the compiler `plot_->add(..)' doesn't accept
        //   here -- that's why the `Fl_Group::current()' variant...
        Fl_Group* savecurrent = Fl_Group::current();
        Fl_Group::current(plot_);
          Fl_Box* box_mark_ = new Fl_Box (x,y,w+10,h+6, outdated_str_);
          box_mark_ -> color(fl_color_average (FL_YELLOW, FL_WHITE, 0.5));
          box_mark_ -> box(FL_THIN_UP_BOX);
        Fl_Group::current(savecurrent);
        //plot_ -> add((Fl_Widget*)box_mark_);  // What's wrong here?
        plot_ -> redraw();
      }
      break;
      
  case BracketingCore::CCD_UPDATED:  
      SPUR_BR_EVENT(("%s\n", br_eventnames[e]));
      // Removing of the "outdated" box will be done by plot_->clear()
      update_plot();
      break;    
  
  default:
      SPUR_BR_EVENT(("not handled\n"));
  }
}


/**====================================================================
 *
 * CCDCurveWindow
 *
 *=====================================================================*/
CCDCurveWindow::CCDCurveWindow(int X, int Y, int W, int H, const char* la)
  : Fl_Window (X,Y,W,H, la)
{ 
  panel_ = new CCDCurvePanel(0,0,W,H, la);
  resizable(this);
  end();
}

CCDCurveWindow::CCDCurveWindow(int W, int H, const char* la)
  : Fl_Window (W,H, la)
{ 
  panel_ = new CCDCurvePanel(0,0,W,H, la);
  resizable(this);
  end();
}


/**====================================================================
 *
 * CurveWindow
 *
 * Bug: Seltamerweise wird die draw()-Funktion des zweiten Widgets, zumindest
 *  fuer die Kurven - das Koordinatensystem wird gezeichnet - nicht aufgerufen,
 *  wenn dort wie vorgesehen das "~Panel" und nicht wie jetzt das "~Window"
 *  Widget steht. Wenn FollowPanel als zweites, dann ebenso. *=====================================================================*/
CurveWindow::CurveWindow(int X, int Y, int W, int H, const char* la)
 : Fl_Window(X,Y,W,H, la)
{
  followUp_ = new FollowCurvePanel(  0,   0,   W/2-1, H, (char*)0);
  response_ = new CCDCurvePanel   (W/2+2, 0, W-W/2-1, H, (char*)0);
  resizable(this);
  end();
  show();
} 
 
CurveWindow::CurveWindow(int W, int H, const char* la) 
 : Fl_Window(W,H, la)
{
  followUp_ = new FollowCurvePanel(  0,   0,   W/2-1, H, (char*)0);
  response_ = new CCDCurvePanel   (W/2+2, 0, W-W/2-1, H, (char*)0); 
  resizable(this);
  end();
  show();
} 


//-------------------------------------------------
// The static elements....  
//-------------------------------------------------
Fl_Menu_Item CCDCurvePanel::menu_menubar_[] = {
  {"&File",  0,0,0, FL_SUBMENU},
    {"Load (fut)", 0,0,0, FL_MENU_INACTIVE},
    {"Save (fut)", 0,0,0, FL_MENU_INACTIVE},
    {"&Close", FL_ALT+'c', (Fl_Callback*)CCDCurvePanel::cb_close_},
    {0},
  //{"Update", 0, (Fl_Callback*)CCDCurvePanel::cb_compute_},
  {0}
};

const char* CCDCurvePanel::default_title_  = "Response Curves";
const char* CCDCurvePanel::outdated_str_   = "outdated";//"old";
const char* CCDCurveWindow::default_title_ = "Response Curves (Bracketing to HDR)";
const char* CurveWindow::default_title_    = "Curves (Bracketing to HDR)";

// END OF FILE
