#include "cp_types.h"
#include "cp_proto.h"

/* Check sum of angles of each face for sph packing; must sum to less 
than pi. Return number of radii adjusted to meet conditions. nf is the
normalized face. */

int ck_s_compat(struct p_data *p,int nf)
{
  int v,count=0,num_adj=0,j,v0,v1,v2,w;
  double max;
  f_data *face;
  struct R_data *pR_ptr;

  face=p->faces;
  pR_ptr=p->packR_ptr;
	
  for (v=1;v<=p->facecount;v++)
    {
      count=0;
      if (v==nf) continue;	
      v0=face[nf].vert[0];v1=face[nf].vert[1];v2=face[nf].vert[2];
      while ((pR_ptr[face[v].vert[0]].rad 
	      +pR_ptr[face[v].vert[1]].rad
	      +pR_ptr[face[v].vert[2]].rad)>=(M_PI-okerr))
	{
	  max=0.0;
	  for (j=0;j<3;j++)
	    max = (pR_ptr[w=face[v].vert[j]].rad > max 
		   && w!=v0 && w!=v1 && w!=v2) ?
	      pR_ptr[face[v].vert[j]].rad : max;
	  for (j=0;j<3;j++)
	    if (pR_ptr[w=face[v].vert[j]].rad >= max
		&& w!=v0 && w!=v1 && w!=v2)
	      pR_ptr[face[v].vert[j]].rad *= .8;
	  count++;
	}
      num_adj += (count>0);
    }
  if (num_adj)
    {
      sprintf(msgbuf,"%d sph radii adjusted in pack for compatibility",num_adj);
      msg();
    }
  return (num_adj);
} /* ck_s_compat */
