(asdf:oos 'asdf:load-op :contextl)

(in-package :contextl-user)

(defclass grouped-layer (standard-layer-class) ())

(defgeneric group-root (layer))
(defgeneric default-layer (layer))

(define-layered-method activate-layer-using-class
  ((to-activate grouped-layer) active-layers)
  (call-next-layered-method
   to-activate
   (deactivate-layer (group-root (find-layer to-activate)) active-layers)))

(define-layered-method deactivate-layer-using-class
  ((to-deactivate grouped-layer) active-layers)
  (declare (ignore active-layers))
  (multiple-value-bind
      (new-layers cacheablep)
      (call-next-method)
    (values
     (activate-layer (default-layer (find-layer to-deactivate)) new-layers)
     cacheablep)))

(deflayer output ()
  ((group-root :initform 'output :reader group-root)
   (default-layer :initform 'standard-output :reader default-layer)))

(deflayer standard-output (output) ()
  (:layer-class grouped-layer))

(deflayer html-output (output) ()
  (:layer-class grouped-layer))

(deflayer xml-output (output) ()
  (:layer-class grouped-layer))

(deflayer json-output (output) ()
  (:layer-class grouped-layer))

(define-layered-function make-output ()
  (:method () '(output))
  (:method :in-layer standard-output ()
   (list* 'standard-output (call-next-method)))
  (:method :in-layer html-output ()
   (list* 'html-output (call-next-method)))
  (:method :in-layer xml-output ()
   (list* 'xml-output (call-next-method)))
  (:method :in-layer json-output ()
   (list* 'json-output (call-next-method))))

(assert (equal (make-output) '(output)))

(with-active-layers (standard-output)
  (assert (equal (make-output) '(standard-output output)))
  (with-active-layers (html-output)
    (assert (equal (make-output) '(html-output output)))
    (with-active-layers (xml-output)
      (assert (equal (make-output) '(xml-output output)))
      (with-inactive-layers (xml-output)
        (assert (equal (make-output) '(standard-output output))))
      (assert (equal (make-output) '(xml-output output))))
    (assert (equal (make-output) '(html-output output))))
  (assert (equal (make-output) '(standard-output output))))

(print :done)


#+allegro (excl:exit)
#+cmu (ext:quit)
#+openmcl (ccl:quit)
#+sbcl (sb-ext:quit)
