C********************************************************************
      SUBROUTINE O8CUTD
C**** CUT D IF APPROPRIATE AND RESCALE
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8CONS.INC'
      INTEGER I
      DOUBLE PRECISION TERM,TERM1,O8VECN,O8SC1
      EXTERNAL O8VECN,O8SC1
      SAVE
      XNORM=O8VECN(1,N,X)
      TERM=BETA*(XNORM+ONE)
      DNORM=O8VECN(1,N,D)
      D0NORM=O8VECN(1,N,D0)
      DSCAL=ONE
      IF ( DNORM*D0NORM .NE. ZERO ) THEN
        COSPHI=O8SC1(1,N,D,D0)/(D0NORM*DNORM)
      ELSE
        COSPHI=ZERO
      ENDIF
      IF ( DNORM .GT. TERM ) THEN
C*****  D TOO LONG:  RESCALE
        TERM1=TERM/DNORM
        DNORM=TERM
        DSCAL=TERM1
        DO I= 1,N
          D(I)=D(I)*TERM1
          DD(I)=DD(I)*TERM1**2
        ENDDO
      ENDIF
C*** SINCE WE PROJECT THE RAY WITH RESPECT TO THE BOUNDS, BE SURE
C*** TO COMPUTE THE DIRECTIONAL DERIVATIVE CORRECTLY
C*** THEREFORE CORRECT D AND DD APPROPRIATELY
      DO I=1,N
        IF ( LLOW(I) .AND. X(I)+SIGSM*D(I) .LE. UG(I)
     F     ) THEN
          D(I)=ZERO
          DD(I)=MAX(ZERO,DD(I))
        ENDIF
        IF ( LUP(I) .AND. X(I)+SIGSM*D(I) .GE. OG(I)
     F     ) THEN
         D(I)=ZERO
         DD(I)=MIN(ZERO,DD(I))
        ENDIF
      ENDDO
      DNORM=O8VECN(1,N,D)
      RETURN
      END
