;; -*- Mode: Lisp -*-

(in-package :burp)

(defclass burp-new-bug (burp-page html-form)
  ((category
    :initarg :category
    :documentation
    "The category that the current bug is being filed under."))
  )

(defmethod shared-initialize ((form burp-new-bug) slots &rest)
  (call-next-method)
  (setf (slot-value form 'method) "burp-add-bug")
  (instantiate-children
   form
   `(("category"   static-string
      :value ,(lambda () (slot-value (slot-value form 'category) 'category-name)))
     ("description"   text-area)
     ("different-category"   hyperlink
      :reference ,(refer-wm burp-categories)
      :value "Choose a different category.")
     ("submit"   submit-button)
      )))

(defclass range-selector (html-form-element)
  ((class
    :initarg :class)
   (editor
    :initarg :editor))
  )

(defmethod render-html ((element range-selector) stream)
  (with-slots (imho::ext-name)
    element
    (with-tag (:stream stream :tag "SELECT" :attr `(("SIZE" . "1")
                                                   ("NAME" . ,imho::ext-name)))
      (let ((opts (get-range-list (slot-value element 'class))))
        (dolist (opt opts)
          (with-tag (:stream stream :tag "OPTION" :attr `(("VALUE" . ,(car opt))))
            (write-string (cdr opt) stream)))
        (with-tag (:stream stream :tag "OPTION" :attr `(("VALUE" . "ADD")))
          (write-string "Add..." stream))))))


(define-wm burp-add-bug ((element t))
  (with-slots (category)
    element
    (let ((description (element-value (child-element element "description"))))
      (format t ";; processing result..~%")
      (format t "desc: ~s~%cat:  ~s~%" description category)
      (update-records-from-instance
       (make-instance 'burp-bug
                      :creator (slot-value (slot-value *active-session* 'user) 'user-id)
                      :category (category-id category)
                      :description description))
      (session-instance 'burp-categories))))
  

(define-wm burp-new-bug ((element t) (category bug-category))
  (if category
      (if (slot-value *active-session* 'user)
          (session-instance 'burp-new-bug
                            :category category)
          (session-instance 'burp-login
                            :destination (list 'burp-new-bug :category category)))
      (typecase element
        (burp-new-bug
         (let ((description (element-value (child-element element "description"))))
           (format t ";; processing result..~%")
           (format t "desc: ~s~%cat:  ~s~%" description category)
           (update-records-from-instance
            (make-instance 'burp-bug :category category
                           :description description))
           (session-instance 'burp-categories)))
        (t
         (error "No category supplied, and don't know whence I'm called")))))

(defmethod get-range-list ((class (eql 'bug-category)))
  (mapcar (lambda (cat)
            (cons (slot-value cat 'category-id)
                  (slot-value cat 'category-name)))
          (select 'bug-category)))

