(in-package :odcl)

(defclass persistent-storage-test (unit-test)
  ((store)
   (path)))

(defmethod test-prologue ((self persistent-storage-test))
  (setf (slot-value self 'store) (make-instance 'persistent-storage)
        (slot-value self 'path) (temp-file)))

(defmethod test-epilogue ((self persistent-storage-test))
  (with-slots (store path)
    self
    (mapc #'delete-file (files-under path))
    (unix:unix-rmdir path)
    (setf store nil)))

(define-test (self persistent-storage-test) 1
  (with-slots (store path)
    self
    (write-snapshot store path)))

(define-test (self persistent-storage-test) 2
  (with-slots (store path)
    self
    (write-snapshot store path)
    (read-snapshot store path)))

(defclass fruit (persistent-object)
  ((kind :initform :unknown)))

(defmethod write-snapshot ((self fruit) path)
  (write-to-file path (list :kind (slot-value self 'kind))))

(defmethod read-snapshot ((self fruit) path)
  (let ((data (read-from-file path)))
    (setf (slot-value self 'kind)
          (getf data :kind))))

(define-test (self persistent-storage-test) 3
  (with-slots (store path)
    self
    (%add-persistent-class store 'fruit)))

(define-test (self persistent-storage-test) 4
  (with-slots (store path)
    self
    (%add-persistent-class store 'fruit)
    (%get-next-oid store 'fruit)))

(define-test (self persistent-storage-test) 5
  (with-slots (store path)
    self
    (prog (oid)
       (%add-persistent-class store 'fruit)
       (setf oid (%get-next-oid store 'fruit))
       (%create-object store 'fruit oid))))

(define-test (self persistent-storage-test) 6
  (with-slots (store path)
    self
    (prog (oid object)
       (%add-persistent-class store 'fruit)
       (setf oid (%get-next-oid store 'fruit))
       (setf object (%create-object store 'fruit oid))
       (cmsg "Object = ~s" object))))

(define-test (self persistent-storage-test) 7
  (with-slots (store path)
    self
    (prog (oid object)
       (%add-persistent-class store 'fruit)
       (setf oid (%get-next-oid store 'fruit))
       (setf object (%create-object store 'fruit oid))
       (cmsg "Object = ~s" object)
       (setf (slot-value object 'kind) :banana)
       (write-snapshot store path))))

(define-test (self persistent-storage-test) 8
  (with-slots (store path)
    self
    (prog (oid object)
       (%add-persistent-class store 'fruit)
       (setf oid (%get-next-oid store 'fruit))
       (setf object (%create-object store 'fruit oid))
       (cmsg "Object = ~s" object)
       (setf (slot-value object 'kind) :banana)
       (write-snapshot store path)
       (setf store nil)
       (setf object nil)
       (setf store (make-instance 'persistent-storage))
       (read-snapshot store path)
       (cmsg "Object = ~s" (get-readable-object store 'fruit 1)))))



(defclass persistent-system-test (unit-test)
  ((system)
   (path)))

(defmethod test-prologue ((self persistent-system-test))
  (let ((path (temp-file)))
    (setf (slot-value self 'system) (make-instance 'snapshot-persister
                                                   :system-class 'persistent-storage
                                                   :path path)
          (slot-value self 'path) path)))

(defmethod test-epilogue ((self persistent-system-test))
  (with-slots (system path)
    self
    ;;(mapc #'delete-file (files-under path))
    ;;(unix:unix-rmdir path)
    (setf system nil)))

(define-test (self persistent-system-test) 1
  (declare (ignore self))
  (cmsg "Constructor succeeded."))

(define-test (self persistent-system-test) 2
  (with-slots (system)
    self
    (add-persistent-class system 'fruit)))

(define-test (self persistent-system-test) 3
  (with-slots (system)
    self
    (add-persistent-class system 'fruit)
    (get-next-oid system 'fruit)))

(define-test (self persistent-system-test) 4
  (with-slots (system)
    self
    (prog (oid)
       (add-persistent-class system 'fruit)
       (setf oid (get-next-oid system 'fruit))
       (create-object system 'fruit oid))))

(define-test (self persistent-system-test) 5
  (with-slots (system)
    self
    (prog (oid)
       (add-persistent-class system 'fruit)
       (setf oid (get-next-oid system 'fruit))
       (create-object system 'fruit oid)
       (take-snapshot system))))
