;;;; MaiSQL --- Common Lisp Interface Layer to SQL Databases
;;;; This is copyrighted software.  See documentation for terms.
;;;; 
;;;; postgresql-loader.cl --- Foreign Object Loader for PostgreSQL
;;;; 
;;;; Checkout Tag: $Name:  $
;;;; $Id: postgresql-loader.lisp,v 1.5 2001/12/28 21:07:52 craig Exp $

(in-package :MAISQL-POSTGRESQL)

;;; Load the foreign library
 
;;; JMM - Two modifications here.  The first is to change the dynamic
;;; library load path from a string to a list of strings.  This is so
;;; my second change will work at least in the spirit of the original
;;; version.

;;; My second change involves setting the load path based on the lisp
;;; being used.  I assume if one is using Lispworks than one is on a
;;; Windows platform and set the load path to load two libraries,
;;; cygwin and pq, needed for the FFI to work under Windows+CYGWIN.

;;;
;;; database-type-load foreign has been updated accordingly.

#-lispworks
(defvar *postgresql-so-load-path* '("/usr/lib/libpq.so.2")
  "Location where the PostgreSQL client library is to be found.  If
  this differs at your site, set *postgresql-so-load-path* to the right
  path before compiling or loading the system.")
  
#+lispworks
(defvar *postgresql-so-load-path* '("/usr/lib/libpq.so.2")
  "Location where the PostgreSQL client library is to be found.  If
  this differs at your site, set *postgresql-so-load-path* to the right
  path before compiling or loading the system.")
  
#+(and lispworks lww)
(defvar *postgresql-so-load-path* '("c:/bin/cygwin1.dll" "c:/usr/local/pgsql/bin/pq.dll")
  "Location of client libraries needed to get PostgreSQL interfaced to Lispworks
running on WinNT+Cygwin-1.1.1")

(defvar *postgresql-so-libraries* '("-lcrypt" "-lc")
  "List of library flags needed to be passed to ld to load the
PostgreSQL client library succesfully.  If this differs at your site,
set *postgresql-so-libraries* to the right path before compiling or
loading the system.")

(defmethod database-type-load-foreign ((database-type (eql :postgresql)))
  (dolist (str *postgresql-so-load-path*)
    #+sbcl (sb-ext:load-foreign str :libraries *postgresql-so-libraries*)
    #+cmu (ext:load-foreign str :libraries *postgresql-so-libraries*)
    #+lispworks (fli:register-module str)
    #-(or sbcl cmu lispworks)
    (error "Don't know how to load libraries in this lisp implementation")))

(database-type-load-foreign :postgresql)
