#include <iostream.h>
#include <ClanLib/core.h>
#include <ClanLib/gui.h>
#include <ClanLib/display.h>
#include <ClanLib/application.h>

class LabelTest : public CL_ClanApplication
{
public:
	char *get_title() { return "LabelTest"; }

	CL_ResourceManager *resources;
	CL_StyleManager *style;
	CL_ComponentManager *manager;
	CL_GUIManager *gui;
	
	int main(int argc, char** argv)
	{
		// Create a console window for text-output if not available
		CL_ConsoleWindow console("Console");
		console.redirect_stdio();

		try
		{
			CL_SetupCore::init();
			CL_SetupGUI::init();
			CL_SetupDisplay::init();
			CL_Display::set_videomode(640,480,16, false);

			resources = new CL_ResourceManager("resources.scr", false);
			style = new CL_StyleManager_Default(resources);
			gui = new CL_GUIManager(style);
			manager = CL_ComponentManager::create("labeltest.gui", false, style,gui);


/*			
			CL_Slot slot_key_down = ((CL_Label *)manager->get_component("my_label"))->sig_key_down().connect(
				this, &LabelTest::on_key_down);
*/
			while (!CL_Keyboard::get_keycode(CL_KEY_ESCAPE))
			{
				CL_Display::clear_display(0,0,0);
				gui->show();
				
				CL_System::keep_alive();
				CL_Display::flip_display();
			}
			
			delete gui;
			delete manager;
			delete style;
			delete resources;

			CL_SetupDisplay::deinit();
			CL_SetupGUI::deinit();
			CL_SetupCore::deinit();
		}
		catch (CL_Error e)
		{
			std::cout << e.message.c_str() << std::endl;
		}
		catch (...)
		{
			std::cout << "Ugga" << std::endl;
		}
		// Display console close message and wait for a key
		console.display_close_message();

		return 0;
	}
	
	void on_key_down(CL_Component *comp, CL_InputDevice *device, CL_Key key)
	{
		std::cout << "You clicked the label!" << std::endl;
	}
} app;
