/*
	$Id: checkbox.cpp,v 1.19 2002/01/09 12:59:06 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "../API/GUI/checkbox.h"
#include "../API/GUI/component.h"
#include "../API/GUI/component_options.h"
#include "../API/GUI/stylemanager.h"
#include "checkbox_generic.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_CheckBox::CL_CheckBox(
	CL_Component *parent,
	CL_StyleManager *style)
: CL_Button(parent, style), impl(0)
{
	impl = new CL_CheckBox_Generic(this);
	get_style_manager()->connect_styles("checkbox", this);
}

CL_CheckBox::CL_CheckBox(
	const CL_Point &pos,
	const std::string &text,
	CL_Component *parent,
	CL_StyleManager *style)
: CL_Button(pos, text, parent, style), impl(0)
{
	impl = new CL_CheckBox_Generic(this);
	get_style_manager()->connect_styles("checkbox", this);
	find_preferred_size();
}

CL_CheckBox::~CL_CheckBox()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:
bool CL_CheckBox::is_checked() const
{
	return is_down();
}

/////////////////////////////////////////////////////////////////////////////
// Operations:
void CL_CheckBox::set_checked(bool check)
{
	set_down(check);
}
