/*
	$Id: combobox.cpp,v 1.28 2001/12/27 22:45:46 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include <string>

#include "API/GUI/combobox.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"
#include "combobox_generic.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_ComboBox::CL_ComboBox(CL_Component *parent, CL_StyleManager *style)
: CL_Component(parent, style), impl(0)
{
	impl = new CL_ComboBox_Generic(this);
	get_style_manager()->connect_styles("combobox", this);
}

CL_ComboBox::CL_ComboBox(
	const CL_Rect &pos,
	CL_Component *parent,
	CL_StyleManager *style)
: CL_Component(pos, parent, style), impl(NULL)
{
	impl = new CL_ComboBox_Generic(this);
	get_style_manager()->connect_styles("combobox", this);
}

CL_ComboBox::~CL_ComboBox()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

int CL_ComboBox::get_count() const
{
	return impl->get_count();
}

std::list<std::string> &CL_ComboBox::get_items() const
{
	return impl->get_items();
}

std::string CL_ComboBox::get_current_text() const
{
	return impl->get_current_text();
}

std::string CL_ComboBox::get_text(int index) const
{
	return impl->get_text(index);
}

int CL_ComboBox::get_current_item() const
{
	return impl->get_current_item();
}

bool CL_ComboBox::is_selected(int index) const
{
	return impl->is_selected(index);
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

int CL_ComboBox::insert_item(const std::string &text, int index)
{
	return impl->insert_item(text, index);
}

void CL_ComboBox::remove_item(int index)
{
	impl->remove_item(index);
}

void CL_ComboBox::change_item(const std::string &text, int index)
{
	impl->change_item(text, index);
}

void CL_ComboBox::set_current_item(int index)
{
	impl->set_current_item(index);
}

void CL_ComboBox::clear_selection()
{
	impl->clear_selection();
}

void CL_ComboBox::sort(bool ascending)
{
	impl->sort(ascending);
}

void CL_ComboBox::clear()
{
	impl->clear();
}

/////////////////////////////////////////////////////////////////////////////
// Signals:

CL_Signal_v1<int> &CL_ComboBox::sig_highlighted()
{
	return impl->sig_highlighted;
}

CL_Signal_v1<int> &CL_ComboBox::sig_activated()
{
	return impl->sig_activated;
}

