/*
	$Id: menudata_generic.cpp,v 1.4 2001/09/08 19:12:51 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "menudata_generic.h"
#include "API/Core/System/error.h"
#include "API/GUI/menudata.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_ComponentOptions CL_MenuData_Generic::create_options(
	const CL_Rect &pos)
{
	CL_ComponentOptions options;

	options.add_option("x", pos.x1);
	options.add_option("y", pos.y1);
	options.add_option("width", pos.get_width());
	options.add_option("height", pos.get_height());

	return options;
}

CL_MenuData_Generic::CL_MenuData_Generic(CL_MenuData *self, const CL_ComponentOptions &options, CL_StyleManager *style)
:
	menudata(self)
{
//	real_parent = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

unsigned int CL_MenuData_Generic::get_count() const
{
	return menudata->get_children().size();
}

const std::string &CL_MenuData_Generic::get_text(int id) const
{
	throw CL_Error("get_text() not implemented");
}

bool CL_MenuData_Generic::is_item_enabled(int id) const
{
	throw CL_Error("is_item_enabled() not implemented");
}

bool CL_MenuData_Generic::is_item_checked(int id) const
{
	throw CL_Error("is_item_checked() not implemented");
}

int CL_MenuData_Generic::get_index(int id) const
{
	throw CL_Error("get_index() not implemented");
}

int CL_MenuData_Generic::get_id(int index) const
{
	throw CL_Error("get_id() not implemented");
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

int CL_MenuData_Generic::insert_item(const std::string &text, int id, int index)
{
	int new_id = generate_id(id);
//	items.push_back(new CL_MenuItem(text, new_id));
	return new_id;
}

int CL_MenuData_Generic::insert_separator(int id, int index)
{
	int new_id = generate_id(id);
//	items.push_back(new CL_MenuItem(new_id));
	return new_id;
}

void CL_MenuData_Generic::remove_item(int id)
{
	throw CL_Error("remove_item() not implemented");
}

void CL_MenuData_Generic::remove_item_at(int index)
{
	throw CL_Error("remove_item_at() not implemented");
}

void CL_MenuData_Generic::clear()
{
	throw CL_Error("clear() not implemented");
}

void CL_MenuData_Generic::change_item(const std::string &text, int id)
{
	throw CL_Error("change_item() not implemented");
}

void CL_MenuData_Generic::enable_item(int id, bool enable)
{
	throw CL_Error("enable_item() not implemented");
}

void CL_MenuData_Generic::check_item(int id, bool check)
{
	throw CL_Error("check_item() not implemented");
}

void CL_MenuData_Generic::set_id(int index, int id)
{
	throw CL_Error("set_id() not implemented");
}

/////////////////////////////////////////////////////////////////////////////
// Implementation:

int CL_MenuData_Generic::generate_id(int id)
{
	if(id != -1)
		return get_count();
	else 
		return id;
}
