/*
	$Id: menuitem_default.cpp,v 1.29 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include <cstdio>
#include "API/Display/Display/surface.h"
#include "API/Display/Font/font.h"
#include "API/Core/Resources/resource_manager.h"
#include "API/GUI/stylemanager_default.h"
#include "menuitem_default.h"

CL_MenuItem_Default::CL_MenuItem_Default(
	CL_MenuItem *_menuitem,
	const CL_ComponentOptions &options,
	CL_StyleManager_Default *style)
: CL_ComponentStyle(_menuitem), menuitem(_menuitem)
{
	this->style = style;
	
	resources = style->get_resources();
	font = CL_Font::load("MenuItem/font", resources);
	sur_unchecked = CL_Surface::load("MenuItem/sur_unchecked", resources);
	sur_checked = CL_Surface::load("MenuItem/sur_checked", resources);
	sur_submenu = CL_Surface::load("MenuItem/sur_submenu", resources);
	if(options.exists("surface"))
		sur_icon = CL_Surface::load(options.get_value("surface").c_str(), resources);
	else	
		sur_icon = NULL;
		
	slot_paint = menuitem->sig_paint().connect(
		this, &CL_MenuItem_Default::on_paint);
	slot_get_preferred_size = menuitem->sig_get_preferred_size().connect(
		this, &CL_MenuItem_Default::on_get_preferred_size);

	draw_filled = true;
	draw_submenu_icon = false;
}

CL_MenuItem_Default::~CL_MenuItem_Default()
{
//	resources->get_resource("MenuItem/font")->unload();
//	resources->get_resource("MenuItem/sur_unchecked")->unload();
//	resources->get_resource("MenuItem/sur_checked")->unload();
//	resources->get_resource("MenuItem/sur_submenu")->unload();
}

void CL_MenuItem_Default::set_draw_style(bool filled)
{
	draw_filled = filled;
}

int CL_MenuItem_Default::calc_height()
{
	unsigned int height = font->get_height();

	if(menuitem->is_separator())
		return height / 2;
	
	if(sur_icon)
		if(sur_icon->get_height() > height)
			height = sur_icon->get_height();
			
	if(sur_submenu)
		if(sur_submenu->get_height() > height)
			height = sur_submenu->get_height();
			
	return height + 8;
}

int CL_MenuItem_Default::calc_width()
{
	return 
		calc_surface_check_width() + 
		calc_surface_icon_width() +
		calc_text_width() + 
		calc_surface_submenu_width();
}

int CL_MenuItem_Default::calc_text_width()
{
	if(menuitem->get_text().length())
		return font->get_text_width(menuitem->get_text().c_str()) + 4;
	else
		return 0;
}

int CL_MenuItem_Default::calc_surface_check_width()
{
	if(menuitem->is_checkable())
	{
		unsigned int width = sur_checked->get_width();
		if(sur_unchecked->get_width() > width)
			width = sur_unchecked->get_width();
		return width + 4;
	}	
	else
		return 0;
}

int CL_MenuItem_Default::calc_surface_icon_width()
{
	if(sur_icon)
		return sur_icon->get_width() + 4;
	else
		return 0;
}

int CL_MenuItem_Default::calc_surface_submenu_width()
{
	if(sur_submenu && menuitem->has_submenu())
		return sur_submenu->get_width() + 4;
	else
		return 0;
}

void CL_MenuItem_Default::on_get_preferred_size(CL_Point &size)
{
	if(menuitem->is_separator())
	{
		size.x = 10;
		size.y = 18;
	}
	else
	{
		size.x = font->get_text_width(menuitem->get_text());
		size.y = font->get_height();
	}
}

void CL_MenuItem_Default::on_paint()
{
	int height = menuitem->get_height();
	int width = menuitem->get_width();
	
	if(menuitem->is_separator())
	{
		style->draw_line(0, height / 2 - 1, width, height / 2 - 1, GUICOLOR_BRIGHT_SHADE);
		style->draw_line(0, height / 2, width, height / 2, GUICOLOR_DARK_SHADE);
/*		if(draw_filled)
		{
			style->draw_line(0, height / 2 - 1, width, height / 2 - 1, GUICOLOR_TEXT_DISABLED_FG);
			style->draw_line(0, height / 2, width, height / 2, GUICOLOR_TEXT_DISABLED_BG);
		}
		else
		{
			style->draw_line(width / 2 - 1, 0, width / 2 - 1, height, GUICOLOR_TEXT_DISABLED_FG);
			style->draw_line(width / 2, 0, width / 2, height, GUICOLOR_TEXT_DISABLED_BG);
		}
*/	}
	else
	{
		if(menuitem->is_highlighted())
		{
			style->fill_rect(0, 0, width, height, GUICOLOR_SELECTION);
/*			if(draw_filled)
				style->fill_rect(0, 0, width, height, GUICOLOR_SELECTION);
			else
				style->draw_box(0, 0, width, height, GUICOLOR_BOTTOM_SHADE, GUICOLOR_BRIGHT_OUTLINE);
*/		}
		else
		{
			style->fill_rect(0, 0, width, height, GUICOLOR_WINDOW_NORMAL);
		}

/*		if(menuitem->is_checkable())
		{
			if(menuitem->is_checked())
			{
				int sur_height = sur_checked->get_height();
				sur_checked->put_screen(surface_check_pos, (height - sur_height) / 2);
			}
			else
			{
				int sur_height = sur_unchecked->get_height();
				sur_unchecked->put_screen(surface_check_pos, (height - sur_height) / 2);
			}
		}
*/
/*		if(sur_icon)
		{
			int sur_height = sur_icon->get_height();
			sur_icon->put_screen(surface_icon_pos, (height - sur_height) / 2);
		}

		if(sur_submenu && menuitem->has_submenu() && draw_submenu_icon)
		{
			int sur_height = sur_submenu->get_height();
			sur_submenu->put_screen(surface_submenu_pos, (height - sur_height) / 2);
		}

		int sur_height = font->get_height();
		font->print_left(text_pos, (height - sur_height) / 2, menuitem->get_text().c_str());
*/
		int font_height = font->get_height();
		font->print_left(4, (height - font_height) / 2, menuitem->get_text().c_str());
	}
}
