/*
	$Id: treeview_default.cpp,v 1.10 2002/01/16 19:43:06 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "treeview_default.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_TreeView_Default::CL_TreeView_Default(
	CL_TreeView *_treeview,
	CL_StyleManager_Default *style)
: CL_ComponentStyle(_treeview), treeview(_treeview)
{
	this->style = style;

	slot_paint = treeview->sig_paint().connect(
		this, &CL_TreeView_Default::on_paint);
}

/////////////////////////////////////////////////////////////////////////////
// Callbacks:

void CL_TreeView_Default::on_paint()
{
	int width = treeview->get_width();
	int height = treeview->get_height();

	bool focus = treeview->has_child(treeview->get_focus());

	if(treeview->is_enabled() == false || focus == false)
	{
		// Fill
		style->fill_rect(1, 1, width - 1, height - 1, GUICOLOR_WHITE);

		// Outline
		style->draw_rect(0, 0, width, height, GUICOLOR_DARK_OUTLINE);
	}
	else
	{
		// Fill
		style->fill_rect(2, 2, width - 2, height - 2, GUICOLOR_WHITE);

		// Outline
		style->draw_rect(0, 0, width, height, GUICOLOR_DARK_OUTLINE);

		// Shade box
		style->draw_box(1, 1, width - 1, height - 1, GUICOLOR_DARKER_SHADE, GUICOLOR_MEDIUM_SHADE);
	}
}
