/*
	NetDataObjects demonstration application.

	Copyright (c)1999 by Kenneth Gangstoe.
*/

#include <ClanLib/core.h>

#define OBJECT_DATA 1
#define DATA_CHANNEL 10

class Object : public CL_NetDataObject
{
public:
	Object();
	Object(int size);

	void init();
	
	int get_size();

	void serialize_load(CL_InputSource *input);
	void serialize_save(CL_OutputSource *output);

	void serialize_load(CL_InputSource *input, int pos, int length);
	void serialize_save(CL_OutputSource *output, int pos, int length);

private:
	int size;
	char *data;
};

class NetDataObjectDemo : public CL_ClanApplication, CL_NetObjectCreator
{
public:
	virtual char *get_title();
	virtual int main(int argc, char **argv);
	
	void create_game();
	void join_game();
	void run_server();
	void run_client();
	
	virtual CL_NetObject *create(int netobj_id, CL_InputSource *input=NULL);

	CL_NetDataController data_controller;
	CL_NetGame *netgame;

	Object *object;
};
