/*
	NetObjects demonstration application.

	Copyright (c)1999 by Magnus Norddahl.
*/

#include "netobjects_demo.h"

NetObjectsDemo app;

char *NetObjectsDemo::get_title()
{
	return "NetObjects Demo";
}

int NetObjectsDemo::main(int argc, char **argv)
{
	if (argc < 2)
	{
		cout << "Syntax: netobjects_demo <server|client>" << endl << endl;
		return 0;
	}
	
	try
	{
//		CL_System::init_display();
//		CL_System::init_network();

		if (CL_String(argv[1]) == "server") create_game();
		else if (CL_String(argv[1]) == "client") join_game();
		else
		{
			cout << "Syntax: netobjects_demo <server|client>" << endl << endl;
			return 0;
		}
		
		run_game();
	}
	catch (CL_Error err)
	{
		cout << "Error caught: " << err.message << endl;
	}

	return 1;
}

void
NetObjectsDemo::init_modules()
{
	CL_SetupCore::init();
	CL_SetupCore::init_network();
}

void
NetObjectsDemo::deinit_modules()
{
	CL_SetupCore::deinit_network();
	CL_SetupCore::deinit();
}

void NetObjectsDemo::create_game()
{
	netgame = CL_Network::create_game("netobj_demo", 2104);
	cursor = new MouseCursor(this);
}

void NetObjectsDemo::join_game()
{
	CL_Network::find_game_at("netobj_demo", "localhost", 2104);
	netgame = CL_Network::receive_game_found(0);
	cursor = NULL;
}

void NetObjectsDemo::run_game()
{
	cout << "Creating netobject controller." << endl;
	cursor_controller = new CL_NetObjectController_Basic;
	cursor_controller->set_creator(this);

	if (cursor != NULL) cursor_controller->add(cursor, 0);

	cout << "Setting videomode..." << endl;
	CL_SetupCore::init_display();
	CL_Display::set_videomode(320, 240, 16, false, false);
	
	cout << "Beginning game loop." << endl;
	try
	{
		while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
		{
			// check for joining computers - give full access to channel zero.
			const CL_NetComputer *computer = netgame->receive_computer_join();
			if (computer != NULL) netgame->set_access(0, computer);
		
			// show something on the screen:
			CL_Display::fill_rect(0, 0, 320, 240, 0.0f, 0.0f, 0.4f, 0.5f);
			if (cursor != NULL) cursor->show();
			CL_Display::flip_display();
		
			// update netobject(s):
			cursor_controller->update(netgame, 0);

			CL_System::keep_alive();
		}
	}
	catch (CL_Error err)
	{
		cout << "Error: " << err.message.c_str() << endl;
	}

	delete cursor;
	delete cursor_controller;
	delete netgame;
}

CL_NetObject *NetObjectsDemo::create(
	int netobj_id,
	CL_InputSource *input)
{
	return new MouseCursor(this, input);
}

// ----------------------------------------------------------------------

MouseCursor::MouseCursor(NetObjectsDemo *app)
{
	master = true;
	init(app);
}

MouseCursor::MouseCursor(NetObjectsDemo *app, CL_InputSource *input)
{
	master = false;

	init(app);
	receive_message(input);
	app->cursor = this;
}

MouseCursor::~MouseCursor()
{
	app->cursor_controller->remove(this);
}

void MouseCursor::show()
{
	if (master)
	{
		x = CL_Mouse::get_x();
		y = CL_Mouse::get_y();
		app->cursor_controller->send(
			app->netgame,
			0,
			this,
			write_message());
	}
	
	CL_Display::fill_rect(x-5, y-5, x+5, y+5, red, green, blue, 0.5f);
}

void MouseCursor::init(NetObjectsDemo *app)
{
	this->app = app;

	x = 0;
	y = 0;
	red = 1.0f;
	green = 1.0f;
	blue = 1.0f;
}

void MouseCursor::receive_message(CL_InputSource *input)
{
	x = input->read_int32();
	y = input->read_int32();
	red = input->read_float32();
	green = input->read_float32();
	blue = input->read_float32();
}

CL_NetMessage MouseCursor::write_message()
{
	CL_OutputSource_Memory output;
	output.write_int32(x);
	output.write_int32(y);
	output.write_float32(red);
	output.write_float32(green);
	output.write_float32(blue);

	return CL_NetMessage(output.get_data());
}
