/*
	$Id: surfaceprovider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Display 2D"

#ifndef header_surfaceprovider
#define header_surfaceprovider

#include "target.h"
class CL_ResourceManager;

class CL_SurfaceProvider : public CL_Target
//: The image source interface.
// <p>This is the interface used by a <a class="CL_Surface">surface</a> to
// load an image. For more information about the relationship between a
// surface and its provider, please the CL_Surface class description.</p>
//
// <p>The surface provider interface extends the <a
// class="CL_Target">renderer target interface</a> with some blitting
// related functions. Currently, this is translation of the image and
// colorkey transparency.</p>
//
// <p>ClanLib includes a large range of surface providers that can load an
// image from various sources: PCX, TGA, PNG and so on.</p>
//
// <p>If you want to be able to load your (newly created) surface provider
// as a resource, you have to implement the CL_ResourceSource_Surface as
// well.</p>
{
public:
	static CL_SurfaceProvider *load(
		const char *resource_id,
		CL_ResourceManager *manager);
	//: This function loads a surface provider from a resource file (usually a datafile).

	virtual ~CL_SurfaceProvider() {;}

	virtual int get_translate_x() const { return 0; }
	//: Returns the offset of the surface_data returned 
	//: by get_data(). This translation will 
	//: be applied to every putscreen using a given 
	//: surfaceproviders data as input.
	//!retval: The x-offset of the surface data.

	virtual int get_translate_y() const { return 0; }
	//: Returns the offset of the surface_data returned 
	//: by get_data(). This translation will 
	//: be applied to every putscreen using a given 
	//: surfaceproviders data as input.
	//!retval: The y-offset of the surface data.

	virtual bool uses_src_colorkey() const =0;
	//: Returns true if the surface provider uses a source color key.

	virtual unsigned int get_src_colorkey() const =0;
	//: Returns the source color key.
};

#endif
