/*
	$Id: inputdevice.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_inputdevice
#define header_inputdevice

class CL_InputButton;
class CL_InputAxis;
class CL_InputHat;
class CL_InputBuffer;
class CL_InputCursor;

class CL_InputDevice
//: Input device interface.
// Class interface representing an input device, such as a keyboard, mouse,
// joystick, gamepad or digitizer.
{
public:
	virtual ~CL_InputDevice() { return; }

	virtual char *get_name() const =0;
	//: Returns the name of the input device.
	//!retval: Name of the device.

	virtual int get_num_buttons() const =0;
	//: Returns the number of buttons on this device.
	//!retval: Return the number of buttons available.

	virtual CL_InputButton *get_button(int button_num)=0;
	//: Returns a input button interface used to access the specified button number. 
	//: NULL is returned if button doesn't exist.
	//!param: button_num - Number of the button to be returned.
	//!retval: Pointer to the button requested (or NULL if none).

	virtual int get_num_axes() const =0;
	//: Returns the number of axes on this device.
	//!retval: Number of axes available.

	virtual CL_InputAxis *get_axis(int axis_num)=0;
	//: Returns a input axis interface used to access the specified axis number. 
	//: NULL is returned if axis doesn't exist.
	//!param: axis_num - Number of the axis to be returned.
	//!retval: Pointer to axis requested (or NULL if none).

	virtual int get_num_hats() const =0;
	//: Returns the number of hats available on this device.
	//!retval: Number of input hats available.
	
	virtual CL_InputHat *get_hat(int hat_num)=0;
	//: Returns a input hat interface used to access the specified hat number. 
	//: NULL is returned if the hat doesn't exist.
	//!param: hat_num - Number of the hat to be returned.
	//!retval: Pointer to input hat requested (or NULL if none).

	virtual int get_num_cursors() const =0;
	//: Returns the number of input cursors available on this device.
	//!retval: Number of cursors available.

	virtual CL_InputCursor *get_cursor(int cursor_num)=0;
	//: Returns a input cursor interface used to access the specified cursor 
	//: number. NULL is returned if the cursor doesn't exist.
	//!param: cursor_num - Number of the cursor to be returned.
	//!retval: Pointer to cursor requested (or NULL if none).
};

#endif
