/*
	$Id: matrix.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Matrix class template.


	DON'T USE THIS CLASS!!! 
	(Daniel Vogel 25.12.1999)
*/

#ifndef header_matrix
#define header_matrix

template <int hoejde, int bredde>
class CL_Matrix
{
public:
	int hoej() {return hoejde;}
	int bred() {return bredde;}
	float matrix[hoejde][bredde];

	void set_nul()
	{
		for (int i=0; i<hoejde; i++)
			for (int j=0; j<bredde; j++)
				matrix[i][j]=(float) 0;
	}

	void set_enhed()
	{
		set_nul();
		for (int i=0; i < (hoejde<bredde ? hoejde : bredde); i++)
			matrix[i][i]=(float) 1;
	}

	void copy_from(CL_Matrix<hoejde, bredde> &matrix2)
	{
		for (int i=0; i<hoejde; i++)
			for (int j=0; j<bredde; j++)
				matrix[i][j] = matrix2.matrix[i][j];
	}

	void copy_to(CL_Matrix<hoejde, bredde> &matrix2)
	{
		for (int i=0; i<hoejde; i++)
			for (int j=0; j<bredde; j++)
				matrix2.matrix[i][j] = matrix[i][j];
	}

	void mul(CL_Matrix<hoejde, bredde> &matrix2) // virker kun paa ens matricer
	{
		CL_Matrix<hoejde, bredde> temp_matrix;
		temp_matrix.copy_from(*this);
		set_nul();

		for (int linie=0; linie<hoejde; linie++)
			for (int kolone=0; kolone<bredde; kolone++)
				for (int element=0; element<bredde; element++)
					matrix[linie][kolone] +=
							temp_matrix.matrix[linie][element] *
							matrix2.matrix[element][kolone];
	}
};

template <class A_Matrix, class B_Matrix, class C_Matrix>
void mul(A_Matrix &A, B_Matrix &B, C_Matrix &C)
{
	int A_hoejde=A.hoej();
	int A_bredde=A.bred();
	int B_hoejde=B.hoej();
	int B_bredde=B.bred();
	int C_hoejde=C.hoej();
	int C_bredde=C.bred();
	if (A_bredde!=B_hoejde || A_hoejde!=C_hoejde || B_bredde!=C_bredde)
		return; // Matrix multiplikation kan ikke lade sig goere.

	C.set_nul();

	for (int A_linie=0; A_linie<A_hoejde; A_linie++)
		for (int B_kolone=0; B_kolone<B_bredde; B_kolone++)
			for (int element=0; element<A_bredde; element++)
				C.matrix[A_linie][B_kolone] +=
						A.matrix[A_linie][element] * B.matrix[element][B_kolone];
}

typedef CL_Matrix<4, 4> CL_Matrix4x4;
typedef CL_Matrix<4, 1> CL_Matrix4x1;

#endif
