/*
	$Id: netdata_controller.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! l1_component="NetObjects"

#ifndef header_netdata_controller
#define header_netdata_controller

#define MAX_PACKET_SIZE 1024

#include "netobject.h"

//#include "../Misc/inputsource_memory.h"
//#include "../Misc/outputsource_memory.h"

/*****************************************************************************/

class CL_NetDataInfo
{
public:
	CL_NetDataInfo(const CL_NetComputer *dest, CL_NetDataObject *object, int id, int type, int priority);
	CL_NetDataInfo(CL_NetDataObject *object, int id, int type, int size);

public:
	const CL_NetComputer *dest;
	CL_NetDataObject *object;

	int id;
	int type;
	int priority;

	int data_pos;
	int data_size;

	bool init_transfer;
};

/*****************************************************************************/

class CL_NetDataController
{
public:
	CL_NetDataController();
	virtual ~CL_NetDataController() {};

	virtual void init(CL_NetGame *game, int channel, CL_NetObjectCreator *creator);
	
	virtual void send(const CL_NetComputer *dest, CL_NetDataObject *object, int priority=0, int type = 0);

	virtual void update_client();
	virtual bool update_server(int min_priority, int max_priority, const CL_NetComputer *dest=NULL);
	virtual bool update_server_high(int max_priority=0, const CL_NetComputer *dest=NULL);
	virtual bool update_server_low(int min_priority=1, const CL_NetComputer *dest=NULL);

private:
	enum TransferMode
	{
		InitTransfer,
		Transfer,
		EndTransfer
	};

protected:
	CL_Array<CL_NetDataInfo> serverTransfers;
	CL_Array<CL_NetDataInfo> clientTransfers;

	CL_NetGame *game;
	int channel;

	CL_NetObjectCreator *creator;
	int next_object_id;
};

/*****************************************************************************/
/*
class CL_NetFileController : public CL_NetDataController, public CL_NetDataCreator
{
public:
	CL_NetFileController() {};
	virtual ~CL_NetFileController() {};

	virtual void init(CL_NetGame *game, int channel, CL_NetDataCreator *creator=NULL);

	virtual void send(const CL_NetComputer *dest, char *filename, int priority = 0, int type=0);

	virtual CL_NetDataObject *create_data(int type, int size);
};
*/
/*****************************************************************************/

#endif
