/*
	$Id: cl_gsldef.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

/*
 * Defines a number of macros for declaring slots.
 * The system assumes that every slot has a caller which
 * is registered and takes an int and a va_list as arguements
 */

#ifndef CL_GSLDEF_H
#define CL_GSLDEF_H

#include <iostream>

/* hide warnings about assuming & */
#ifndef __WIN32__
#define cl_slot(NAME) (CL_GSlot)(&NAME ## Caller)
#define cl_signal(NAME) (CL_GMember)(&NAME)
#else
#define cl_slot(NAME) (CL_GSlot)(NAME ## Caller)
#define cl_signal(NAME) (CL_GMember)(NAME)
#endif

#define emit

#define DEF_SIGNAL_0(NAME) \
void NAME(void) \
{ \
	CL_GObject::activate_signal(0, this, cl_signal(NAME)); \
} \

#define DEF_SIGNAL_1(NAME, TYPE1) \
void NAME(TYPE1 arg1) \
{ \
	CL_GObject::activate_signal(1, this, cl_signal(NAME), arg1); \
}

#define DEF_SIGNAL_2(NAME, TYPE1, TYPE2) void NAME(TYPE1 arg1, TYPE2 arg2) \
{ \
	CL_GObject::activate_signal(2, this, cl_signal(NAME), arg1, arg2); \
}

#define DEF_SLOT_0(NAME) void NAME ## Caller(int nargs, va_list ap) \
{ \
	if(nargs != 0) \
	cerr << "Internal bug in DEF_SLOT_0, nargs != 0"; \
	NAME(); \
} \
void NAME()

#define DEF_SLOT_1(NAME, TYPE1) void NAME ## Caller(int nargs, va_list ap) \
{ \
	TYPE1 arg1; \
	if(nargs != 1) \
	cerr << "Internal bug in DEF_SLOT_1"; \
	arg1 = va_arg(ap, TYPE1); \
	NAME(arg1); \
} \
void NAME(TYPE1 arg1)

#define DEF_SLOT_2(NAME, TYPE1, TYPE2) void NAME ## Caller(int nargs, va_list ap) \
{ \
	TYPE1 arg1; \
	TYPE2 arg2; \
	if(nargs != 2) cerr << "Internal bug in DEF_SLOT_2"; \
	arg1 = va_arg(ap, TYPE1); \
	arg2 = va_arg(ap, TYPE2); \
	NAME(arg1, arg2); \
} \
void NAME(TYPE1 arg1, TYPE2 arg2)

#define DEF_SLOT_3(NAME, TYPE1, TYPE2, TYPE3) void NAME ## Caller(int nargs, va_list ap) \
{ \
	TYPE1 arg1; \
	TYPE2 arg2; \
	TYPE3 arg3; \
	if(nargs != 3) cerr << "Internal bug in DEF_SLOT_3"; \
	arg1 = va_arg(ap, TYPE1); \
	arg2 = va_arg(ap, TYPE2); \
	arg3 = va_arg(ap, TYPE3); \
	NAME(arg1, arg2, arg3); \
} \
void NAME(TYPE1 arg1, TYPE2 arg2, TYPE3 arg3)

#endif
