/*
	$Id: trace.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef TRACE_H
#define TRACE_H
#include <fstream>

#ifndef NOTRACE
extern ofstream TRACEFILE__;

TRACEFILE__.open("trace.out");

#define TRACE(arg) \
TRACEFILE__ <<__FILE__<<" "<<__LINE__<< ": "<< #arg << endl; \
arg

#define TRACEMSG(arg) \
TRACEFILE__ <<__FILE__<<" "<<__LINE__<<": "<< arg << endl;

#else
#define TRACE(arg) arg
#define TRACEMSG(arg)
#endif

#endif 


