/*
	$Id: streamed_mikmod_sample.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Streamed sample header file
*/

//! component="Streamed SoundProviders"

#ifndef header_streamed_mikmod_sample
#define header_streamed_mikmod_sample

#include <stdlib.h>
#include "../core.h"

extern "C"
{
	#include <mikmod.h>
}

class CL_Streamed_MikModSample : public CL_StreamSoundProvider
{
protected:
	CL_String filename;
	CL_InputSourceProvider *inputprovider;
	bool looped;

public:
	static CL_SoundBuffer *create(const char *filename, CL_InputSourceProvider *inputprovider = NULL, bool looped = false);

	CL_Streamed_MikModSample(const char *filename, CL_InputSourceProvider *inputprovider = NULL, bool looped = false);
	virtual ~CL_Streamed_MikModSample();

	virtual CL_StreamSoundProvider_Session *begin_session();
	virtual void end_session(CL_StreamSoundProvider_Session *session);
};

class CL_Streamed_MikModSample_Session : public CL_StreamSoundProvider_Session
{
protected:
	CL_InputSource *input;

	MODULE *mf;

	SoundFormat sample_format;
	int sample_size;
	int sample_freq;
	int sample_left;
	bool looped;

public:
	CL_Streamed_MikModSample_Session(CL_InputSource *input, bool looped, const char* filename);
	virtual ~CL_Streamed_MikModSample_Session();

	virtual void stop();
	virtual bool play();
	virtual bool set_position(int pos);
	
	virtual bool eof() const;
	virtual int get_data(void *data_ptr, int data_requested);
	virtual int get_frequency() const;
	virtual SoundFormat get_format() const;
};

#endif
