/*
	$Id: displaycard_generic.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef header_displaycard_generic
#define header_displaycard_generic

#include "API/Core/Display/surfaceprovider.h"
#include "API/Core/Display/displaycard.h"
#include "API/Core/Display/cliprect.h"
#include "API/Core/System/cl_assert.h"

class CL_CardSurface;
class CL_Target;
class CL_CardSurface_Blitter;
class CL_Blitters;

#include <stack>

class CL_DisplayCard_Generic : public CL_DisplayCard
{
public:
	CL_DisplayCard_Generic(int card_no)
	{
		m_card_no = card_no;
		m_width = 0;
		m_height = 0;
		m_bpp = 0;
		m_cur_clip = CL_ClipRect(0,0,0,0);
	}

	virtual ~CL_DisplayCard_Generic() {;}
	
	virtual CL_CardSurface *create_cardsurface_video(
		CL_SurfaceProvider *provider);

	virtual CL_CardSurface *create_cardsurface_system(
		CL_SurfaceProvider *provider);

	virtual int get_card_no() { return m_card_no; }

	virtual int get_width() { return m_width; }
	virtual int get_height() { return m_height; }
	virtual int get_bpp() { return m_bpp; }
	virtual bool is_fullscreen() { return m_fullscreen; }
	virtual bool allow_resize() { return m_allow_resize; }
	
	virtual void push_clip_rect()
	{
		m_clip_stack.push(m_cur_clip);
	}

	virtual void push_clip_rect(const CL_ClipRect &clip)
	{
		push_clip_rect();
		m_cur_clip = m_cur_clip.clip(clip);
		if (get_target() != NULL) get_target()->set_clip_rect(m_cur_clip);
	}
	virtual CL_ClipRect get_clip_rect()
	{
		return m_cur_clip;
	}

	virtual void set_clip_rect(const CL_ClipRect &clip)
	{
		m_cur_clip = clip;
		if (get_target() != NULL) get_target()->set_clip_rect(m_cur_clip);
	}

	virtual void pop_clip_rect()
	{
		m_cur_clip = m_clip_stack.top();
		m_clip_stack.pop();
		if (get_target() != NULL) get_target()->set_clip_rect(m_cur_clip);
	}

	virtual void clear_display(float red=0, float green=0, float blue=0, float alpha=1);
	virtual void fill_rect(int x1, int y1, int x2, int y2, float r, float g, float b, float a);
	virtual void draw_line(int x1, int y1, int x2, int y2, float r, float g, float b, float a);
	
	virtual void sync_buffers();

	virtual CL_Target *get_frontbuffer()=0;
	void frontbuffer_lock();
	void frontbuffer_unlock();

	class CL_FlipDisplayCallback_Generic
	{
	public:
		virtual void pre_flip()=0;
		virtual void post_flip()=0;
	};

	void add_callback(CL_FlipDisplayCallback_Generic *callback)
	{
		callbacks.push_back(callback);
	}
	
	virtual void show_system_cursor()
	{
		static bool warning = true;
		if (warning)
		{
			cl_info(1, "System cursor show() not implemented for this display target.");
			warning = false;
		}
	}

	virtual void hide_system_cursor()
	{
		static bool warning = true;
		if (warning)
		{
			cl_info(1, "System cursor hide() not implemented for this display target.");
			warning = false;
		}
	}

protected:
	std::list<CL_FlipDisplayCallback_Generic*> callbacks;

	void signal_preflip()
	{
		for (std::list<CL_FlipDisplayCallback_Generic*>::iterator it = callbacks.begin();
			it!=callbacks.end(); 
			it++)
		{
			(*it)->pre_flip(); 
		}
	}

	void signal_postflip()
	{
		for (std::list<CL_FlipDisplayCallback_Generic*>::iterator it = callbacks.begin();
			it!=callbacks.end(); 
			it++)
		{
			(*it)->post_flip(); 
		}
	}

	friend CL_CardSurface_Blitter;

	void set_gfxmode(int width, int height, int bpp, bool fullscreen, bool allow_resize)
	{
		m_width = width;
		m_height = height;
		m_bpp = bpp;
		m_fullscreen = fullscreen;
		m_allow_resize = allow_resize;
		
		m_cur_clip = CL_ClipRect(0, 0, width, height);
		while (m_clip_stack.empty() == false) m_clip_stack.pop();
	}

	// Implement those to get hardware support:
	virtual CL_Blitters create_hw_blitters(CL_SurfaceProvider *provider);
	virtual CL_Blitters create_hw_dynamic_blitters(CL_SurfaceProvider *provider);

	CL_ClipRect m_cur_clip;
	std::stack<CL_ClipRect> m_clip_stack;

private:
	int m_card_no;

	int m_width;
	int m_height;
	int m_bpp;

	bool m_allow_resize;
	bool m_fullscreen;

	void fill_rect_opaque(int x1, int y1, int x2, int y2, float r, float g, float b, float a);
	
//  moved to protected, fbdev_card accesses it. 1999/08/08 fischlustig (Denis)
//	std::stack<CL_ClipRect> m_clip_stack;
//	CL_ClipRect m_cur_clip;

};

#endif
