
//! l2_component="Resources"

#ifndef header_resourcetype_font
#define header_resourcetype_font

#include "API/Core/System/clanstring.h"
#include "API/Core/Resources/resource_manager.h"

class CL_Font;
class CL_Font_Description;

class CL_Res_Font : public CL_ResourceType
//: The font resource.
// This is the font resource type. It is used load CL_Font resources from
// a datafile.
// <br>
// The resource system in ClanLib understand two types of fonts. An
// deprecated font system orignally developed in 1994 - designed to be used
// with Deluxe Paint IIe .pcx files. This is obsolete, and shouldn't be used
// anymore. We only mention it here so that you won't get confused, if you
// notice how some ClanLib demo application use strange lines using the
// three last colors in the palette to cut out the letters in the font.
// <br>
// The new alpha based font system uses a much easier way to cut out the
// letters in the font. It uses the alpha value in the image to detect where
// a letter ends, and a new one begins. Simply divide the letters by a
// horizontal line of transparent pixels.
// <br>
// Have a look at this address for an example:
// <br>
// http://dark.x.dtu.dk/~mbn/clanlib/gfx/alpha_font.tga
//!res_type: font
//!res_option: tga - Interpret this file as a targa image.
//!res_option: pcx - Interpret this file as a pcx image.
//!res_option: pos=(<xpos>, <ypos>) - Font position in image source.
//!res_option: spacelen=<width> - Pixel width of the space character.
//!res_option: tcol=(<col1>, <col2>, ...) - Transparent colors in the font.
//!res_option: letters=<ABCDEF...> - The list of letters in the font.
//!res_desc: The font resource type is used by the CL_Font class to load a font
//!res_desc: from a datafile.<br>
//!res_desc: The datafile compiler creates the font by cut each letter out of the
//!res_desc: specified image file. It uses the last three colors in the palette to
//!res_desc: do that. Color index 255 is used to find the height, 254 is used to
//!res_desc: seperate the letters (find the width), and 253 is used to break the
//!res_desc: line.<br>
//!res_desc: For an example, have a look on the Pacman demo application.
{
public:
	CL_Res_Font();

private:
friend CL_ResourceManager;
	virtual CL_Resource *create_from_location(
		std::string name,
		std::string location,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent);

	virtual CL_Resource *create_from_serialization(
		std::string name,
		CL_ResourceManager *parent);
};

class CL_Font_Resource : public CL_Resource
{
public:
	CL_Font_Resource(
		std::string name,
		std::string location,
		CL_ResourceOptions *options,
		CL_ResourceManager *parent);
		
	CL_Font_Resource(
		std::string name,
		CL_ResourceManager *parent);

	virtual ~CL_Font_Resource();

	virtual void serialize_save(CL_OutputSource *output);
	virtual void load();
	virtual void unload();
	virtual int get_load_count() { return load_count; }
	
	CL_Font_Description *get_font_desc() { return font_desc; }

private:
	void load_from_datafile();
	void load_from_file();

	CL_Font_Description *font_desc;

	CL_String location;
	CL_ResourceOptions *options;
	CL_ResourceManager *parent;
	bool from_datafile;
	int load_count;
};

#endif
