/*
	$Id: resourcetype_boolean.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Boolean resource type

*/

#include "Core/precomp.h"
#include <API/Core/Resources/resourcetype_boolean.h>

CL_Res_Boolean::CL_Res_Boolean() : CL_ResourceType("boolean")
{
}

CL_Resource *CL_Res_Boolean::create_from_location(
	std::string name,
	std::string location,
	CL_ResourceOptions *options,
	CL_ResourceManager *parent)
{
	return new CL_BooleanResource(name, location, options, parent);
}

CL_Resource *CL_Res_Boolean::create_from_serialization(
	std::string name,
	CL_ResourceManager *parent)
{
	return new CL_BooleanResource(name, parent);
}

bool CL_Res_Boolean::load(
	std::string name,
	CL_ResourceManager *manager,
	bool _default)
{
	try
	{
		CL_BooleanResource *res = (CL_BooleanResource *) manager->get_resource(name);
		return res->get_value();
	}
	catch (CL_Error err)
	{
		return _default;
	}
}

bool CL_Res_Boolean::load(
	std::string name,
	CL_ResourceManager *manager)
{
	CL_BooleanResource *res = (CL_BooleanResource *) manager->get_resource(name);
	return res->get_value();
}
