/*
	$Id: provider_convpoly_basics.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Basic convex polygon capability class

*/

#include "Core/precomp.h"
#include "API/Core/SurfaceProviders/provider_convpoly_basics.h"

CL_ConvexPolygon_Basics::CL_ConvexPolygon_Basics()
{
	changed = true;
	scanline_left = NULL;
	scanline_right = NULL;
	scanline_left_mapping = NULL;
	scanline_right_mapping = NULL;
}

CL_ConvexPolygon_Basics::~CL_ConvexPolygon_Basics()
{
	delete[] scanline_left;
	delete[] scanline_right;
	delete[] scanline_left_mapping;
	delete[] scanline_right_mapping;

	clear_points();
}

void CL_ConvexPolygon_Basics::add_point(int x, int y, int u, int v)
{
	points.push_back(new CL_ConvexPolygonPoint(x, y, u, v));
	changed = true;
}

void CL_ConvexPolygon_Basics::add_point(CL_ConvexPolygonPoint &point)
{
	points.push_back(new CL_ConvexPolygonPoint(point));
	changed = true;
}

void CL_ConvexPolygon_Basics::clear_points()
{ 
	for (unsigned int i=0;i<points.size();i++)
		delete points[i];
	points.clear(); 
	changed = true;
}

void CL_ConvexPolygon_Basics::perform_lock()
{
	if (changed)
	{
		setup();
		changed = false; 
	}
}

void CL_ConvexPolygon_Basics::perform_unlock()
{
}

void CL_ConvexPolygon_Basics::calc_boundary()
{
	int x; unsigned int p;

	min_x = 100000;
	max_x = -100000;

	min_y = 100000;
	max_y = -100000;

	x = 100000;
	for (p=0; p<points.size(); p++)
	{
		if (points[p]->x < min_x) min_x = points[p]->x;
		if (points[p]->x > max_x) max_x = points[p]->x;

		if (points[p]->y <= min_y)
		{
			if (points[p]->y == min_y && points[p]->x >= x) continue;

			top_point = p;
			x = points[p]->x;
			min_y = points[p]->y;
		}
	}

	x = 100000;
	for (p=0; p<points.size(); p++)
	{
		if (points[p]->y >= max_y)
		{
			if (points[p]->y == max_y && points[p]->x >= x) continue;

			bottom_point = p;
			x = points[p]->x;
			max_y = points[p]->y;
		}
	}
}

void CL_ConvexPolygon_Basics::draw_scanline(int *dest, int x1, int y1, int x2, int y2)
{
	int dx = x1-x2;
	int dy = y1-y2;

	if (dx == 0)
	{
		int maxy = max(y1, y2);
		for (int i=min(y1, y2);i<=maxy;i++) dest[i] = x1;
	}
	else if (dy == 0)
	{
		dest[y1] = x1 > x2 ? x1 : x2;
	}
	else
	{
		int miny, maxy;
		float xpos, xd;
		if (y1 > y2)
		{
			miny = y2;
			maxy = y1;

			xpos = x2;
			xd = float(dx) / (maxy-miny);
		}
		else
		{
			miny = y1;
			maxy = y2;

			xpos = x1;
			xd = float(x2-x1) / (maxy-miny);
		}
		
		for (int i=miny;i<=maxy;i++)
		{
			dest[i] = int(xpos);
			xpos += xd;
		}
	}
}

void CL_ConvexPolygon_Basics::create_scanline(int start_point, int end_point, int **scanline, int **scanline_mapping)
{
	int delta_height = max_y - min_y + 1;
	*scanline = new int[delta_height];
	*scanline_mapping = new int[delta_height*2];

	int from_point;
	int to_point = start_point;

	do
	{
		from_point = to_point;
		to_point++;
		if (to_point == (int) points.size()) to_point = 0;

		CL_ConvexPolygonPoint *from = points[from_point];
		CL_ConvexPolygonPoint *to = points[to_point];

		draw_scanline(*scanline, from->x-min_x, from->y-min_y, to->x-min_x, to->y-min_y);
		draw_scanline(*scanline_mapping, from->u, from->y-min_y, to->u, to->y-min_y);
		draw_scanline(*scanline_mapping+delta_height, from->v, from->y-min_y, to->v, to->y-min_y);

	} while (to_point != end_point);
}


void CL_ConvexPolygon_Basics::setup()
{
	delete[] scanline_left;
	delete[] scanline_right;
	delete[] scanline_left_mapping;
	delete[] scanline_right_mapping;


//	int start = CL_System::get_time();
	calc_boundary();

	create_scanline(top_point, bottom_point, &scanline_left, &scanline_left_mapping);
	create_scanline(bottom_point, top_point, &scanline_right, &scanline_right_mapping);

//	cout << "Time taken for creating scanlines: " << CL_System::get_time() - start << endl;
}
