/*
	$Id: mutex_win32.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include "mutex_win32.h"

/*************************************
 Generic static create-mutex function
*************************************/

CL_Mutex *CL_Mutex::create()
{
	return new CL_Mutex_Win32;
}

/*************************************
        class CL_Mutex_Win32
*************************************/

CL_Mutex_Win32::CL_Mutex_Win32()
{
	InitializeCriticalSection(&mutex);
}

CL_Mutex_Win32::~CL_Mutex_Win32()
{
	DeleteCriticalSection(&mutex);
}

void CL_Mutex_Win32::enter()
{
	EnterCriticalSection(&mutex);
}

void CL_Mutex_Win32::leave()
{
	LeaveCriticalSection(&mutex);
}
