/*
	$Id: cl_grootwindow.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "../API/GUI/cl_grootwindow.h"
//#include "uscreensurface.h"
//#include "udebug.h"
//#include "cl_gapplication.h"

#include <assert.h>

CL_GRootWindow::CL_GRootWindow(int resX, int resY, int bpp, bool fullscreen) :
  CL_GWidget(),
  fullscreen_(fullscreen)
{
//  UOBJECT_INIT(URootWindow);

//lp  debugN(17,cerr << "creating URootWindow...";);
	TRACEMSG("creating CL_GRootWindow");
  //set up CL_GRect members
  upperLeft_ = CL_GPoint(0,0);
  lowerRight_ = CL_GPoint(resX, resY);

  rect_ = CL_GRect(0,0,resX, resY);
  window_ = CL_GRect(0,0,resX, resY);

  parent_ = 0;

  initMembers();

  
//  surface_ = new UScreenSurface(resX, resY, bpp, fullscreen);
//	surface_ = CL_Surface::create(new CL_Canvas(resX, resY, 1, 0xff000000, 0x00ff0000, 0x0000ff00, 0), true);
	
	surface_ = CL_Surface::create(new CL_Canvas(resX, resY), true);
//  fullscreen_ = static_cast<UScreenSurface*>(surface_)->fullscreen();

	if(fullscreen_)
	{
		screen_ = surface_;
      //tripple buffering ... some what slow .... need to think of a better way
//      surface_ = new USurface(resX, resY);
//		surface_ = CL_Surface::create(new CL_Canvas(resX, resY, 1, 0xff000000, 0x00ff0000, 0x0000ff00, 0), true);
	surface_ = CL_Surface::create(new CL_Canvas(resX, resY), true);
//     surface_->setTransparency(false);
    }
  else
    {
      screen_ = 0;
    }
  
  parentSurface_ = 0;

//  debugN(17,cerr << "done." << endl;);
	TRACEMSG("done creating CL_GRootWindow")

}


CL_GRootWindow::~CL_GRootWindow()
{
  if(screen_ != 0)
    delete screen_;
}

void CL_GRootWindow::setTitle(const char *title)
{
//  SDL_WM_SetCaption(title, 0);
}




void CL_GRootWindow::update()
{

  if(hidden_ || closed_)
    return;

  if(disabled_)
    return;

  //debugN(17,cerr << this->name() << " gets updated." << endl;);

  //ignore disable and hide requests
  if(hideRequest_)
    {
      hideRequest_ = false;
      //      hidden_ = true;
    }

  if(disableRequest_)
    {
      disableRequest_ = false;
      //      disabled_ = true;
    }
  
  bool update_ = needsUpdate_;

  createChild();
 
  if(needsReblit_ || update_)
    {
      dirtyRects_.push_back(globalCoord(window_));
    }

//   //create the child widgets..
//   createChilds();

  std::list<CL_GWidget*> closeList;
//lp  MARK
  ///child list iterator.
  std::list<CL_GWidget*>::iterator childItr_;
  childItr_ = childs_.begin();
  while(childItr_ != childs_.end())
    {
      //we must not call update() of an closed widget here
      //since closed widgets selfdestruct when calling update()
      if(!(*childItr_)->isClosed())
	{	  
//lp	 MARK
	  //only update other widgets, if no dialog is present
	  if((*childItr_)->needsUpdate() && dialogs_.empty())
	    (*childItr_)->update();
//lp	 MARK	
	  if(update_)
	    (*childItr_)->blit();
//lp  MARK	
	}      
      else
	{
	  closeList.push_back(*childItr_);
	  needsUpdate_ = true;
	}
      
      (*childItr_)->addUpdateRects(dirtyRects_);
      
      childItr_ ++;
    }
//lp    MARK
  if(dialogs_.size() > 0)
    {
      //special treatment for dialogs (modal)
      //bring it ALWAYS to the front
      if(!dialogs_.back()->isClosed())
	{	 
 	  if(dialogs_.back()->needsUpdate())
	    dialogs_.back()->update();
	  else
	    if(update_)
	      dialogs_.back()->blit();	  
	}      
      else	
	{
	  closeList.push_back(dialogs_.back());
	  needsUpdate_ = true;
	}

      dialogs_.back()->addUpdateRects(dirtyRects_);
    }
//lp  MARK
  //kill the ones which are already dead (?)
  CL_GWidget *childPtr;
  while(!closeList.empty())
    {
      childPtr = closeList.front();
      closeList.pop_front();
      //deleting a child modifies list badly
      //this is why the local copy childPtr is needed here
      delete childPtr;
    }
//lp  MARK
  needsReblit_ = false;

}

void CL_GRootWindow::refreshRect(const CL_GRect& rect)
{
  dirtyRects_.push_back(rect);
  // needsUpdate_ = true;
}


void CL_GRootWindow::updateScreen()
{
//lp    MARK
	if(fullscreen_)
	{
		if(!dirtyRects_.empty())
		{
			CL_GRect dest;
			CL_GRect src;
			std::list<CL_GRect>::iterator itr = dirtyRects_.begin();
			CL_SurfaceProvider *prov = screen_->get_provider();
//			surface_->reload();
			while(itr != dirtyRects_.end())
			{
				src = localCoord(*itr);
				dest = *itr;
//lp	      surface_->blit(screen_, dest, src);	
				prov->push_clip_rect(
					CL_ClipRect(
						dest.upperLeft().x,
						dest.upperLeft().y,
						dest.lowerRight().x,
						dest.lowerRight().y));
				surface_->put_target(0,0,0, prov);
				prov->pop_clip_rect();
				itr++;
			}
			screen_->reload();			
		}

/*******/
//		screen_->reload();
		screen_->put_screen(0,0); // i think this is where this goes...
		CL_Display::flip_display();
//      static_cast<UScreenSurface*>(screen_)->flip();
/*******/
	}
	else
	{
		if(!dirtyRects_.empty())
		{
			CL_GRect dest;
			std::list<CL_GRect>::iterator itr = dirtyRects_.begin();
//lp MARK
			while(itr != dirtyRects_.end())
			{
	      //lp MARK
				dest = *itr;
/******/	
//lp	     static_cast<UScreenSurface*>(surface_)->update(dest);	
/******/
				itr++;
			}
		}
	}
    
	dirtyRects_.clear();
      //lp MARK
}


bool CL_GRootWindow::runDialog(CL_GWidget* dialog)
{
  assert(dialog != 0);

//   bool found = false;

//   //all widgets except for dialog_ get disabled
//   std::list<UWidget*>::iterator childItr_;
//   childItr_ = childs_.begin();
//   while(childItr_ != childs_.end())
//     {
//       if(dialog != (*childItr_))
// 	 (*childItr_)->disable();
//       else
// 	found = true;
//       childItr_ ++;
//     }  

//   if (!found)
//     {
//       cerr << name()
// 	   << ": the dialog " << dialog->name() 
// 	   << " is not a child of us ! " << endl;
//       enable();
//       return false;
//     }

//   //disable all
//   disable();
//   //reenable the new dialog
//   dialog->enable();

  dialogs_.push_back(dialog);
  needsUpdate_ = true;

  return true;
}



bool CL_GRootWindow::closeDialog()
{

  if(dialogs_.size() == 0)
    {
//      cerr << name()
	   cerr << ": there is no dialog to close !" << endl;
      return false;
    }

  dialogs_.pop_back();

//   if(dialogs_.size() == 0)
//     {
//       //no dialogs anymore, so enable all
//       enable();
//     }
//   else
//     {
//       //enable only the topmost dialog
//       dialogs_.back()->enable();
//     }

  needsUpdate_ = true;

  return true;
}

 
bool CL_GRootWindow::processEvent(const CL_GEvent* event)
{
  bool processed = false;

  if(dialogs_.size() > 0)
    {
      //a modal dialog is open, so it will receive all events
      dialogs_.back()->handleEvent(event);
      
      //we swallow this event, so no one else may react
      processed = true;
    }

  return processed;
}

void CL_GRootWindow::sync()
{ 
  update(); 
  updateScreen(); 
}















