(in-package "USER")

(load "setenv-common")

(setf (ext:search-list "target:")
	   '(	"./x86-cross/"      ; object dir
        	"./src/"))   ; source dir

(setf (ext:search-list "bootstrap:") (ext:search-list "target:"))

(push :bootstrap *features*)
(push :no-pcl *features*)

(compile-file  "target:tools/setup" :load t)
;;; Compile the compiler
(load "target:tools/comcom")

;;; Define a bunch of search lists relative to target:
;;;
(setf (ext:search-list "code:") '("target:code/"))
(setf (ext:search-list "c:") '("target:compiler/"))
(setf (ext:search-list "vm:")
      '(#+(or pmax sgi) "c:mips/"
        #+sparc "c:sparc/"
	#+rt "c:rt/"
	#+hppa "c:hppa/"
	#+x86 "c:x86/"
	#+alpha "c:alpha/"
	"c:generic/"))
(setf (ext:search-list "assem:")
      '(#+(or pmax sgi) "target:assembly/mips/"
	#+sparc "target:assembly/sparc/"
	#+rt "target:assembly/rt/"
	#+hppa "target:assembly/hppa/"
	#+x86 "target:assembly/x86/"
	#+alpha "target:assembly/alpha/"
	"target:assembly/"))
(setf (ext:search-list "hem:") '("target:hemlock/"))
(setf (ext:search-list "clx:") '("target:clx/"))
(setf (ext:search-list "pcl:") '("target:pcl/"))
(setf (ext:search-list "tools:") '("target:tools/"))

;;; Load in the new compiler
(progn
  (load "c:loadcom.lisp")
  (load "c:loadbackend.lisp"))

;;; Compile the world and the compiler again
(setf *features* (remove :bootstrap *features*))
(setf (ext:search-list "target:")
	   '(	"./x86/"      ; object dir
        	"./src/"))   ; source dir
;;; Don't load the compiler parts in this time.
(in-package "C")
(let ((new-backend (copy-backend *backend*)))
  (setf (backend-name new-backend) "X86-fake")
  (setf *backend* new-backend))
(in-package "USER")

(export 'x86::check-bignum 'c)
(load "target:tools/worldcom")		; Builds most of lisp

(setq *load-stuff* nil)
(load "target:tools/comcom")		; Build Python and backend
(compile-file  "target:tools/setup")
(load "bootstrap:compiler/generic/new-genesis")
(load "target:tools/worldbuild")	; Make a new kernel.core
