/*
*
* rm.c - COBEX - Remove a file from a device.
*
* Copyright 2006 Fredrik Srensson
*
* History:
* v0.1 - fsn - 06-02-22 - First version
* v0.2 - fsn - 06-07-29 - Code cleanup
*
* Source:
*
*/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <signal.h>
#include <string.h>

#include "cobex_core.h"
#include "cobex_tools.h"
#include "cobex_serial.h"

void help () {
	printf ("cobex_rm v0.6\n\n");
	printf ("Usage: cobex_rm <device> <filename>\n\n");
	printf ("All arguments are compulsory and order is important.\n\n");
}

// Main routine

int main (int argc, char *argv[]) {
	static char fsBrowser[]={ 0xf9, 0xec, 0x7b, 0xc4, 0x95, 0x3c, 0x11, 0xd2, 0x98, 0x4e, 0x52, 0x54, 0x00, 0xdc, 0x9e, 0x09, 0x00};
	v24_port_t *UsedPort=NULL;
	
	int rc;

	char aBuffer[513];
	obex_packet aPacket;

	aPacket.max=512;
	aPacket.buffer=aBuffer;
	
	char *name;
	char *path;

	if (argc != 3) {
		printf ("ERR: Wrong argc : %d.\n",argc);
		help();
		return 1;
	}

	// Set up the port

	rc = ctools_commonInit( &UsedPort, &aPacket, argv[1], fsBrowser );
	if (rc != COBEX_OK) { exit (COBEX_ERR); }	

	// Do the specific things

	path = calloc( strlen(argv[2])+1, sizeof(char) );	// Allocate memory
	name = calloc( strlen(argv[2])+1, sizeof(char) );
	
	ctools_buildPath ( argv[2], path, name );		// Determine the pathname/filename
	rc=ctools_recursePath( &aPacket, path, UsedPort, OBEX_SETPATH_DONTCREATE ); // Descend to the last level
	rc=ctools_deleteFile( &aPacket, name, UsedPort);	// Delete file
			if (cobex_response_code(&aPacket) != (OBEX_RESPONSE_OK|OBEX_FINAL_BIT) ) {
		fprintf (stderr, "ERR: %s \n",
			cobex_respstring(cobex_response_code(&aPacket)) ) ;
		rc=COBEX_ERR;
	}

	free (path);						// Deallocate memory
	free (name);
	ctools_disconnect( &aPacket, UsedPort );		// Disconnect from OBEX
	cobex_closePort(UsedPort);				// Close the port
	
	return rc;

}

