/***************************************************************
 *
 * Copyright (C) 1990-2007, Condor Team, Computer Sciences Department,
 * University of Wisconsin-Madison, WI.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/


#include "condor_common.h"
#include "command_strings.h"

const struct Translation DCTranslation[] = {
	{ "QMGMT_READ_CMD", QMGMT_READ_CMD }, 
	{ "QMGMT_WRITE_CMD", QMGMT_WRITE_CMD }, 
	{ "CONTINUE_FRGM_JOB", CONTINUE_FRGN_JOB },
	{ "CONTINUE_CLAIM", CONTINUE_CLAIM },
	{ "SUSPEND_FRGN_JOB", SUSPEND_FRGN_JOB },
	{ "SUSPEND_CLAIM", SUSPEND_CLAIM },
	{ "CKPT_FRGN_JOB", CKPT_FRGN_JOB },
	{ "DEACTIVATE_CLAIM", DEACTIVATE_CLAIM },
	{ "KILL_FRGN_JOB", KILL_FRGN_JOB },
	{ "DEACTIVATE_CLAIM_FORCIBLY", DEACTIVATE_CLAIM_FORCIBLY },
	{ "LOCAL_STATUS", LOCAL_STATUS },
	{ "LOCAL_STATISTICS", LOCAL_STATISTICS },
	{ "PERMISSION", PERMISSION },
	{ "SET_DEBUG_FLAGS", SET_DEBUG_FLAGS },
	{ "PREEMPT_LOCAL_JOBS", PREEMPT_LOCAL_JOBS },
	{ "RM_LOCAL_JOB", RM_LOCAL_JOB },
	{ "START_FRGN_JOB", START_FRGN_JOB },
	{ "AVAILABILITY", AVAILABILITY },
	{ "NUM_FRGN_JOBS", NUM_FRGN_JOBS },
	{ "STARTD_INFO", STARTD_INFO },
	{ "SCHEDD_INFO", SCHEDD_INFO },
	{ "NEGOTIATE", NEGOTIATE },
	{ "NEGOTIATE_WITH_SIGATTRS", NEGOTIATE_WITH_SIGATTRS},
	{ "SEND_JOB_INFO", SEND_JOB_INFO },
	{ "NO_MORE_JOBS", NO_MORE_JOBS },
	{ "JOB_INFO", JOB_INFO },
	{ "GIVE_STATUS", GIVE_STATUS },
	{ "RESCHEDULE", RESCHEDULE },
	{ "PING", PING },
	{ "NEGOTIATOR_INFO", NEGOTIATOR_INFO },
	{ "GIVE_STATUS_LINES", GIVE_STATUS_LINES },
	{ "END_NEGOTIATE", END_NEGOTIATE },
	{ "REJECTED", REJECTED },
	{ "X_EVENT_NOTIFICATION", X_EVENT_NOTIFICATION },
	{ "RECONFIG", RECONFIG },
	{ "GET_HISTORY", GET_HISTORY },
	{ "UNLINK_HISTORY_FILE", UNLINK_HISTORY_FILE },
	{ "UNLINK_HISTORY_FILE_DONE", UNLINK_HISTORY_FILE_DONE },
	{ "DO_NOT_UNLINK_HISTORY_FILE", DO_NOT_UNLINK_HISTORY_FILE },
	{ "SEND_ALL_JOBS", SEND_ALL_JOBS },
	{ "SEND_ALL_JOBS_PRIO", SEND_ALL_JOBS_PRIO },
	{ "REQ_NEW_PROC", REQ_NEW_PROC },
	{ "PCKPT_FRGN_JOB", PCKPT_FRGN_JOB },
	{ "SEND_RUNNING_JOBS", SEND_RUNNING_JOBS },
	{ "CHECK_CAPABILITY", CHECK_CAPABILITY },
	{ "GIVE_PRIORITY", GIVE_PRIORITY },
	{ "MATCH_INFO", MATCH_INFO },
	{ "ALIVE", ALIVE },
	{ "REQUEST_CLAIM", REQUEST_CLAIM },
	{ "RELEASE_CLAIM", RELEASE_CLAIM },
	{ "ACTIVATE_CLAIM", ACTIVATE_CLAIM },
	{ "PRIORITY_INFO", PRIORITY_INFO },
	{ "PCKPT_ALL_JOBS", PCKPT_ALL_JOBS },
	{ "VACATE_ALL_CLAIMS", VACATE_ALL_CLAIMS },
	{ "GIVE_STATE", GIVE_STATE },
	{ "SET_PRIORITY", SET_PRIORITY },
	{ "GIVE_CLASSAD", GIVE_CLASSAD },
	{ "GET_PRIORITY", GET_PRIORITY },
	{ "GIVE_REQUEST_AD", GIVE_REQUEST_AD },
	{ "RESTART", RESTART },
	{ "RESTART_PEACEFUL", RESTART_PEACEFUL },
	{ "DAEMONS_OFF", DAEMONS_OFF },
	{ "DAEMONS_ON", DAEMONS_ON },
	{ "MASTER_OFF", MASTER_OFF },
	{ "CONFIG_VAL", CONFIG_VAL },
	{ "RESET_USAGE", RESET_USAGE },
	{ "DELETE_USER", DELETE_USER },
	{ "SET_PRIORITYFACTOR", SET_PRIORITYFACTOR },
	{ "RESET_ALL_USAGE", RESET_ALL_USAGE },
	{ "DAEMONS_OFF_FAST", DAEMONS_OFF_FAST },
	{ "DAEMONS_OFF_PEACEFUL", DAEMONS_OFF_PEACEFUL },
	{ "MASTER_OFF_FAST", MASTER_OFF_FAST },
	{ "GET_RESLIST", GET_RESLIST },
	{ "ATTEMPT_ACCESS", ATTEMPT_ACCESS },
	{ "VACATE_CLAIM", VACATE_CLAIM },
	{ "PCKPT_JOB", PCKPT_JOB },
	{ "DAEMON_OFF", DAEMON_OFF },
	{ "DAEMON_OFF_FAST", DAEMON_OFF_FAST },
	{ "DAEMON_OFF_PEACEFUL", DAEMON_OFF_PEACEFUL },
	{ "DAEMON_ON", DAEMON_ON },
	{ "GIVE_TOTALS_CLASSAD", GIVE_TOTALS_CLASSAD },
	{ "DUMP_STATE", DUMP_STATE },
	{ "PERMISSION_AND_AD", PERMISSION_AND_AD },
	{ "REQUEST_NETWORK", REQUEST_NETWORK },
	{ "VACATE_ALL_FAST", VACATE_ALL_FAST },
	{ "VACATE_CLAIM_FAST", VACATE_CLAIM_FAST },
	{ "REJECTED_WITH_REASON", REJECTED_WITH_REASON },
	{ "START_AGENT", START_AGENT },
	{ "ACT_ON_JOBS", ACT_ON_JOBS },
	{ "CA_AUTH_CMD", CA_AUTH_CMD },
	{ "CA_CMD", CA_CMD },
	{ "CA_REQUEST_CLAIM", CA_REQUEST_CLAIM },
	{ "CA_RELEASE_CLAIM", CA_RELEASE_CLAIM },
	{ "CA_ACTIVATE_CLAIM", CA_ACTIVATE_CLAIM },
	{ "CA_DEACTIVATE_CLAIM", CA_DEACTIVATE_CLAIM },
	{ "CA_SUSPEND_CLAIM", CA_SUSPEND_CLAIM },
	{ "CA_RESUME_CLAIM", CA_RESUME_CLAIM },
	{ "CA_RENEW_LEASE_FOR_CLAIM", CA_RENEW_LEASE_FOR_CLAIM },
	{ "CA_LOCATE_STARTER", CA_LOCATE_STARTER },
	{ "CA_RECONNECT_JOB", CA_RECONNECT_JOB },
	{ "DC_SIGSUSPEND", DC_SIGSUSPEND },
	{ "DC_SIGCONTINUE", DC_SIGCONTINUE },
	{ "DC_SIGSOFTKILL", DC_SIGSOFTKILL },
	{ "DC_SIGHARDKILL", DC_SIGHARDKILL },
	{ "DC_SIGPCKPT", DC_SIGPCKPT },
	{ "DC_SIGREMOVE", DC_SIGREMOVE },
	{ "DC_SIGHOLD", DC_SIGHOLD },
	{ "DC_RAISESIGNAL", DC_RAISESIGNAL },
	{ "DC_CONFIG_PERSIST", DC_CONFIG_PERSIST },
	{ "DC_CONFIG_RUNTIME", DC_CONFIG_RUNTIME },
	{ "DC_RECONFIG", DC_RECONFIG },
	{ "DC_RECONFIG_FULL", DC_RECONFIG_FULL },
	{ "DC_OFF_GRACEFUL", DC_OFF_GRACEFUL },
	{ "DC_OFF_FAST", DC_OFF_FAST },
	{ "DC_OFF_PEACEFUL", DC_OFF_PEACEFUL },
	{ "DC_CONFIG_VAL", DC_CONFIG_VAL },
	{ "DC_CHILDALIVE", DC_CHILDALIVE },
	{ "DC_FETCH_LOG", DC_FETCH_LOG },
	{ "DC_INVALIDATE_KEY", DC_INVALIDATE_KEY },
	{ "FILETRANS_UPLOAD", FILETRANS_UPLOAD },
	{ "FILETRANS_DOWNLOAD", FILETRANS_DOWNLOAD },
	{ "PW_SETPASS", PW_SETPASS },
	{ "PW_GETPASS", PW_GETPASS },
	{ "PW_CLEARPASS", PW_CLEARPASS },
	{ "SHADOW_UPDATEINFO", SHADOW_UPDATEINFO },
	{ "TAKE_MATCH", TAKE_MATCH },
	{ "MPI_START_COMRADE", MPI_START_COMRADE },
	{ "CHILD_OFF", CHILD_OFF },
	{ "CHILD_OFF_FAST", CHILD_OFF_FAST },
	{ "CHILD_ON", CHILD_ON },
	{ "VM_REGISTER", VM_REGISTER },
	{ "DELEGATE_GSI_CRED_SCHEDD", DELEGATE_GSI_CRED_SCHEDD },
	{ "DELEGATE_GSI_CRED_STARTER", DELEGATE_GSI_CRED_STARTER },
	{ "DELEGATE_GSI_CRED_STARTD", DELEGATE_GSI_CRED_STARTD },
	{ "REQUEST_SANDBOX_LOCATION", REQUEST_SANDBOX_LOCATION },
	/* maybe not right place, but so what for now */
	{ "TRANSFERD_CONTROL_CHANNEL", TRANSFERD_CONTROL_CHANNEL},
	{ "TRANSFERD_WRITE_FILES", TRANSFERD_WRITE_FILES},
	{ "TRANSFERD_READ_FILES", TRANSFERD_READ_FILES},
	{ "VM_UNIV_GAHP_ERROR", VM_UNIV_GAHP_ERROR },
	{ "VM_UNIV_VMPID", VM_UNIV_VMPID },
	{ "VM_UNIV_GUEST_IP", VM_UNIV_GUEST_IP },
	{ "VM_UNIV_GUEST_MAC", VM_UNIV_GUEST_MAC },
	{ "LEASE_MANAGER_GET_LEASES", LEASE_MANAGER_GET_LEASES },
	{ "LEASE_MANAGER_RENEW_LEASE", LEASE_MANAGER_RENEW_LEASE },
	{ "LEASE_MANAGER_RELEASE_LEASE", LEASE_MANAGER_RELEASE_LEASE },
	{ "CCB_REGISTER", CCB_REGISTER },
	{ "CCB_REQUEST", CCB_REQUEST },
	{ "CCB_REVERSE_CONNECT", CCB_REVERSE_CONNECT },
	{ "GET_JOB_CONNECT_INFO", GET_JOB_CONNECT_INFO },
	{ "CREATE_JOB_OWNER_SEC_SESSION", CREATE_JOB_OWNER_SEC_SESSION },
	{ "START_SSHD", START_SSHD },
	{ "SHARED_PORT_CONNECT", SHARED_PORT_CONNECT },
	{ "SHARED_PORT_PASS_SOCK", SHARED_PORT_PASS_SOCK },
	{ "RECYCLE_SHADOW", RECYCLE_SHADOW },
        { "CLEAR_DIRTY_JOB_ATTRS", CLEAR_DIRTY_JOB_ATTRS },
        { "UPDATE_JOBAD", UPDATE_JOBAD },
	{ "DRAIN_JOBS", DRAIN_JOBS },
	{ "CANCEL_DRAIN_JOBS", CANCEL_DRAIN_JOBS },
	{ NULL, 0 }
};

const struct Translation CollectorTranslation[] = {
	{ "UPDATE_STARTD_AD", UPDATE_STARTD_AD },
    { "UPDATE_STARTD_AD_WITH_ACK", UPDATE_STARTD_AD_WITH_ACK },
	{ "UPDATE_SCHEDD_AD", UPDATE_SCHEDD_AD },
	{ "UPDATE_MASTER_AD", UPDATE_MASTER_AD },
	{ "UPDATE_GATEWAY_AD", UPDATE_GATEWAY_AD },
	{ "UPDATE_CKPT_SRVR_AD", UPDATE_CKPT_SRVR_AD },
	{ "UPDATE_NEGOTIATOR_AD", UPDATE_NEGOTIATOR_AD },
	{ "UPDATE_HAD_AD", UPDATE_HAD_AD },
	{ "UPDATE_XFER_SERVICE_AD", UPDATE_XFER_SERVICE_AD },
	{ "UPDATE_LEASE_MANAGER_AD", UPDATE_LEASE_MANAGER_AD },
	{ "UPDATE_AD_GENERIC", UPDATE_AD_GENERIC },
	{ "QUERY_STARTD_ADS", QUERY_STARTD_ADS },
	{ "QUERY_SCHEDD_ADS", QUERY_SCHEDD_ADS },
	{ "QUERY_MASTER_ADS", QUERY_MASTER_ADS },
	{ "QUERY_GATEWAY_ADS", QUERY_GATEWAY_ADS },
	{ "QUERY_CKPT_SRVR_ADS", QUERY_CKPT_SRVR_ADS },
	{ "QUERY_STARTD_PVT_ADS", QUERY_STARTD_PVT_ADS },
	{ "QUERY_NEGOTIATOR_ADS", QUERY_NEGOTIATOR_ADS },
	{ "QUERY_HAD_ADS", QUERY_HAD_ADS },
	{ "QUERY_XFER_SERVICE_ADS", QUERY_XFER_SERVICE_ADS },
	{ "QUERY_LEASE_MANAGER_ADS", QUERY_LEASE_MANAGER_ADS },
	{ "UPDATE_SUBMITTOR_AD", UPDATE_SUBMITTOR_AD },
	{ "QUERY_SUBMITTOR_ADS", QUERY_SUBMITTOR_ADS },
	{ "INVALIDATE_STARTD_ADS", INVALIDATE_STARTD_ADS },
	{ "INVALIDATE_SCHEDD_ADS", INVALIDATE_SCHEDD_ADS },
	{ "INVALIDATE_MASTER_ADS", INVALIDATE_MASTER_ADS },
	{ "INVALIDATE_GATEWAY_ADS", INVALIDATE_GATEWAY_ADS },
	{ "INVALIDATE_CKPT_SRVR_ADS", INVALIDATE_CKPT_SRVR_ADS },
	{ "INVALIDATE_SUBMITTOR_ADS", INVALIDATE_SUBMITTOR_ADS },
	{ "INVALIDATE_NEGOTIATOR_ADS", INVALIDATE_NEGOTIATOR_ADS },
	{ "INVALIDATE_HAD_ADS", INVALIDATE_HAD_ADS },
	{ "INVALIDATE_XFER_SERVICE_ADS", INVALIDATE_XFER_SERVICE_ADS },
	{ "INVALIDATE_LEASE_MANAGER_ADS", INVALIDATE_LEASE_MANAGER_ADS },
	{ "INVALIDATE_ADS_GENERIC", INVALIDATE_ADS_GENERIC },
	{ "UPDATE_COLLECTOR_AD", UPDATE_COLLECTOR_AD },
	{ "QUERY_COLLECTOR_ADS", QUERY_COLLECTOR_ADS },
	{ "INVALIDATE_COLLECTOR_ADS", INVALIDATE_COLLECTOR_ADS },
	{ "QUERY_HIST_STARTD", QUERY_HIST_STARTD },
	{ "QUERY_HIST_STARTD_LIST", QUERY_HIST_STARTD_LIST },
	{ "QUERY_HIST_SUBMITTOR", QUERY_HIST_SUBMITTOR },
	{ "QUERY_HIST_SUBMITTOR_LIST", QUERY_HIST_SUBMITTOR_LIST },
	{ "QUERY_HIST_GROUPS", QUERY_HIST_GROUPS },
	{ "QUERY_HIST_GROUPS_LIST", QUERY_HIST_GROUPS_LIST },
	{ "QUERY_HIST_SUBMITTORGROUPS", QUERY_HIST_SUBMITTORGROUPS },
	{ "QUERY_HIST_SUBMITTORGROUPS_LIST", QUERY_HIST_SUBMITTORGROUPS_LIST },
	{ "QUERY_HIST_CKPTSRVR", QUERY_HIST_CKPTSRVR },
	{ "QUERY_HIST_CKPTSRVR_LIST", QUERY_HIST_CKPTSRVR_LIST },
	{ "UPDATE_LICENSE_AD", UPDATE_LICENSE_AD },
	{ "QUERY_LICENSE_ADS", QUERY_LICENSE_ADS },
	{ "INVALIDATE_LICENSE_ADS", INVALIDATE_LICENSE_ADS },
	{ "UPDATE_STORAGE_AD", UPDATE_STORAGE_AD },
	{ "QUERY_STORAGE_ADS", QUERY_STORAGE_ADS },
	{ "INVALIDATE_STORAGE_ADS", INVALIDATE_STORAGE_ADS },
	{ "QUERY_ANY_ADS", QUERY_ANY_ADS },
	{ "STARTER_HOLD_JOB", STARTER_HOLD_JOB },
	{ "UPDATE_GRID_AD", UPDATE_GRID_AD },
	{ "QUERY_GRID_ADS", QUERY_GRID_ADS },
	{ "INVALIDATE_GRID_ADS", INVALIDATE_GRID_ADS },
	{ "MERGE_STARTD_AD", MERGE_STARTD_AD },
	{ NULL, 0 }
};


const struct Translation CAResultTranslation[] = {
	{ "Success", CA_SUCCESS },
	{ "Failure", CA_FAILURE },
	{ "NotAuthenticated", CA_NOT_AUTHENTICATED },
	{ "NotAuthorized", CA_NOT_AUTHORIZED },
	{ "InvalidRequest", CA_INVALID_REQUEST },
	{ "InvalidState", CA_INVALID_STATE },
	{ "InvalidReply", CA_INVALID_REPLY },
	{ "LocateFailed", CA_LOCATE_FAILED },
	{ "ConnectFailed", CA_CONNECT_FAILED },
	{ "CommunicationError", CA_COMMUNICATION_ERROR },
	{ NULL, 0 }
};

const struct Translation DrainingScheduleTranslation[] = {
	{ "graceful", DRAIN_GRACEFUL },
	{ "quick", DRAIN_QUICK },
	{ "fast", DRAIN_FAST },
	{ NULL, 0 }
};


const char*
getCommandString( int num )
{
	char const *result = getNameFromNum( num, DCTranslation );
	if( !result ) {
		return getCollectorCommandString(num);
	}
	return result;
}


int
getCommandNum( const char* command )
{
	int result = getNumFromName( command, DCTranslation );
	if( -1 == result ) {
		return getCollectorCommandNum(command);
	}
	return result;
}

const char*
getCollectorCommandString( int num )
{
	return getNameFromNum( num, CollectorTranslation );
}

int
getCollectorCommandNum( const char* command )
{
	return getNumFromName( command, CollectorTranslation );
}

const char*
getCAResultString( CAResult r )
{
	return getNameFromNum( (int)r, CAResultTranslation );
}

CAResult
getCAResultNum( const char* str )
{
	return (CAResult)getNumFromName( str, CAResultTranslation );
}

int
getDrainingScheduleNum( char const *name )
{
	return getNumFromName( name, DrainingScheduleTranslation );
}

char const *
getDrainingScheduleName( int num )
{
	return getNameFromNum( num, DrainingScheduleTranslation );
}
