(***********************************************************************)
(*                          Configwin                                  *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

let _ = GMain.Main.init ()

open Configwin.Types

let param1 = String_param { string_label = "a string" ;
			    string_value = "a value" ;
			    string_editable = true ;
			    string_f_apply = (fun s -> ()) }

    
let param2 = Bool_param { bool_label = "a boolean" ;
			  bool_value = true ;
			  bool_editable = true ;
			  bool_f_apply = (fun b -> ()) }


let param3 = Filename_param { string_label = "a file name" ;
			      string_value = "foo" ;
			      string_editable = true ;
 			      string_f_apply = (fun s -> ()) }


let param4 = Strings_param { strings_label = "a string list" ;
			     strings_value = ["foo" ; "bar"] ;
			     strings_editable = true ;
			     strings_f_add = (fun () -> ["another string" ; "and another string"]) ;
			     strings_f_apply = (fun s -> ()) }


let param5 = Color_param { color_label = "a color" ;
			   color_value = "Red" ;
			   color_editable = true ;
			   color_f_apply = (fun s -> ()) }



let structure = Section_list ("Section 1", 
			      [
				Section ("Section 1.1",
					 [ param1 ; param2 ; param5 ]);
				Section ("Section 1.2",
					 [ param3 ; param4])
			      ] 
			     )

let _ = Configwin.edit "Titre" [structure]

