/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/** 
 *  cong-eel.c
 *
 *  Contains code copied and pasted from eel-2.0, to avoid dependency issues 
 *  Everything gets prefixed with a "cong_"
 */

#include "global.h"
#include "cong-eel.h"
#include "cong-ui-hooks.h"

/**
 * cong_eel_log_ref_count:
 * @name:
 * @obj:
 *
 * TODO: Write me
 */
void 
cong_eel_log_ref_count (const gchar *name, 
			GObject *obj)
{
#if 0
	g_message("Current ref count of %s = %i (%s)", 
		  name,
		  obj->ref_count,
		  G_OBJECT_CLASS_NAME(G_OBJECT_GET_CLASS(obj)));
#endif
}

/**
 * cong_eel_rectangle_construct:
 * @rectangle:
 * @x:
 * @y:
 * @w:
 * @h:
 *
 * TODO: Write me
 */
void            
cong_eel_rectangle_construct (GdkRectangle  *rectangle,
			      gint                  x,
			      gint                  y,
			      gint                  w,
			      gint                  h)
{
	g_return_if_fail (rectangle);
	rectangle->x = x;
	rectangle->y = y;
	rectangle->width = w;
	rectangle->height = h;
}

/**
 * cong_eel_pango_layout_line_get_text:
 * @layout_line:
 *
 * TODO: Write me
 * Returns:
 */
gchar*
cong_eel_pango_layout_line_get_text (PangoLayoutLine *layout_line)
{
	g_return_val_if_fail (layout_line, NULL);

	return g_strndup (pango_layout_get_text (layout_line->layout) + layout_line->start_index, 
			  layout_line->length);
}

/**
 * cong_eel_rgb_to_gdk_color:
 * @color:
 * @r:
 * @g:
 * @b:
 *
 * TODO: Write me
 */
void
cong_eel_rgb_to_gdk_color (GdkColor             *color,
			   guchar               r,
			   guchar               g,
			   guchar               b)
{
	gboolean result;

	g_return_if_fail (color);

	color->red = (r<<8);
	color->green = (g<<8);
	color->blue = (b<<8);

	result = gdk_colormap_alloc_color (cong_gui_get_a_window()->style->colormap, 
					   color, 
					   FALSE, 
					   TRUE);
	g_assert (result);
}

/**
 * cong_eel_rgb_to_gdk_color2:
 * @r:
 * @g:
 * @b:
 *
 * TODO: Write me
 */
GdkColor*
cong_eel_rgb_to_gdk_color2 (guchar               r,
			    guchar               g,
			    guchar               b)
{
	gboolean result;
	GdkColor color;

	color.red = (r<<8);
	color.green = (g<<8);
	color.blue = (b<<8);

	result = gdk_colormap_alloc_color (cong_gui_get_a_window()->style->colormap, 
					   &color, 
					   FALSE, 
					   TRUE);
	g_assert (result);
	
	return gdk_color_copy (&color);
}

/**
 * cong_eel_rectangle_contains:
 * @rectangle: Rectangle possibly containing a point.
 * @x: X coordinate of a point.
 * @y: Y coordinate of a point.
 *
 * Returns: %TRUE if point is contained inside a rectangle, %FALSE otherwise
 */
gboolean
cong_eel_rectangle_contains (const GdkRectangle *rectangle, 
			     int x, 
			     int y)
{
	g_return_val_if_fail (rectangle != NULL, FALSE);
	return rectangle->x <= x && rectangle->x + rectangle->width >= x
		&& rectangle->y <= y && rectangle->y + rectangle->height >= y;
}

/**
 * cong_eel_rgb16_to_rgb:
 * @r:
 * @g:
 * @b:
 *
 * TODO: Write me
 * Returns:
 */
guint32
cong_eel_rgb16_to_rgb (gushort r, gushort g, gushort b)
{
	guint32 result;

	result = (0xff0000 | (r & 0xff00));
	result <<= 8;
	result |= ((g & 0xff00) | (b >> 8));

	return result;
}

/**
 * cong_eel_gdk_color_to_rgb
 * @color: A GdkColor style color.
 *
 * Converts from a GdkColor stlye color to a gdk_rgb one.
 * Alpha gets set to fully opaque
 * 
 * Returns: An rgb value.
 */
guint32
cong_eel_gdk_color_to_rgb (const GdkColor *color)
{
	return cong_eel_rgb16_to_rgb (color->red, color->green, color->blue);
}

/**
 * cong_eel_gdk_rgb_to_color_spec
 * @color: a gdk_rgb style value.
 *
 * Converts from a gdk_rgb value style to a string color spec.
 * The gdk_rgb color alpha channel is ignored.
 * 
 * Returns: a newly allocated color spec.
 */
char *
cong_eel_gdk_rgb_to_color_spec (const guint32 color)
{
	return g_strdup_printf ("#%06X", (guint) (color & 0xFFFFFF));
}

static gchar* 
cong_eel_utf8_capitalise(const gchar *str)
{
	gchar *result;
	gunichar*   unichar;

	g_return_val_if_fail (str, NULL);

	unichar = g_utf8_to_ucs4_fast (str, -1, NULL);

	/* FIXME: is this correct? */
	unichar[0] = g_unichar_toupper(unichar[0]);

	result = g_ucs4_to_utf8(unichar, -1, NULL, NULL, NULL);

	g_free(unichar);

	return result;
}

/**
 * split_xmlname:
 * @xml_name:
 * 
 * Splits things like "this-is-a-tag" into its individual words.
 * Can handle hyphenated words.
 * FIXME:  Add support for splitting caps-seperated things like "ThisIsATag"
 * FIXME:  Probably should convert everything to lower case as well on output
 * FIXME:  To be really smart, we could try to spot acronyms and fully capitalise them...  would require a dictionary though.
 * 
 * Returns:
 */
static gchar** 
split_xmlname(const gchar *xml_name)
{
	/* FIXME: is this really UTF-8 safe? */
	return g_strsplit (xml_name,
			   "-",
			   0);
}

/**
 * cong_eel_prettify_xml_name_with_header_capitalisation:
 * @xml_name:
 *
 * TODO: Write me
 * Returns:
 */
gchar *
cong_eel_prettify_xml_name_with_header_capitalisation(const gchar *xml_name)
{
	gchar *result = NULL;
	gchar** string_array;
	gchar** iter;

	g_return_val_if_fail(xml_name, NULL);

	string_array = split_xmlname(xml_name);

	for (iter = string_array; *iter; iter++) {
		cong_eel_set_string (iter, cong_eel_utf8_capitalise(*iter));
	}

	result = g_strjoinv (" ",
			     string_array);

	g_strfreev(string_array);

	return result;
}

/**
 * cong_eel_prettify_xml_name_with_sentence_capitalisation:
 * @xml_name:
 *
 * TODO: Write me
 * Returns:
 */
gchar *
cong_eel_prettify_xml_name_with_sentence_capitalisation(const gchar *xml_name)
{
	gchar *result = NULL;
	gchar** string_array;
	gchar** iter;

	g_return_val_if_fail(xml_name, NULL);

	string_array = split_xmlname(xml_name);

	/* Capitalise first word, if there is one: */
	if (*string_array) {
		cong_eel_set_string (&string_array[0], cong_eel_utf8_capitalise(string_array[0]));
	}
	for (iter = string_array; *iter; iter++) {
		/* FIXME: unwritten */
	}

	result = g_strjoinv (" ",
			     string_array);

	g_strfreev(string_array);

	return result;
}

/**
 * cong_eel_set_string:
 * @string: a string
 * @value: a new value for the string
 *
 * Sets a @string to @value, freeing the old value (if any)
 */
void 
cong_eel_set_string(gchar **string, gchar *value)
{
	gchar *old_value;

	g_return_if_fail (string);

	old_value = *string;

	*string = value;

	if (old_value) {
		g_free (old_value);
	}
}

/**
 * cong_eel_draw_pixbuf:
 * @drawable:
 * @gc:
 * @pixbuf:
 * @src_x:
 * @src_y:
 * @dest_x:
 * @dest_y:
 * @width:
 * @height:
 * @dither:
 * @x_dither:
 * @y_dither:
 *
 * TODO: Write me
 */
void 
cong_eel_draw_pixbuf (GdkDrawable *drawable,
		      GdkGC *gc,
		      GdkPixbuf *pixbuf,
		      gint src_x,
		      gint src_y,
		      gint dest_x,
		      gint dest_y,
		      gint width,
		      gint height,
		      GdkRgbDither dither,
		      gint x_dither,
		      gint y_dither)
{
#if 0
	/* Code for Gdk-2.2 and later: */
	gdk_draw_pixbuf (drawable,
			 gc,
			 pixbuf,
			 src_x,
			 src_y,
			 dest_x,
			 dest_y,
			 -1,
			 -1,
			 dither,
			 x_dither,
			 y_dither);
#else
	/* Code for pre Gdk-2.2: */
	gdk_pixbuf_render_to_drawable (pixbuf,
				       drawable,
				       gc,
				       src_x,
				       src_y,
				       dest_x,
				       dest_y,
				       -1,
				       -1,
				       dither,
				       x_dither,
				       y_dither);
#endif
}
