/*****************************************************************
 *
 *   gtk_fonts.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#include "cpanel.h"
#include "defaults.h"

extern gboolean if_gb;
extern gchar gtk_font[STR_BUFFER_SIZE];
extern gchar gtk_font_gb[STR_BUFFER_SIZE];

GtkWidget *entry[1];

void ok_gtk_fonts(GtkWidget *button, gpointer *data)
{
	if(if_gb)
	strcpy(gtk_font_gb,gtk_entry_get_text(GTK_ENTRY(entry[0])));
	else
	strcpy(gtk_font,gtk_entry_get_text(GTK_ENTRY(entry[0])));
	if(if_gb)
	save_gtk_fonts(gtk_font_gb,1);
	else
	save_gtk_fonts(gtk_font,0);
}

void def_gtk_fonts(GtkWidget *button, gpointer *data)
{
	if(if_gb)
	gtk_entry_set_text(GTK_ENTRY(entry[0]),GTK_FONT_GB);
	else
	gtk_entry_set_text(GTK_ENTRY(entry[0]),GTK_FONT);
}

void help_gtk_fonts(GtkWidget *button, gpointer *data)
{
	show_help("gtk_fonts_opt",_("Help - Gtk+ fonts Options"),600,300);
}

void gtk_fonts_opt(GtkWidget *button, gpointer *data)
{
	/* entry[]: 0: gtk_font */
	GtkWidget *win;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;

	win = make_opt_win(_("Options - Set GTK+ fonts"),button);
	vbox = gtk_vbox_new(FALSE,0);

	if(if_gb)
	hbox = make_fonts_opt(_("Set GTK+ fonts (Simplified Chinese) to: "),entry,0,gtk_font_gb, win);
	else
	hbox = make_fonts_opt(_("Set GTK+ fonts (Tradition Chinese) to: "),entry,0,gtk_font, win);

	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);

	/* OK CANEL DEFAULT HELP */
	ok_button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(ok_gtk_fonts),NULL);

	cancel_button = gtk_button_new_with_label(_("Cancel"));

	def_button = gtk_button_new_with_label(_("Use Defaults"));
	gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
			GTK_SIGNAL_FUNC(def_gtk_fonts),NULL);

	help_button = gtk_button_new_with_label(_("Help"));
	gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
			GTK_SIGNAL_FUNC(help_gtk_fonts),NULL);

	/* Make buttons: make_button(ok,canel,def,help,win); */
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);
	hbox = make_button(ok_button,cancel_button,def_button,help_button,
			win,button);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	/* show window */
	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_widget_show_all(win);
}

void gtk_fonts_help(GtkWidget *button, gpointer *data)
{
	show_help("gtk_fonts_help",_("Help - Set GTK+ fonts"),600,300);
}

void save_gtk_fonts(gchar *fontName, gboolean gb)
{
	FILE *f;
	gchar *path;
	
	if(gb)
	path = g_strconcat(getenv("HOME"),"/",GTK_LOCALE_FILE_NAME_GB,NULL);
	else
	path = g_strconcat(getenv("HOME"),"/",GTK_LOCALE_FILE_NAME,NULL);

	f = fopen(path,"w");
	if(!f)
	{
		printf("Error saving gtk locale file: %s\n",path);
		printf("Does $HOME point to your home dir??\n");
		g_free(path);
		return;
	}

	fprintf(f,"##################################################\n");
	fprintf(f,"# This file is generated by Debian Chinese Panel #\n");
	fprintf(f,"##################################################\n");
	fprintf(f,"\n");

	if(gb)
	fprintf(f,"style \"gtk-default-zh-cn\" {\n");
	else
	fprintf(f,"style \"gtk-default-zh-tw\" {\n");

	fprintf(f,"\tfontset = \"-adobe-helvetica-medium-r-normal--14-*-*-*-*-*-iso8859-*,\\\n");
	fprintf(f,"\t\t%s\"\n",fontName);
	fprintf(f,"}\n");

	if(gb)
	fprintf(f,"class \"GtkWidget\" style \"gtk-default-zh-cn\"");
	else
	fprintf(f,"class \"GtkWidget\" style \"gtk-default-zh-tw\"");

	fclose(f);
	g_free(path);
}
