/*****************************************************************
 *
 *   xcin23.c
 *
 *     Copyright (c) 2000  Kam Tik <kamtik@hongkong.com>
 *
 *	http://debian.kamtik.net
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 ******************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "cpanel.h"
#include "defaults.h"

extern gchar xcin23_command[STR_BUFFER_SIZE];
extern gchar xcin23_in[STR_BUFFER_SIZE];

GtkWidget *entry[2];

void ok_xcin23(GtkWidget *button, gpointer *data)
{
	strcpy(xcin23_command,gtk_entry_get_text(GTK_ENTRY(entry[0])));
	strcpy(xcin23_in,gtk_entry_get_text(GTK_ENTRY(entry[1])));
}

void def_xcin23(GtkWidget *button, gpointer *data)
{
	gtk_entry_set_text(GTK_ENTRY(entry[0]),XCIN23_COMMAND);
	gtk_entry_set_text(GTK_ENTRY(entry[1]),XCIN23_IN);
}

void help_xcin23(GtkWidget *button, gpointer *data)
{
	show_help("xcin23_opt",_("Help - xcin2.3 Options"),600,400);
}

void xcin23(GtkWidget *button, gpointer *data)
{
	gchar *command;
	command = g_strconcat(xcin23_command," -in1 ",xcin23_in," &",NULL);
	system(command);
}

void xcin23_opt(GtkWidget *button, gpointer *data)
{
	/* entry[]: 0.command 1.in */
	GtkWidget *win;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
	GtkWidget *def_button;
	GtkWidget *help_button;
	GtkWidget *separator;

	win = make_opt_win(_("Options - xcin2.3"),button);

	vbox = gtk_vbox_new(FALSE,0);

	hbox = make_opt(_("Command: "),entry,0,xcin23_command);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);
	hbox = make_opt(_("Input Method: "),entry,1,xcin23_in);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,1);

	ok_button = gtk_button_new_with_label(_("OK"));
	gtk_signal_connect(GTK_OBJECT(ok_button),"clicked",
			GTK_SIGNAL_FUNC(ok_xcin23),NULL);
	cancel_button = gtk_button_new_with_label(_("Cancel"));
	def_button = gtk_button_new_with_label(_("Use Defaults"));
	gtk_signal_connect(GTK_OBJECT(def_button),"clicked",
			GTK_SIGNAL_FUNC(def_xcin23),NULL);
	help_button = gtk_button_new_with_label(_("Help"));
	gtk_signal_connect(GTK_OBJECT(help_button),"clicked",
			GTK_SIGNAL_FUNC(help_xcin23),NULL);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,5);
	hbox = make_button(ok_button,cancel_button,def_button,help_button,
			win,button);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(win),vbox);
	gtk_widget_show_all(win);
}

void xcin23_help(GtkWidget *button, gpointer *data)
{
	show_help("xcin23_HOWTO",_("Help - xcin2.3"),500,300);
}
