/* cfed -- a level editor for Crimson Fields
   Copyright (C) 2000, 2001 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* editor.h */

#ifndef VERSION
# define VERSION "0.2.2"
#endif

#ifdef WIN32
# define strcasecmp stricmp
# define strncasecmp strnicmp

# define CURRENTDIR ".\\"
#else
# define CURRENTDIR "./"
#endif

#include "SDL_endian.h"		/* used for endianness detection */

#define NUM_UNIT_TYPES		19

#define FILE_VERSION		4
#define MakeID(a,b,c,d)		((a)|((b)<<8)|((c)<<16)|((d)<<24))
#define FID_MISSION		MakeID('M','S','S','N')

#define MAX_MAP_WIDTH	100
#define MAX_MAP_HEIGHT	100

#define U_GROUND	0x000001
#define U_SHIP		0x000002
#define U_AIR		0x000004
#define U_SUB		0x000008
#define U_CONQUER	0x000010	/* unit can take over enemy buildings */
#define U_SLOW		0x000020	/* can only fight OR move */
#define U_TRANSPORT	0x000040	/* can carry other units, note: transporters may NEVER have U_CONQUER set! */
#define U_MINE		0x000080	/* can be cleared/reused by minesweepers */
#define U_MINESWEEPER	0x000100

#define U_BUSY		0x040000	/* used by computer player */
#define U_DONE		0x080000
#define U_MOVED		0x100000	/* unit moved this turn */
#define U_ATTACKED	0x200000	/* unit initiated combat this turn */
#define U_SHELTERED	0x400000	/* unit is currently inside a building/transporter */
#define U_DESTROYED	0x800000

#define B_WORKSHOP	0x0001		/* units can be repaired here */
#define B_FACTORY	0x0002		/* units can be produced here */
#define B_MINE		0x0004		/* building produces crystals */

#define TT_ROAD			0x0001
#define TT_PLAINS		0x0002
#define TT_FOREST		0x0004
#define TT_SWAMP		0x0008
#define TT_MOUNTAINS		0x0010
#define TT_WATER_SHALLOW	0x0020
#define TT_WATER_DEEP		0x0040
#define TT_BARRICADES		0x0080

#define TT_ENTRANCE		0x4000	/* entrance to a building (also road) */
#define TT_KEEP_OFF		0x8000	/* no unit allowed to enter this (e.g. buildings) */
					/* the entrance to a building is of type (TT_ROAD|TT_ENTRANCE) */
#define TT_STD_GROUND	(TT_PLAINS|TT_FOREST|TT_ROAD|TT_ENTRANCE)
#define TT_STD_SEA	(TT_WATER_SHALLOW|TT_WATER_DEEP)
#define TT_STD_AIR	(TT_STD_GROUND|TT_STD_SEA|TT_MOUNTAINS|TT_SWAMP|TT_BARRICADES)

#define EVENT_MESSAGE		1
#define EVENT_PRODUCTION	2
#define EVENT_VICTORY		3
#define EVENT_SCORE		4
#define EVENT_CREATE_UNIT	8

#define ETRIGGER_TURN		0x01
#define ETRIGGER_UNIT_DESTROYED	0x02
#define ETRIGGER_HAVE_BUILDING	0x04
#define ETRIGGER_HAVE_UNIT	0x08

#define PLAYER_ONE	0
#define PLAYER_TWO	1
#define PLAYER_NONE	2

#define LEVEL_EASY	1
#define LEVEL_NORMAL	2
#define LEVEL_HARD	3

#define HUMAN		0
#define COMPUTER	1

#define MODE_NONE	0
#define MODE_MAP	1
#define MODE_UNIT	2
#define MODE_GAME	3
#define MODE_BUILDING	4
#define MODE_EVENT	5
#define MODE_PLAYER	6

#define HAVE_NONE	0
#define HAVE_MAP	(1<<MODE_MAP)
#define HAVE_UNIT	(1<<MODE_UNIT)
#define HAVE_GAME	(1<<MODE_GAME)
#define HAVE_BUILDING	(1<<MODE_BUILDING)
#define HAVE_EVENT	(1<<MODE_EVENT)
#define HAVE_PLAYER	(1<<MODE_PLAYER)

/* structures */

struct Point {
  short x;
  short y;
};

struct UnitType {
  unsigned short ut_terrain;		/* wherever it may roam... */
  unsigned short ut_image;
  unsigned char ut_moves;
  unsigned char ut_weight;		/* used by transports */
  unsigned char ut_flags;
  unsigned char ut_defence;		/* defensive strength */
  unsigned char ut_pow_ground;		/* offensive strengths */
  unsigned char ut_pow_ship;
  unsigned char ut_pow_air;
  unsigned char ut_pow_sub;
  unsigned char ut_min_range_ground;
  unsigned char ut_max_range_ground;
  unsigned char ut_min_range_ship;
  unsigned char ut_max_range_ship;
  unsigned char ut_min_range_air;
  unsigned char ut_max_range_air;
  unsigned char ut_min_range_sub;
  unsigned char ut_max_range_sub;
  unsigned char ut_points;		/* base score gained for destroying this unit */
  unsigned char ut_build;		/* resources needed to build this unit type */
  unsigned char ut_snd_move;		/* movement sound (255 == none) */
  unsigned char ut_snd_fire;		/* shoot sound (255 == none) */
  unsigned char ut_trans_slots;		/* max number of units the transport can carry */
  unsigned char ut_trans_weight;	/* max weight the transport can carry */
  unsigned char ut_typeid;
  char ut_name[20];
};

struct Unit {
  struct Point u_pos;		/* position on map */
  unsigned long u_flags;
  unsigned short u_id;
  
  unsigned char u_moves;
  unsigned char u_facing;	/* direction */
  unsigned char u_group;	/* group size */
  unsigned char u_xp;		/* experience */
  unsigned char u_pid;		/* player id */
  unsigned char u_utype;

  unsigned short u_crystals;	/* ONLY used for transports */
  struct Point u_target;
};

struct Building {
  struct Point b_pos;
  unsigned short b_id;
  unsigned short b_flags;

  unsigned short b_crystals;
  unsigned short b_maxcrystals;

  unsigned long b_unitprod;

  unsigned char b_crystalprod;
  unsigned char b_player;
  char b_name[20];
};

struct Event {
  unsigned char e_type;
  unsigned char e_trigger;
  short e_tdata[3];		/* trigger data */
  short e_data[3];		/* event data */
  short e_title;
  short e_message;
  unsigned char e_player;
};

struct Player {
  unsigned char p_id;
  unsigned char p_type;		/* COMPUTER or HUMAN */
  unsigned char p_level;
  unsigned char p_success;
  char p_briefing;
  unsigned short p_score;
  char p_name[16];
  char p_password[8];
};

#define GI_SAVEFILE  0x0001
#define GI_PASSWORD  0x0002
#define GI_PBEM      0x0004

#define TURN_START        0
#define TURN_IN_PROGRESS  1
#define TURN_END          2

struct GameInfo {
  unsigned long file_id;       /* always FID_MISSION */
  unsigned char version;
  char level_info_str;
  unsigned short flags;
  char password[8];

  unsigned short num_transports;
  unsigned short num_units;
  unsigned short num_buildings;
  unsigned short num_combatrecords;
  unsigned short num_events;
  unsigned short num_texts;
  unsigned long text_length;

  unsigned short map_width;
  unsigned short map_height;
  unsigned short turn;
  unsigned char current_player;
  unsigned char phase;
};

struct TerrainType {
  unsigned short tt_type;       /* one (or more) of the TT_ defined above */
  unsigned short tt_image;
  char tt_att_mod;              /* attack modifier (percent) */
  char tt_def_mod;              /* defence modifier (percent) */
  char tt_move;                 /* cost to cross hex type */
  char reserved;
  unsigned long tt_color;       /* color shown on the overview map display */
};

