// Description:
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#ifndef __Enemy_hpp__
#define __Enemy_hpp__

// Enemy class
#include <Character.hpp>
#include <PuckMaze.hpp>

class Enemy:public Character
{
private:
        int power;

public:
        Enemy( PuckMaze *maze):Character( maze), power( 10){;}
        virtual ~Enemy(){ Remove();}

        virtual void Draw( void);
        virtual void Add( void);
        virtual void Remove( void);

        bool Update( int x, int y, int power);

        int Power( void){ return( power);}
};

#endif
