#include "httpbuffer"

unsigned Httpbuffer::findheader(string h) {
    PROFILE("Httpbuffer::findheader");

    // No headers in here yet? Don't process.
    if (!headersreceived())
	return 0;

    // We must have a first HTTP line, else we don't have headers
    if (!firstline().length())
	return 0;

    // Scan until bodystart (which is set in headersreceived()).
    // Used to scan until bufsz() but that's not right, thanks Maxim P.
    for (unsigned int i = 1; i < bodystart; /* incremented below */) {
	// At header?
	if (!strncmp(bufdata() + i, h.c_str(), h.size()))
	    return i;

	// No, advance beyond \n or fail
	if (! (i = charfind('\n', i)) )
	    return 0;
	i++;
    }

    // Avoiding warnings:
    return 0;
}
