.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.ta .3i .6i .9i 1.2i 1.5i 1.8i
.TH CTWM 1 "Version 3.5.2"
.SH NAME
ctwm - Tab Window Manager for the X Window System
.SH SYNTAX
.PP
\fIctwm \fP[-display \fIdpy\fP] [-s] [-f \fIinitfile\fP] [-v] [-n] [-k] [-w [win-id]]
.PP
.SH DESCRIPTION
.PP
\fICtwm\fP is a window manager for the X Window System.  It provides 
titlebars, shaped windows, virtual screens (workspaces),
several forms of icon management, user-defined macro functions, 
click-to-type and pointer-driven keyboard focus, and user-specified 
key and pointer button bindings.  It is actually
twm (Tab Window Manager) from the MIT X11 distribution slightly modified
to accommodate the use of several virtual screens (workspaces). It is
heavily inspired from the Hewlett-Packard vuewm window manager. In addition,
\fIctwm\fP can use coloured, shaped icons and background root pixmaps in XPM
format [from Arnaud Le Hors],any format understood by the imconv package
[from the San Diego Supercomputer Center] and xwd files. \fBCtwm\fP can be
compiled to use both, either or none of the above icon/pixmap formats.
.PP
This program is usually started by the user's session manager or
startup script.  When used from \fIxdm(1)\fP or \fIxinit(1)\fP without
a session manager, \fIctwm\fP is frequently executed in the foreground
as the last client.  When run this way, exiting \fIctwm\fP causes the 
session to be terminated (i.e. logged out).
.PP
By default, application windows are surrounded by a ``frame'' with a 
titlebar at the top and a special border around the window.  The titlebar 
contains the window's name, a rectangle that is lit when the window is
receiving keyboard input, and function boxes known as ``titlebuttons'' at
the left and right edges of the titlebar.
.PP
Pressing pointer Button1 (usually the left-most
button unless it has been changed with \fIxmodmap\fP) on a 
titlebutton will invoke the function associated with the button.
In the default interface, windows are iconified by clicking (pressing
and then immediately releasing) the left titlebutton (which looks
like a Dot).  Conversely, windows are deiconified by clicking in the
associated icon or entry in the icon manager
(see description of the variable
\fBShowIconManager\fP and of the function \fBf.showiconmgr\fP).
.PP
Windows are resized by pressing the right titlebutton (which resembles a
group of nested squares), dragging the pointer over edge that is to be
moved, and releasing the pointer when the outline of the window is the desired
size.  Similarly, windows are moved by pressing in the title or highlight
region, dragging a window outline to the new location, and then releasing
when the outline is in the desired position.  Just
clicking in the title or highlight region raises the window without moving it.
.PP
When new windows are created, \fIctwm\fP will honor any size and location
information requested by the user (usually through \fI-geometry\fP
command line argument or resources for the individual applications).  
Otherwise, an outline of the window's default size, its titlebar, and lines 
dividing the 
window into a 3x3 grid that track the pointer are displayed.
Clicking pointer Button1
will position the window at the current position and give it the default
size.  Pressing pointer Button2 (usually the middle pointer button) 
and dragging the outline
will give the window its current position but allow the sides to be resized as
described above.  Clicking pointer Button3 (usually the right pointer button)
will give the window its current position but attempt to make it long enough
to touch the bottom the screen.
.SH OPTIONS
\fICtwm\fP accepts the following command line options:
.PP
.TP 8
.B \-display \fIdpy\fP
This option specifies the X server to use.
.TP 8
.B \-s
This option indicates that only the default screen (as specified by 
\fB\-display\fP or by the \fBDISPLAY\fP environment variable) should be
managed.  By default, \fIctwm\fP will attempt to manage
all screens on the display.
.TP 8
.B \-f \fIfilename\fP
This option specifies the name of the startup file to use.
\fICtwm\fP will first try to load filename.num, where \fInum\fP is the screen number.
If it fails, it will try to load filename.
By default, \fIctwm\fP will look in the user's home directory for files 
named \fI.ctwmrc.num\fP (where \fInum\fP is a screen number) or \fI.ctwmrc\fP.
.TP 8
.B \-v
This option indicates that \fIctwm\fP should print error messages whenever
an unexpected X Error event is received.  This can be useful when debugging
applications but can be distracting in regular use.
.TP 8
.B \-n
This option indicates that \fIctwm\fP should not filter the startup file
through m4. Available only if \fIctwm\fP is compiled with the USEM4 flag.
.TP 8
.B \-k
This option indicates that \fIctwm\fP should keep the result of filtering
your startup file through m4 in /tmp. Available only if \fIctwm\fP is compiled
with the USEM4 flag.

.TP 8
.B \-version
\fIctwm\fP just prints its version number.

.TP 8
.B \-info
\fIctwm\fP prints its detailed version and compile time options.

.TP 8
.B \-w [win-id]
If \-w is specified without a win-id value, \fIctwm\fP does not take over the whole
screen(s), instead it creates a new window that becomes its root window. if the
win-id value is given, it is considered to be the id of an existing window, in
which case, \fIctwm\fP will try to use this window as root window. You can run any
number of instantiation of \fIctwm\fP at the same time. You can even have
embedded \fIctwm\fP instantiations. This is totally useless, but I like. The
f.adoptwindow function can be used to capture an existing window belonging to
another \fIctwm\fP. A possible use of such mode can be to test new configuration file
without restarting \fIctwm\fP.
.TP 8
.B \-W
This option tells \fIctwm\fP not to display any welcome when starting.

.SH CUSTOMIZATION
.PP
Much of \fIctwm\fP's appearance and behavior can be controlled by providing
a startup file in one of the following locations (searched in order for
each screen being managed when \fIctwm\fP begins):
.TP 8
.B "$HOME/.ctwmrc.\fIscreennumber\fP"
The \fIscreennumber\fP is a small positive number (e.g. 0, 1, etc.)
representing the screen number (e.g. the last number in the DISPLAY environment
variable \fIhost:displaynum.screennum\fP) that would be used to contact that 
screen of the display.  This is intended for displays with multiple screens of 
differing visual types.
.TP 8
.B "$HOME/.ctwmrc"
This is the usual name for an individual user's startup file.
.TP 8
.B "$HOME/.twmrc"
The users twm startup file.
.TP 8
.B "/usr/lib/X11/twm/system.ctwmrc"
If none of the preceding files are found, \fIctwm\fP will look in this
file for a 
default configuration.  This is often tailored by the site administrator to
provide convenient menus or familiar bindings for novice users.
.PP
If no startup files are found, \fIctwm\fP will use the built-in defaults
described above.  The only resource used by \fIctwm\fP is 
\fIbitmapFilePath\fP for a colon-separated list of directories to search
when looking for bitmap files (for more information, see the \fIAthena
Widgets\fP manual and \fIxrdb(1)\fP).
.PP
\fICtwm\fP startup files are logically broken up into three types of 
specifications:  \fIVariables\fP, \fIBindings\fP, \fIMenus\fP.  The 
\fIVariables\fP section must come first and is used to describe the
fonts, colors, cursors, border widths, icon and window placement, highlighting,
autoraising, layout of titles, warping, use of the icon manager.
The \fIBindings\fP section usually comes second and is used to specify
the functions that should be
to be invoked when keyboard and pointer buttons are pressed in
windows, icons, titles, and frames.  The \fIMenus\fP section gives any 
user-defined menus (containing functions to be invoked or
commands to be executed).
.PP
Variable names and keywords are case-insensitive.  Strings must be surrounded
by double quote characters (e.g. "blue") and are case-sensitive.
A pound sign (#) outside
of a string causes the remainder of the line in which the character appears to
be treated as a comment.
.SH M4 PREPROCESSING
.PP
\fIctwm\fP uses \fIm4(1)\fP to pre-process its setup files.
When \fIctwm\fP starts up, it opens a file for input as described above.
But, it processes that file through \fIm4\fP before parsing it. So, you can
use \fIm4\fP macro's to perform operations at runtime.  This makes it very
easy to work when you use many different display's, with different characteristics.
For example, If you want to set the lower right section of the screen to be your
\fBIconRegion\fP, (see below for details on the \fBIconRegion\fP variable)
you can use \fIm4\fP directives and pre-defined symbols to calculate the region
you want.  For example:
.EX 0
define(IRegion, translit(eval(WIDTH/3)*eval(HEIGHT/2)+eval(WIDTH-WIDTH/3)-0, *, x))
IconRegion  "IRegion" SOUTH EAST 75 25
.EE
will define the lower half, and right-hand third of the screen.  The above
makes use of symbols that are predefined in \fIm4\fP by \fIctwm\fP.  The symbols
WIDTH and HEIGHT are calculated by \fIctwm\fP and written into a temporary
file for \fIm4\fP to use.  The following symbols are predefined by
\fIctwm\fP:
.TP 24
.B "SERVERHOST"
This variable is set to the name of the machine that is running the X
server.
.TP 24
.B "CLIENTHOST"
The machine that is running the clients.  (ie, \fIctwm\fP)
.TP 24
.B "HOSTNAME"
The canonical hostname running the clients.  (ie. a fully-qualified
version of \fBCLIENTHOST\fP)
.TP 24
.B "USER"
The name of the user running the program.  Gotten from the environment.
.TP 24
.B "HOME"
The user's home directory.  Gotten from the environment.
.TP 24
.B "VERSION"
The X major protocol version.  As seen by ProtocolVersion(3).
.TP 24
.B "REVISION"
The X minor protocol revision.  As seen by ProtocolRevision(3).
.TP 24
.B "VENDOR"
The vendor of your X server.  For example: \fBMIT X Consortium\fP.
.TP 24
.B "RELEASE"
The release number of your X server.  For MIT X11R5, this is \fB5\fP.
.TP 24
.B "WIDTH"
The width of your display in pixels.
.TP 24
.B "HEIGHT"
The height of your display in pixels.
.TP 24
.B "X_RESOLUTION"
The X resolution of your display in pixels per meter.
.TP 24
.B "Y_RESOLUTION"
The Y resolution of your display in pixels per meter.
.TP 24
.B "PLANES"
The number of bit planes your display supports in the default root window.
.TP 24
.B "BITS_PER_RGB"
The number of significant bits in an RGB color.  (log base 2 of the number
of distinct colors that can be created.  This is often different from the
number of colors that can be displayed at once.)
.TP 24
.B "TWM_TYPE"
Tells which \fItwm\fP offshoot is running.  It will always be set to
the string "ctwm" in this program.  This is useful for protecting
parts of your \fI.twmrc\fP file that \fIctwm\fP proper won't understand
(like \fBWorkSpaces\fP) so that it is still usable with other
\fItwm\fP programs.
.TP 24
.B "TWM_VERSION"
Tells which \fIctwm\fP version is running in the form of a floating
point number.
.TP 24
.B "CLASS"
Your visual class.  Will return one of \fBStaticGray\fP, \fBGrayScale\fP,
\fBStaticColor\fP, \fBPseudoColor\fP, \fBTrueColor\fP, \fBDirectColor\fP,
or, if it cannot determine what you have, \fBNonStandard\fP.
.TP 24
.B "COLOR"
This will be either 'Yes' or 'No'.  This is just a wrapper around the above
definition.  Returns 'Yes' on \fB*Color\fP, and 'No' on \fBStaticGray\fP
and \fBGrayScale\fP.
.TP 24
.B "XPM"
Is defined only if \fIctwm\fP was compiled with XPM.

.TP 24
.B "TWM_CAPTIVE"
This will be either 'Yes' or 'No'. 'Yes' if the current \fIctwm\fP is captive
(flag -w), 'No' in the other case.

.TP 24
.B "TWM_CAPTIVE_NAME"
Defined only if TWM_CAPTIVE is also defined. Contains the name of the captive
\fIctwm\fP (-name flag);

.PP
You may well find that if you research the \fIm4(1)\fP manual well,
and understand the power of \fIm4\fP, this will be a \fBvery\fP
useful and powerful tool.  But, if you use any of the symbols
which are predefined by \fIm4\fP, you are in severe danger!  For example,
the Sun \fIm4\fP predefines shift, so if you use that name in your \fI.ctwmrc\fP,
you are out of luck.
.PP
The availability of the \fIm4\fP preprocessing is subject to the compilation
define USEM4.
.SH VARIABLES
.PP
Many of the aspects of \fIctwm\fP's user interface are controlled by variables
that may be set in the user's startup file.  Some of the options are
enabled or disabled simply by the presence of a particular keyword.  Other
options require keywords, numbers, strings, or lists of all of these.
.PP
Lists are surrounded by braces and are usually separated by
whitespace or a newline.  For example:
.EX 0
\fBAutoRaise\fP { "emacs" "XTerm" "Xmh" }
.EE
or
.EX 0
\fBAutoRaise\fP
{
	"emacs"
	"XTerm"
	"Xmh"
}
.EE
When a variable containing a list of strings representing windows is searched 
(e.g. to determine whether or not to enable autoraise as shown above), a string
must be an exact, case-sensitive match to
the window's name name (given by the WM_NAME window property), resource name 
or class name (both given by the WM_CLASS window property).  The preceding
example would enable autoraise on windows named ``emacs'' as well as any
\fIxterm\fP (since they are of class ``XTerm'') or xmh windows 
(which are of class ``Xmh'').
.PP
String arguments that are interpreted as filenames (see the \fBPixmaps\fP,
\fBCursors\fP, and \fBIconDirectory\fP below) will 
prepend the user's directory
(specified by the \fBHOME\fP environment variable) if the first character is a
tilde (~).  If, instead, the first character is a colon (:), the name is
assumed to refer to one of the internal bitmaps that are used to
create the default titlebars symbols:  \fB:xlogo\fP 
or \fB:iconify\fP (both refer to the
X used for the iconify button), \fB:resize\fP (the nested squares used by the
resize button), and \fB:question\fP (the question mark used for non-existent
bitmap files).
.PP
The following variables may be specified at the top of a \fIctwm\fP startup
file.  Lists of Window name prefix strings are indicated by \fIwin-list\fP.
Optional arguments are shown in square brackets:
.IP "\fBAlwaysOnTop\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows (all windows if the list is defaulted)
that \fIctwm\fP will try its best to maintain on top of others. This doesn't
work in all case.

.IP "\fBAlwaysShowWindowWhenMovingFromWorkspaceManager\fP" 8
When \fBReallyMoveInWorkspaceManager\fP is present and the user is moving
a window from the WorkSpaceMap, \fIctwm\fP display the actual window only
if it crosses the current active workspace. If
\fBAlwaysShowWindowWhenMovingFromWorkspaceManager\fP is present, the actual
window is always visible during the move, regardless of whether it crosses
the current workspace or not. The Shift key toggles this behaviour.

.IP "\fBAnimationSpeed\fP \fIspeed\fP" 8
The \fIspeed\fP argument is a non-negative integer. It determines the number of
times a second animations (if any) are updated. If \fIspeed\fP is 0, animations
are freezed. The default value is 0.

 \" kai
.IP "\fBAutoFocusToTransients\fP" 8
Transient windows get focus automatically when created.  Useful with 
programs that have keyboard shortcuts that pop up windows.

.IP "\fBAutoLower\fP { \fIwin-list\fP }" 8
This variable specicies a list of windows (all windows if the list is
defaulted) to be automatically lowered whenever the point leaves a
window.  This action can be interactively enabled or disabled on
individual windows using the function \fBf.autolower\fP.

.IP "\fBAutoOccupy\fP" 8
This variable specifies that clients will automatically change their occupation
when their name or icon name changes. The new occupation will be recalculated
from the Occupy and OccupyAll fields in the \fI.ctwmrc\fP file.

.IP "\fBAutoRaise\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows (all windows if the list is defaulted)
to be automatically raised whenever the pointer has come to rest in a window for
the amount of time specified by the \fBRaiseDelay\fP variable. This action can be
interactively enabled or disabled on individual windows using the function
\fBf.autoraise\fP.

.IP "\fBAutoRaiseIcons\fP" 8
Icons are raised when the cursor enters it. Useful with SchrinkIconTitles.

.IP "\fBAutoRelativeResize\fP" 8
This variable indicates that dragging out a window size (either when
initially sizing the window with pointer Button2 or when resizing it) 
should not wait until the pointer has crossed the window edges.
Instead, moving
the pointer automatically causes the nearest edge or edges to move by the
same amount.  This allows the resizing of windows that extend off 
the edge of the screen.
If the pointer is
in the center of the window, or if the resize is begun by pressing a 
titlebutton, \fIctwm\fP will still wait for the pointer to cross a window
edge (to prevent accidents).  This option is
particularly useful for people who like the press-drag-release method of
sweeping out window sizes.

.IP "\fBAutoSqueeze\fP { \fIwin-list\fP }" 8
These windows will be auto-squeezed (see f.squeeze). i.e. automatically
unsqueezed when they get focus, and squeezed when they loose it. Useful for
the workspace manager. Not authorized for icon managers.

.IP "\fBBeNiceToColormap\fP" 8
By defaults new colors are allocated for shadows when a 3D look is used,
but when you specify \fBBeNiceToColormap\fP ctwm uses stipling instead of
new colors, the effect is less beautiful, but acceptable. In this case
ClearShadowContrast and DarkShadowContrast have no effects.

.IP "\fBBorderColor\fP \fIstring\fP [{ \fIwincolorlist\fP }]" 8
This variable specifies the default color of the border to be placed around 
all 
non-iconified windows, and may only be given within a \fBColor\fP or 
\fBMonochrome\fP list.  The optional \fIwincolorlist\fP specifies a list
of window and color name pairs for specifying particular border colors for
different types of windows.  For example:
.EX 0
\fBBorderColor\fP "gray50"
{
	"XTerm"	"red"
	"xmh"	"green"
}
.EE
The default is "black".

.IP "\fBBorderResizeCursors\fP
This variable specifies that \fIctwm\fP should use resizing cursors when
the pointer is on the window border. To be used preferably when you have
bound a button to f.resize in the frame context.

.IP "\fBBorderShadowDepth\fP \fIpixels\fP" 8
This variable specifies the depth of the shadow \fIctwm\fP uses for
3D window borders, when UseThreeDBorders is selected.
.IP "\fBBorderTileBackground\fP \fIstring\fP [{ \fIwincolorlist\fP }]" 8
This variable specifies the default background color in the gray pattern 
used in unhighlighted borders (only if \fBNoHighlight\fP hasn't been set),
and may only be given within a \fBColor\fP or \fBMonochrome\fP list.  The
optional \fIwincolorlist\fP allows per-window colors to be specified.
The default  is "white".
.IP "\fBBorderTileForeground\fP \fIstring\fP [{ \fIwincolorlist\fP }]" 8
This variable specifies the default foreground color in the gray pattern
used in unhighlighted borders (only
if \fBNoHighlight\fP hasn't been set), and may only be given within a 
\fBColor\fP or \fBMonochrome\fP list.  The optional \fIwincolorlist\fP allows
per-window colors to be specified.  The default is "black".

.IP "\fBBorderWidth\fP \fIpixels\fP" 8
This variable specifies the width in pixels of the border surrounding
all client window frames if \fBClientBorderWidth\fP has not been specified.
This value is also used to set the border size of windows created by \fIctwm\fP
(such as the icon manager).  The default is 2.

.IP "\fBButtonIndent\fP \fIpixels\fP" 8
This variable specifies the amount by which titlebuttons should be 
indented on all sides.  Positive values cause the buttons to be smaller than
the window text and highlight area so that they stand out.  Setting this
and the \fBTitleButtonBorderWidth\fP variables to 0 makes titlebuttons be as
tall and wide as possible.  The default is 1 if \fIUseThreeDTitles\fP is
not set, 0 if it is set.

.IP "\fBCenterFeedbackWindow\fP" 8
The moving and resizing information window is centered in the middle of the
screen instead of the top left corner.

.IP "\fBClearShadowContrast\fP \fIcontrast\fP" 8
Indicates to \fIctwm\fP how to calculate the clear shadow color for 3D items.
The value is a comprised between 0 and 100. The formula used is :
.EX 0
    clear.{RGB} = (65535 - color.{RGB}) * (contrast / 100).
.EE
Has no effect if \fBBeNiceToColormap\fP is active.

.IP "\fBClientBorderWidth\fP" 8
This variable indicates that border width of a window's frame should be set to
the initial border width of the window, rather than to the value of
\fBBorderWidth\fP.

.IP "\fBColor\fP { \fIcolors-list\fP }" 8
This variable specifies a list of color assignments to be made if the default
display is capable of displaying more than simple black and white.  The
\fIcolors-list\fP is made up of the following color variables and their values:
\fBDefaultBackground\fP,
\fBDefaultForeground\fP,
\fBMenuBackground\fP,
\fBMenuForeground\fP,
\fBMenuTitleBackground\fP,
\fBMenuTitleForeground\fP, and
\fBMenuShadowColor\fP.
The following
color variables may also be given a list of window and color name pairs to
allow per-window colors to be specified (see \fBBorderColor\fP for details):
\fBBorderColor\fP,
\fBIconManagerHighlight\fP,
\fBBorderTileBackground\fP,
\fBBorderTileForeground\fP,
\fBTitleBackground\fP,
\fBTitleForeground\fP,
\fBIconBackground\fP,
\fBIconForeground\fP,
\fBIconBorderColor\fP,
\fBIconManagerBackground\fP, and
\fBIconManagerForeground\fP.
For example:
.EX 0
\fBColor\fP
{
	MenuBackground		"gray50"
	MenuForeground		"blue"
	BorderColor			"red" { "XTerm" "yellow" }
	TitleForeground		"yellow"
	TitleBackground		"blue"
}
.EE
All of these color variables may also be specified for the \fBMonochrome\fP 
variable, allowing the same initialization file to be used on both color and
monochrome displays.
.IP "\fBConstrainedMoveTime\fP \fImilliseconds\fP" 8
This variable specifies the length of time between button clicks needed to
begin
a constrained move operation.  Double clicking within this amount
of time when invoking \fBf.move\fP will cause the window only be moved 
in a horizontal or vertical direction.  Setting this value to 0 will disable
constrained moves.  The default is 400 milliseconds.
.IP "\fBCursors\fP { \fIcursor-list\fP }" 8
This variable specifies the glyphs that \fIctwm\fP should use for various
pointer cursors.  Each cursor
may be defined either from the \fBcursor\fP font or from two bitmap files.
Shapes from the \fBcursor\fP font may be specified directly as:
.EX 0
	\fIcursorname\fP	"\fIstring\fP"
.EE
where \fIcursorname\fP is one of the cursor names listed below, and
\fIstring\fP is the name of a glyph as found in the file
/usr/include/X11/cursorfont.h (without the ``XC_'' prefix).
If the cursor is to be defined
from bitmap files, the following syntax is used instead:
.EX 0
	\fIcursorname\fP	"\fIimage\fP"	"\fImask\fP"
.EE
The \fIimage\fP and \fImask\fP strings specify the names of files containing
the glyph image and mask in \fIbitmap(1)\fP form.
The bitmap files are located in the same manner as icon bitmap files.
The following example shows the default cursor definitions:
.EX 0
\fBCursors\fP
{
	Frame		"top_left_arrow"
	Title		"top_left_arrow"
	Icon		"top_left_arrow"
	IconMgr	"top_left_arrow"
	Move		"fleur"
	Resize		"fleur"
	Menu		"sb_left_arrow"
	Button		"hand2"
	Wait		"watch"
	Select		"dot"
	Destroy	"pirate"
}
.EE
.IP "\fBDarkShadowContrast\fP \fIcontrast\fP" 8
    Indicates to \fIctwm\fP hos to calculate the dark shadow color for 3D items.
The value is a comprised between 0 and 100. The formula used is :
.EX 0
    dark.{RGB}  = color.{RGB} * ((100 - contrast) / 100),
.EE
Has no effect if \fBBeNiceToColormap\fP is active.

.IP "\fBDecorateTransients\fP" 8
This variable indicates that transient windows (those containing a 
WM_TRANSIENT_FOR property) should have titlebars.  By default, transients 
are not reparented.

.IP "\fBDefaultBackground\fP \fIstring\fP" 8
This variable specifies the background color to be used for sizing and
information windows.  The default is "white".

.IP "\fBDefaultForeground\fP \fIstring\fP" 8
This variable specifies the foreground color to be used for sizing and
information windows.  The default is "black".

.IP "\fBDontIconifyByUnmapping\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows that should not be iconified by
simply unmapping the window (as would be the case if \fBIconifyByUnmapping\fP
had been set).  This is frequently used to force some windows to be treated
as icons while other windows are handled by the icon manager.

.IP "\fBDontMoveOff\fP" 8
This variable indicates that windows should not be allowed to be moved off the
screen.  It can be overridden by the \fBf.forcemove\fP function.

.IP "\fBDontPaintRootWindow\fP" 8
This variable tells \fIctwm\fP not to paint the root window, whatever you told in
the Workspaces specification. This is useful to have pixmaps in the Workspace
Map but not on the root window.

.IP "\fBDontSetInactive\fP { \fIwin-list\fP } " 8
These windows won't be set to InactiveState when they become invisible
due to a change workspace. This has been added because some ill-behaved
clients (Frame5) don't like this.

.IP "\fBDontSqueezeTitle\fP [{ \fIwin-list\fP }] " 8
This variable indicates that titlebars should not be squeezed to their 
minimum size as described under \fBSqueezeTitle\fP below.
If the optional window list is supplied, only those windows will be
prevented from being squeezed.

.IP "\fBDontWarpCursorInWMap\fP" 8
Tells ctwm not to warp the cursor to the corresponding actual window
when you click in a small window in the workspace map.

.IP "\fBForceIcons\fP" 8
This variable indicates that icon pixmaps specified in the \fBIcons\fP
variable should override any client-supplied pixmaps.

.IP "\fBFramePadding\fP \fIpixels\fP" 8
This variable specifies the distance between the titlebar decorations (the
button and text) and the window frame.  The default is 2 pixels if \fIUseThreeDTitles\fP is
not set, 0 if it is set.

.IP "\fBIconBackground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the background color of icons, and may
only be specified inside of a \fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "white".

.IP "\fBIconBorderColor\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the color of the border used for icon windows, and
may only be specified inside of a \fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP. 
The default is "black".
.IP "\fBIconBorderWidth\fP \fIpixels\fP" 8
This variable specifies the width in pixels of the border surrounding
icon windows.  The default is 2.
.IP "\fBIconDirectory\fP \fIstring\fP" 8
This variable specifies the directory that should be searched if 
if a bitmap file cannot be found in any of the directories
in the \fBbitmapFilePath\fP resource.
.IP "\fBIconFont\fP \fIstring\fP" 8
This variable specifies the font to be used to display icon names within
icons.  The default is "variable".
.IP "\fBIconForeground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the foreground color to be used when displaying icons,
and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "black".
.IP "\fBIconifyByUnmapping\fP [{ \fIwin-list\fP }]" 8
This variable indicates that windows should be iconified by being unmapped
without trying to map any icons.  This assumes that the user is will 
remap the window through the icon manager, the \fBf.warpto\fP function, or
the \fITwmWindows\fP menu.
If the optional \fIwin-list\fP is provided, only those windows will be
iconified by simply unmapping.  Windows that have both this and the
\fBIconManagerDontShow\fP options set may not be accessible if no binding
to the \fITwmWindows\fP menu is set in the user's startup file.
.IP "\fBIconJustification\fP \fIstring\fP" 8
Where string is either \fB"left"\fP, \fB"center"\fP or \fB"right"\fP.
Tells \fIctwm\fP how to justify the icon image against the icon title (if any).
.IP "\fBIconManagerBackground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the background color to use for icon manager entries,
and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "white".
.IP "\fBIconManagerDontShow\fP [{ \fIwin-list\fP }]" 8
This variable indicates that the icon manager should not display any
windows.  If the optional \fIwin-list\fP is given, only those windows will
not be displayed.  This variable is used to prevent windows that are rarely
iconified (such as \fIxclock\fP or \fIxload\fP) from taking up space in
the icon manager.
.IP "\fBIconManagerFont\fP \fIstring\fP" 8
This variable specifies the font to be used when displaying icon manager
entries.  The default is "variable".
.IP "\fBIconManagerForeground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the foreground color to be used when displaying
icon manager entries, and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "black".
.IP "\fBIconManagerGeometry\fP \fIstring\fP [ \fIcolumns\fP ]" 8
This variable specifies the geometry of the icon manager window.  The 
\fIstring\fP argument is standard geometry specification that indicates 
the initial full size of the icon manager.  The icon manager window is
then broken into \fIcolumns\fP pieces and scaled according to the number
of entries in the icon manager.  Extra entries are wrapped to form
additional rows.  The default number of columns is 1.
.IP "\fBIconManagerHighlight\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the border color to be used when highlighting
the icon manager entry that currently has the focus,
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.  See the \fBBorderColor\fP
variable for a complete description of the \fIwin-list\fP.
The default is "black".
.IP "\fBIconManagers\fP { \fIiconmgr-list\fP }" 8
This variable specifies a list of icon managers to create.  Each item in the
\fIiconmgr-list\fP has the following format:
.EX 0
	"\fIwinname\fP" ["\fIiconname\fP"]	"\fIgeometry\fP" \fIcolumns\fP
.EE
where \fIwinname\fP is the name of the windows that should be put into this
icon manager, \fIiconname\fP is the name of that icon manager window's icon, 
\fIgeometry\fP is a standard geometry specification, and \fIcolumns\fP is
the number of columns in this icon manager as described in
\fBIconManagerGeometry\fP.  For example:
.EX 0
\fBIconManagers\fP
{
	"XTerm"	"=300x5+800+5"	5
	"myhost"	"=400x5+100+5"	2
}
.EE
Clients whose name or class is ``XTerm'' will have an entry created
in the ``XTerm'' icon manager.  Clients whose name was ``myhost'' would
be put into the ``myhost'' icon manager.

.IP "\fBIconManagerShadowDepth\fP \fIpixels\fP" 8
This variable specifies the depth of the shadow \fIctwm\fP uses for
3D IconManager entries, when UseThreeDIconManagers is selected.

.IP "\fBIconManagerShow\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows that should appear in the icon
manager.  When used in conjunction with the \fBIconManagerDontShow\fP
variable, only the windows in this list will be shown in the icon manager.

.IP "\fBIconRegion\fP \fIgeomstring\fP \fIvgrav hgrav gridwidth gridheight\fP [\fIiconjust\fP]" 8
[\fIiconregjust\fP] [\fIiconregalign\fP] [{ \fIwin-list\fP }]
.IP "" 8
This variable specifies an area on the root window in which icons are placed
if no specific icon location is provided by the client.  The \fIgeomstring\fP
is a quoted string containing a standard geometry specification. If more than
one \fBIconRegion\fP lines are given, icons will be put into the succeeding
icon regions when the first is full. The \fIvgrav\fP argument should be either
\fBNorth\fP or \fBSouth\fP and control and is used to control whether icons are
first filled in from the top or bottom of the icon region.  Similarly, the
\fIhgrav\fP argument should be either \fBEast\fP or \fBWest\fP and is used
to control whether icons should be filled in from left from the right. Icons
are laid out within the region in a grid with cells \fIgridwidth\fP pixels
wide and \fIgridheight\fP pixels  high. The optional win-list argument tells
\fIctwm\fP that if such a window is iconified, and there is enough room in this
icon region for its icon, then place it here. The optionnal \fIiconjust\fP, 
\fIiconregjust\fP and \fIiconregalign\fP can be used to give specific values
of IconJustification, IconRegionJustification and IconRegionAlignement for
this IconRegion.

.IP "\fBIconRegionAlignement\fP \fIstring\fP" 8
Where string is either \fB"top"\fP, \fB"center"\fP \fB"bottom"\fP or \fB"border"\fP.
Tells ctwm how to align icons inside their place in the IconRegion.
This keyword needs a string value. The acceptable values are : "top", "center",
"bottom" and "border". If "border" is given, the justification will be "top" if
the icon region gravity is "north" and "bottom" if the icon region gravity is "south".

.IP "\fBIconRegionJustification\fP \fIstring\fP" 8
Where string is either \fB"left"\fP, \fB"center"\fP \fB"right"\fP or \fB"border"\fP.
Tells ctwm how to justify icons inside their place in the IconRegion.
This keyword needs a string value. The acceptable values are : "left", "center",
"right" and "border". If "border" is given, the justification will be "left" if
the icon region gravity is "west" and "right" if the icon region gravity is "east".

.IP "\fBIcons\fP { \fIwin-list\fP }" 8
This variable specifies a list of window names and the bitmap filenames that
should be used as their icons.  For example:
.EX 0
\fBIcons\fP
{
	"XTerm"	"xterm.icon"
	"xfd"		"xfd_icon"
}
.EE
Windows that match ``XTerm'' and would not be iconified by unmapping, and would try
to use  the icon bitmap in the file ``xterm.icon''.If \fBForceIcons\fP is
specified, this bitmap will be used even if the client has requested its
own icon pixmap.

.IP "\fBIgnoreLockModifier\fP" 8
If present, all bindings (buttons and keys) will ignore the LockMask. Useful if you
often use caps lock, and don't want to define twice all your bindings.

.IP "\fBInterpolateMenuColors\fP" 8
This variable indicates that menu entry colors should be interpolated between
entry specified colors.  In the example below:
.EX 0
\fBMenu\fP "mymenu"
{
	"Title"		("black":"red")		f.title
	"entry1"				f.nop
	"entry2"				f.nop
	"entry3"	("white":"green")	f.nop
	"entry4"				f.nop
	"entry5"	("red":"white")		f.nop
}
.EE
the foreground colors for ``entry1'' and ``entry2'' will be interpolated
between black and white, and the background colors between red and green.
Similarly, the foreground for ``entry4'' will be half-way between white and
red, and the background will be half-way between green and white.
.IP "\fBMakeTitle\fP { \fIwin-list\fP }" 8
This variable specifies a list of windows on which a titlebar should be placed
and is used to request titles on specific windows when \fBNoTitle\fP has been
set.
.IP "\fBMapWindowBackground\fP \fBcolor\fP [{ \fBwin-list\fP }]" 8
This variable specifies the background colors to use for small windows in the
workspace map window and may only be specified inside of a Color or Monochrome
list. The optional \fBwin-list\fP is a list of window names and colors so
that per-window colors may be specified. If there is neither MapWindowBackground,
nor MapWindowForeground the window title colors are used.
.IP "\fBMapWindowCurrentWorkSpace\fP { \fBborder_color\fP [\fBbackground\fP] [\fBforeground\fP] [\fBbitmap\fP] }" 8
Specify the appearence of the map window corresponding to the current workspace.
.IP "\fBMapWindowDefaultWorkSpace\fP { \fBborder_color\fP [\fBbackground\fP] [\fBforeground\fP] [\fBbitmap\fP] }" 8
Specify the appearence of the map window corresponding to the workspaces other
than the current workspace when no root background information has been provided
to \fIctwm\fP in the WorkSpace command. Not used in others cases.
.IP "\fBMapWindowForeground\fP \fBcolor\fP [{ \fBwin-list\fP }]" 8
This variable specifies the foreground colors to use for small windows in the
workspace map window and may only be specified inside of a Color or Monochrome
list. The optional \fBwin-list\fP is a list of window names and colors so
that per-window colors may be specified. If there is neither MapWindowBackground,
nor MapWindowForeground the window title colors are used.
.IP "\fBMaxIconTitleWidth\fP \fIwidth\fP" 8
The integer argument tells \fIctwm\fP the maximun width to use for an
icon title. If an icon title is larger than \fIwidth\fP, it is truncated.
.IP "\fBMaxWindowSize\fP \fIstring\fP" 8
This variable specifies a geometry in which the width and height
give the maximum size for a given window.  This is typically used to 
restrict windows to the size of the screen.  The default is "30000x30000".
.IP "\fBMenuBackground\fP \fIstring\fP" 8
This variable specifies the background color used for menus,
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "white".
.IP "\fBMenuFont\fP \fIstring\fP" 8
This variable specifies the font to use when displaying menus.  The default
is "variable".
.IP "\fBMenuForeground\fP \fIstring\fP" 8
This variable specifies the foreground color used for menus,
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMenuShadowColor\fP \fIstring\fP" 8
This variable specifies the color of the shadow behind pull-down menus
and can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMenuShadowDepth\fP \fIpixels\fP" 8
This variable specifies the depth of the shadow \fIctwm\fP uses for
3D menus, when UseThreeDMenus is selected.
.IP "\fBMenuTitleBackground\fP \fIstring\fP" 8
This variable specifies the background color for \fBf.title\fP entries in
menus, and
can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "white".
.IP "\fBMenuTitleForeground\fP \fIstring\fP" 8
This variable specifies the foreground color for \fBf.title\fP entries in
menus and
can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMonochrome\fP { \fIcolors\fP }" 8
This variable specifies a list of color assignments that should be made if
the screen has a depth of 1.  See the description of \fBColors\fP.
.IP "\fBMoveDelta\fP \fIpixels\fP" 8
This variable specifies the number of pixels the pointer
must move before the \fBf.move\fP function starts working.  Also
see the \fBf.deltastop\fP function.  The default is zero pixels.
.IP "\fBMovePackResistance\fP \fIpixels\fP" 8
This variable specifies the number of pixels of the movepack and movepush
resistance. See \fIf.movepack\fP and \fIf.movepush\fP.
.IP "\fBMoveOffResistance\fP \fIpixels\fP" 8
This variable specifies the number of pixels of the moveoff resistance.
If \fIpixels\fP is positive, \fBDontMoveOff\fP will only prevent
you from going off the edge if you're within n pixels off the edge. If you
go further, \fBDontMoveOff\fP gives up and lets you go as far as you wish. 
\fBf.forcemove\fP still allows you to totally ignore \fBDontMoveOff\fP.
A negative value puts you back into "never moveoff" mode (it's the default).
.IP "\fBNoBackingStore\fP" 8
This variable indicates that \fIctwm\fP's menus should not request backing
store to minimize repainting of menus.  This is typically
used with servers that can repaint faster than they can handle backing store.
.IP "\fBNoBorder\fP { \fIwin-list\fP }" 8
These windows won't have border. If you want no borders on all windows,
use the BorderWidth keyword.
.IP "\fBNoCaseSensitive\fP" 8
This variable indicates that case should be ignored when sorting icon names
in an icon manager.  This option is typically used with applications that 
capitalize the first letter of their icon name.
.IP "\fBNoDefaults\fP" 8
This variable indicates that \fIctwm\fP should not supply the default 
titlebuttons and bindings.  This option should only be used if the startup
file contains a completely new set of bindings and definitions.
.IP "\fBNoGrabServer\fP" 8
This variable indicates that \fIctwm\fP should not grab the server
when popping up menus and moving opaque windows.
.IP "\fBNoHighlight\fP [{ \fIwin-list\fP }]" 8
This variable indicates that borders should not be highlighted to track the
location of the pointer.  If the optional \fIwin-list\fP is given, highlighting
will only be disabled for those windows.
When the border is highlighted, it will
be drawn in the current \fBBorderColor\fP.  When the border is not
highlighted, it will be stippled with an gray pattern using the
current \fBBorderTileForeground\fP and \fBBorderTileBackground\fP colors.
.IP "\fBNoIconTitle\fP [{ \fIwin-list\fP }]" 8
This variable indicates that icons should not display the icon name
of the client.  If the
optional \fIwin-list\fP is given, only those clients will not have
icon titles.
.IP "\fBNoIconManagerFocus\fP" 8
This variable indicates that ctwm will not set the focus on the corresponding
window when the pointer is in an IconManager.
.IP "\fBNoIconManagers\fP" 8
This variable indicates that no icon manager should be created.
.IP "\fBNoMenuShadows\fP" 8
This variable indicates that menus should not have drop shadows drawn behind
them.  This is typically used with slower servers since it speeds up menu
drawing at the expense of making the menu slightly harder to read.
.IP "\fBNoOpaqueMove\fP { \fIwindow-list\fP }" 8
The counterpart of \fBOpaqueMove\fP. See \fBOpaqueMove\fP.
.IP "\fBNoOpaqueResize\fP { \fIwindow-list\fP }" 8
The counterpart of \fBOpaqueResize\fP. See \fBOpaqueResize\fP.
.IP "\fBNoRaiseOnDeiconify\fP" 8
This variable indicates that windows that are deiconified should not be 
raised.
.IP "\fBNoRaiseOnMove\fP" 8
This variable indicates that windows should not be raised when moved.  This
is typically used to allow windows to slide underneath each other.
.IP "\fBNoRaiseOnResize\fP" 8
This variable indicates that windows should not be raised when resized.  This
is typically used to allow windows to be resized underneath each other.
.IP "\fBNoRaiseOnWarp\fP" 8
This variable indicates that windows should not be raised when the pointer
is warped into them with the \fBf.warpto\fP function.  If this option is set,
warping to an occluded window may result in the pointer ending up in the
occluding window instead the desired window (which causes unexpected behavior
with \fBf.warpring\fP). 
.IP "\fBNoSaveUnders\fP" 8
This variable indicates that menus should not request save-unders to minimize
window repainting following menu selection.  It is typically used with displays
that can repaint faster than they can handle save-unders.
.IP "\fBNoShowOccupyAll\fP" 8
This variable specifies that OccupyAll windows won't be displayed in the
WorkSpaceMap window.
.IP "\fBNoStackMode\fP [{ \fIwin-list\fP }]" 8
This variable indicates that client window requests to change stacking order 
should be ignored.  If the optional \fIwin-list\fP is given, only requests on 
those windows will be ignored.  This is typically used to prevent applications
from relentlessly popping themselves to the front of the window stack.
.IP "\fBNoTitle\fP [{ \fIwin-list\fP }] " 8
This variable indicates that windows should not have titlebars.  If the 
optional \fIwin-list\fP is given, only those windows will not have titlebars.
\fBMakeTitle\fP may be used with this option to force titlebars to be put
on specific windows.
.IP "\fBNoTitleFocus\fP" 8
This variable indicates that \fIctwm\fP should not set keyboard input focus to
each window as it is entered.  Normally, \fIctwm\fP sets the focus
so that focus and key events from the titlebar and
icon managers are delivered to the application.  If the pointer is moved
quickly and \fIctwm\fP is slow to respond, input can be directed to the old
window instead of the new.  This option is typically
used to prevent this ``input lag'' and to 
work around bugs in older applications that have problems with focus events.
.IP "\fBNoTitleHighlight\fP [{ \fIwin-list\fP }]" 8
This variable indicates that the highlight area of the titlebar, which is
used to indicate the window that currently has the input focus, should not
be displayed.  If the optional \fIwin-list\fP is given, only those windows
will not have highlight areas.  This and the \fBSqueezeTitle\fP options
can be set to substantially reduce the amount of screen space required by
titlebars.
.IP "\fBOccupy\fP { \fIoccupy-list\fP }" 8
This variable specifies which windows occupy which workspaces at startup.
.IP
\fIoccupy-list\fP consists of entries of the form :
.EX
        [Window]   win-name { wpsc1 wspc2 ... }
or      Workspace  wspc-name {win1 win2 ... }
.EE
Example :
.EX
Occupy {
               "xload"   {"all"}
    Window     "xterm"   {"here" "there" "elsewhere"}
               "xv"      {"images"}
    WorkSpace  "images"  {"xloadimage"}
}
.EE
Note : The Occupy declaration should come after the WorkSpaces declaration.

.IP "\fBOccupyAll\fP { \fIwindow-list\fP }" 8
.IP
This variable specifies a list of windows that will occupy all workspaces at startup.
.IP
\fIwindow-list\fP is a list of window names.
.IP
Example :
.EX
OccupyAll
{
    "xload"
    "xbiff"
    "xconsole"
}
.EE
Note : The OccupyAll declaration should come after the WorkSpaces declaration.

.IP "\fBOpaqueMove\fP { \fIwindow-list\fP }" 8
This variable indicates that the \fBf.move\fP function should actually move
the window instead of just an outline so that the user can immediately see
what the window will look like in the new position.  This option is typically
used on fast displays (particularly if \fBNoGrabServer\fP is set). The optional
window list parameter indicates that only windows in this list should actually
be moved in opaque mode. The \fBNoOpaqueMove\fP counterpart is also available.

.IP "\fBOpaqueMoveThreshold\fP { \fIthreshold\fP }" 8
The integer parameter is a percentage and indicates that only windows (elligible
for opaque moving) with a surface smaller than this percentage of the surface
of the screen should actually be moved in opaque mode. 

.IP "\fBOpaqueResize\fP { \fIwindow-list\fP }" 8
The opaque version of resize. Extremely resource intensive,
but beautiful with fast server/client/network. See \fBOpaqueMove\fP. The
\fBNoOpaqueResize\fP counterpart is also available.

.IP "\fBOpaqueResizeThreshold\fP { \fIthreshold\fP }" 8
The resize version of \fBOpaqueMoveThreshold\fP.

.IP "\fBOpenWindowTimeout\fP \fIseconds\fP" 8
seconds is an integer representing a number of second. When a window
tries to open on an unattended display, it will be automatically
mapped after this number of seconds.

.IP "\fBPackNewWindows\fP" 8
Use f.movepack algorithm instead of f.move when opening a new window.

.IP "\fBPixmaps\fP { \fIpixmaps\fP }" 8
This variable specifies a list of pixmaps that define the appearance of various
images.  Each entry is a keyword indicating the pixmap to set, followed by a 
string giving the name of the bitmap file.  The following pixmaps 
may be specified:
.EX 0
\fBPixmaps\fP
{
	TitleHighlight	"gray1"
#    TitleHighlight "supman%.xbm"
}
.EE
The default for \fITitleHighlight\fP is to use an even stipple pattern.

.IP "\fBPixmapDirectory\fP \fIpath\fP " 8
This variable specifies the path where \fIctwm\fP looks to find non-X11 bitmap
files.  Whenever you want to use a image file that is not an X11 bitmap,
specify : xpm:filename (for xpm files) or xwd:filename for xwd files,
or im:filename (for other files supported by the imconv package), or
|command for an on the file generated xwd file. Use the % character
to specify an animation. \fIpath\fP can be a colon separated list of directories.
Example :
.EX
PixmapDirectory  "/usr/lib/X11/twm"
Icons
{
    "Axe"    "xpm:edit.xpm"
    "xterm"  "xpm:ball%.xpm"
}
.EE
N.B This is only valid if your version of \fIctwm\fP has been compiled with the
XPM and IMCONV options.

.IP "\fBRaiseDelay\fP \fImilliseconds\fP" 8
For windows that are to be automatically raised when the pointer enters
(see the \fBAutoRaise\fP variable and the \fIf.autoraise\fP function)
this variable specifies the length of time the pointer should rest in
the window before it is raised.  The default is 0 milliseconds.

.IP "\fBRaiseOnClick\fP" 8
If present a window will be raised on top of others when clicked on, and the
ButtonPress event will be correctly forwarded to the client that owns this window
(if it asked to). See \fBRaiseOnClickButton\fP.

.IP "\fBRaiseOnClickButton\fP \fIbutton_number\fP" 8
Where \fIbutton_number\fP is a valid button number (generally 1 to 3). Specify
the button to use for RaiseOnClick.

.IP "\fBRaiseWhenAutoUnSqueeze\fP" 8
Windows are raised when auto-unsqueezed (See AutoSqueeze).

.IP "\fBRandomPlacement\fP [ \fIstring\fP ]" 8
Where \fIstring\fP is either "on", "off", "all" or "unmapped".
This variable indicates that windows with no specified geometry should
be placed in a pseudo-random location instead of having the user drag out
an outline. The argument "on" or "all" tells ctwm do do this for all such windows,
"off", not to do this, and "unmapped", only for unmapped windows, e.g.
iconified or not visible in the current workspace.

.IP "\fBReallyMoveInWorkspaceManager\fP" 8
This keyword tells \fIctwm\fP to move the actual window when the user is
moving the small windows in the WorkSpaceMap window. If not present the 
WorkSpaceMap can be used only to modify the occupation of a window.

.IP "\fBResizeFont\fP \fIstring\fP" 8
This variable specifies the font to be used for in the dimensions window when
resizing windows.  The default is "fixed".

.IP "\fBRestartPreviousState\fP" 8
This variable indicates that 
\fIctwm\fP should attempt to use the WM_STATE property on client windows
to tell which windows should be iconified and which should be left visible.
This is typically used to try to regenerate the state that the screen
was in before the previous window manager was shutdown.

.IP "\fBReverseCurrentWorkspace\fP \fIstring\fP" 8
This variable specifies tells \fIctwm\fP to reverse the background and
foreground colors in the small windows in the workspace map for the current
workspace.

.IP "\fBSaveColor\fP { \fIcolors-list\fP }" 8
This variable indicates a list of color assignments to be stored as pixel
values in the root window property _MIT_PRIORITY_COLORS.  Clients may elect
to preserve these values when installing their own colormap.  Note that
use of this mechanism is a way an for application to avoid the "technicolor" 
problem, whereby useful screen objects such as window borders and titlebars
disappear when a programs custom colors are installed by the window
manager.
For example:
.EX 0
\fBSaveColor\fP
{
        BorderColor
        TitleBackground
        TitleForeground
        "red"
        "green"
        "blue"
}
.EE
This would place on the root window 3 pixel values for borders and titlebars,
as well as the three color strings, all taken from the default colormap.

.IP "\fBSchrinkIconTitles\fP" 8
A la Motif schrinking of icon titles, and expansion when mouse is inside icon.

.IP "\fBShortAllWindowsMenus\fP" 8
Don't show WorkSpaceManager and IconManagers in the TwmWindows and TwmAllWindows menus.

.IP "\fBShowIconManager\fP" 8
This variable indicates that the icon manager window should be displayed when
\fIctwm\fP is started.  It can always be brought up using the
\fBf.showiconmgr\fP function.

.IP "\fBShowWorkSpaceManager\fP" 8
This variable specifies that the WorkSpaceManager should be visible.

.IP "\fBSortIconManager\fP" 8
This variable indicates that entries in the icon manager should be 
sorted alphabetically rather than by simply appending new windows to 
the end.

.IP "\fBSqueezeTitle\fP [{ \fIsqueeze-list\fP }] " 8
This variable indicates that \fIctwm\fP should attempt to use the SHAPE
extension to make titlebars occupy only as much screen space as they need,
rather than extending all the way across the top of the window.
The optional \fIsqueeze-list\fP
may be used to control the location of the squeezed titlebar along the
top of the window.  It contains entries of the form:
.EX 0
	"\fIname\fP"		\fIjustification\fP	\fInum\fP	\fIdenom\fP
.EE
where \fIname\fP is a window name, \fIjustification\fP is either \fBleft\fP,
\fBcenter\fP, or \fBright\fP, and \fInum\fP and \fIdenom\fP
are numbers specifying a ratio giving the relative position about which
the titlebar is justified.  The ratio is measured from left to right if
the numerator is positive, and right to left if negative.  A denominator
of 0 indicates that the numerator should be measured in pixels.  For 
convenience, the ratio 0/0 is the same as 1/2 for \fBcenter\fP and -1/1
for \fBright\fP.  For example:
.EX 0
\fBSqueezeTitle\fP
{
	"XTerm"	left		0	0
	"xterm1"	left		1	3
	"xterm2"	left		2	3
	"oclock"	center		0	0
	"emacs"	right		0	0
}
.EE
The \fBDontSqueezeTitle\fP list can be used to turn off squeezing on 
certain titles.

.IP "\fBStartIconified\fP [{ \fIwin-list\fP }] " 8
This variable indicates that client windows should initially be left as
icons until explicitly deiconified by the user.  If the optional \fIwin-list\fP
is given, only those windows will be started iconic.  This is useful for
programs that do not support an \fI-iconic\fP command line option or
resource.

.IP "\fBStartInMapState\fP" 8
This variable specifies that the WorkSpaceManager should be started
in its map form when created.

.IP "\fBStartSqueezed\fP" { \fIwin-list\fP }" 8
These windows will first show up squeezed (see f.squeeze).

.IP "\fBStayUpMenus\fP" 8
Tells ctwm to use stayup menus. These menus
will stay on the screen when ButtonUp, if either the menu has not
yet been entered by the pointer, or the current item is a f.title.

.IP "\fBSunkFocusWindowTitle\fP" 8
This variable specifies that the title of the focus window (if exists)
should be sunken instead of raised. Only valid if UseThreeDTitles is set.

.IP "\fBThreeDBorderWidth\fP  \fIpixels\fP" 8
The width of the 3D border in pixels, if any.

.IP "\fBTitleBackground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the background color used in titlebars,
and may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.
The default is "white".

.IP "\fBTitleButtonBorderWidth\fP \fIpixels\fP" 8
This variable specifies the width in pixels of the border surrounding
titlebuttons.  This is typically set to 0 to allow titlebuttons to take up as
much space as possible and to not have a border.
The default is 1 if \fIUseThreeDTitles\fP is not set, 0 if it is set.

.IP "\fBTitleButtonShadowDepth\fP \fIpixels\fP" 8
This variable specifies the depth of the shadow \fIctwm\fP uses for
3D title buttons, when UseThreeDTitles is selected.

.IP "\fBTitleFont\fP \fIstring\fP" 8
This variable specifies the font to used for displaying window names in
titlebars.  The default is "variable".

.IP "\fBTitleForeground\fP \fIstring\fP [{ \fIwin-list\fP }]" 8
This variable specifies the foreground color used in titlebars, and
may only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The optional \fIwin-list\fP is a list of window names and colors so that
per-window colors may be specified.
The default is "black".

.IP "\fBTitleJustification\fP \fIstring\fP" 8
This keyword needs a string value. The acceptable values are : "left",
"center" and "right". The window titles will be justified according to
this in the title window.

.IP "\fBTitlePadding\fP \fIpixels\fP" 8
This variable specifies the distance between the various buttons, text, and
highlight areas in the titlebar.  The default is 8 pixels if \fIUseThreeDTitles\fP
is not set, 0 if it is set.

.IP "\fBTitleShadowDepth\fP \fIpixels\fP" 8
This variable specifies the depth of the shadow \fIctwm\fP uses for
3D titles, when UseThreeDTitles is selected.

.IP "\fBTransientHasOccupation\fP" 8
This variable specifies that transient-for and non-group leader windows
can have their own occupation potentially different from their leader
window. The default case is that these windows follow their leader, use
this keyword if the default action doesn't please you.

.IP "\fBTransientOnTop\fP \fIpercentage\fP" 8
The parameter (required) is a percentage and tells \fIctwm\fP to put transient
(and non-group leader) windows always on top of their leader if and only
if their surface is smaller than this fraction of the surface of their
leader. The surface of a window is its width times its weight.

.IP "\fBUnknownIcon\fP \fIstring\fP" 8
This variable specifies the filename of a bitmap file to be
used as the default icon.  This bitmap will be used as the icon of all
clients which do not provide an icon bitmap and are not listed
in the \fBIcons\fP list.

.IP "\fBUnmapByMovingFarAway\fP [{ \fIwin-list\fP }] " 8
These windows will be moved out of the screen instead of beeing unmapped
when they become invisible due to a change workspace. This has been
added because some ill-behaved clients (Frame5) don't like to be unmapped.

.IP "\fBUsePPosition\fP \fIstring\fP" 8
This variable specifies whether or not \fIctwm\fP should honor 
program-requested locations (given by the \fBPPosition\fP flag in the
WM_NORMAL_HINTS property) in the absence of a user-specified position.
The argument \fIstring\fP may have one of three values:  \fB"off"\fP
(the default) indicating that \fIctwm\fP should ignore the program-supplied
position, \fB"on"\fP indicating that the position should be used, and 
\fB"non-zero"\fP indicating that the position should used if it is other
than (0,0).  The latter option is for working around a bug in older toolkits.

.IP "\fBUseSunkTitlePixmap\fP" 8
This makes it so the shadows are inversed for title pixmaps when focus is lost.
This is similar to having the SunkFocusWindowTitle, but it makes your xbm or
3d XPM (if any) sink instead of just the whole bar.

.IP "\fBUseThreeDBorders\fP" 8
Tells \fIctwm\fP to use 3D-looking window borders. The width ot the 3D borders
is \fBThreeDBorderWidth\fP. The color of the 3D border is \fBBorderTileBackground\fP,
and if NoHighlight is not selected, the border of the Focus window is
\fBBorderColor\fP.

.IP "\fBUseThreeDIconManagers\fP" 8
Tells \fIctwm\fP to use 3D-looking IconManagers if any.

.IP "\fBUseThreeDMenus\fP" 8
Tells \fIctwm\fP to use 3D-looking menus.

.IP "\fBUseThreeDTitles\fP" 8
Tells \fIctwm\fP to use 3D-looking windows titles. In which case the default
values of \fBTitleButtonBorderWidth\fP, \fBFramePadding\fP, \fBTitlePadding\fP
and \fBButtonIndent\fP are set to 0.
There are plenty of built-in scalable pixmaps for buttons, :xpm:menu, :xpm:dot,
:xpm:resize, :xpm:bar, :xpm:vbar, :xpm:iconify, :xpm:resize and
:xpm:box. There is several built-in scalable
animation for buttons : %xpm:resize, %xpm:menu-up, %xpm:menu-down, 
%xpm:resize-out-top, %xpm:resize-in-top, %xpm:resize-out-bot, 
%xpm:resize-in-bot, %xpm:maze-out, %xpm:maze-in, %xpm:zoom-out,
%xpm:zoom-in and %xpm:zoom-inout. Try them to see what they look like.

.IP "\fBUseThreeDWMap\fP" 8
Tells \fIctwm\fP to use 3D for the small windows in the workspace map.

.IP "\fBWarpCursor\fP [{ \fIwin-list\fP }]" 8
This variable indicates that the pointer should be warped into windows when
they are deiconified.  If the optional \fIwin-list\fP is given, the pointer
will only be warped when those windows are deiconified.

.IP "\fBWindowRing\fP [{ \fIwin-list\fP }]" 8
This variable specifies a list of windows along which the \fBf.warpring\fP 
function cycles. If no argument is given, all the windows are in the ring.

.IP "\fBWarpRingOnScreen\fP" 8
Tells \fIctwm\fP that f.warpring warps pointer only to windows visible in
the current workspace.

.IP "\fBWarpToDefaultMenuEntry\fP" 8
(Useful only with StayUpMenus) When using StayUpMenus, and a menu does
stays up, the pointer is warped to the default entry of the menu.

.IP "\fBWarpUnmapped\fP" 8
This variable indicates that that the \fBf.warpto\fP function should deiconify
any iconified windows it encounters.  This is typically used to make a key
binding that will pop a particular window (such as \fIxmh\fP), no matter
where it is.  The default is for \fBf.warpto\fP to ignore iconified windows.

.IP "\fBWMgrButtonShadowDepth\fP \fIdepth\fP" 8
Control the depth of the shadow of the workspace manager buttons.

.IP "\fBWMgrHorizButtonIndent\fP \fInb_pixels\fP" 8
Specifies the horizontal space, in pixel, between the buttons of the workspace
manager (in button mode).

.IP "\fBWMgrVertButtonIndent\fP \fInb_pixels\fP" 8
Specifies the vertical space, in pixel, between the buttons of the workspace
manager (in button mode).

.IP "\fBWorkSpaceFont\fP \fIstring\fP" 8
This allows you to specify the font to use for the small windows in the
workspace manager map. (Try "-adobe-times-*-r-*--10-*-*-*-*-*-*-*").

.IP "\fBWorkSpaceManagerGeometry\fP \fIstring\fP [ \fIcolumns\fP ]" 8
This variable specifies the geometry of the workspace manager window. The
\fIstring\fP argument is standard geometry specification that indicates
the initial full size of the workspace manager. The \fIcolumns\fP argument
indicates the number of columns to use for the workspace manager window.
.EX
\fBWorkSpaceManagerGeometry\fP        "360x60+60-0" 8
.EE
.IP "\fBWorkSpaces\fP { \fIworkspace-list\fP }" 8
This variable specifies a list of workspaces that are created at startup,
Where \fIworkspace-list\fP is :
.EX
name [{bg-button [fg-button] [bg-root] [fg-root] [pixmap-root]}]
.EE
.IP
With :
.RS 8
.TP 8
.B "bg-button:"
background color of the corresponding button in the workspace manager.
.TP 8
.B "fg-button:"
foreground color of the corresponding button in the workspace manager.
.TP 8
.B "bg-root:"
background color of the corresponding root screen.
.TP 8
.B "fg-root:"
foreground color of the corresponding root screen.
.TP 8
.B "pixmap-root:"
pixmap to display on the corresponding root screen, either the name of
a bitmap, xpm:xpmfile, xwd:xwdfile, im:imfile or |command_that generate_xwd.
.RE
.IP
Example :
.EX
WorkSpaces
{
  "One"   {"#686B9F" "white" "DeepSkyBlue3" "white" "xlogo16"}
  "Two"   {"#619AAE" "white" "firebrick"}
  "Three" {"#727786" "white" "MidnightBlue" "white" "xpm:ball%.xpm"}
  "Four"  {"#727786" "white" "white" "white" "|(giftoppm | pnmtoxwd) < 2010.gif"}

  "Five"  {"#727786" "white" "DeepSkyBlue3" "white" "plaid"}
  "Six"   {"#619AAE" "white" "DeepSkyBlue3" "white" "xpm:background1"}
  "Seven" {"#8C5b7A" "white" "chartreuse4"}
  "Eight" {"#686B9F" "white" "MidnightBlue"}
}
.EE
.IP
The WorkSpaces declaration should come before the Occupy or OccupyAll
declarations. The maximum number of workspaces is 32.

.IP "\fBXMoveGrid\fP \fInumber\fP" 8
This variable specifies the value to use to constrain window movement.
When moving windows around, the x coordinate will always be a multiple of
this variable. Default id 1. f.forcemove ignores this variable.

.IP "\fBYMoveGrid\fP \fInumber\fP" 8
Same with y coordinate.

.IP "\fBXorValue\fP \fInumber\fP" 8
This variable specifies the value to use when drawing window outlines for
moving and resizing.  This should be set to a value that will result in a 
variety of distinguishable colors when exclusive-or'ed with the contents of the
user's typical screen.  Setting this variable to 1 often gives nice results
if adjacent colors in the default colormap are distinct.  By default, 
\fIctwm\fP will attempt to cause temporary lines to appear at the opposite 
end of the colormap from the graphics.

.IP "\fBYMoveGrid\fP \fInumber\fP" 8
This variable specifies the value to use to constrain window movement.
When moving windows around, the y coordinate will always be a multiple of
this variable. Default id 1. f.forcemove ignores this variable.

.IP "\fBZoom\fP [ \fIcount\fP ]" 8
This variable indicates that outlines suggesting movement of a window
to and from its iconified state should be displayed whenever a window is
iconified or deiconified.  The optional \fIcount\fP argument specifies the
number of outlines to be drawn.  The default count is 8.
.PP
The following variables must be set after the fonts have been
assigned, so it is usually best to put them at the end of the variables
or beginning of the bindings sections:

.IP "\fBChangeWorkspaceFunction\fP \fIfunction\fP" 8
This variable specifies the function to be executed when the user change
the current workspace (zap).

.IP "\fBDefaultFunction\fP \fIfunction\fP" 8
This variable specifies the function to be executed when a key or button
event is received for which no binding is provided.  This is typically
bound to \fBf.nop\fP, \fBf.beep\fP, or a menu containing window operations.

.IP "\fBDeIconifyFunction\fP \fIfunction\fP" 8
This variable specifies the function to be executed when a window is
deiconified.

.IP "\fBIconifyFunction\fP \fIfunction\fP" 8
This variable specifies the function to be executed when a window is
iconified.

.IP "\fBWindowFunction\fP \fIfunction\fP" 8
This variable specifies the function to execute when a window is selected 
from the \fBTwmWindows\fP menu.  If this variable is not set, the window
will be deiconified and raised.
.SH BINDINGS
.PP
After the desired variables have been set, functions may be attached 
titlebuttons and key and pointer buttons.  Titlebuttons may be added
from the left or right side and appear in the titlebar from left-to-right 
according to the
order in which they are specified.  Key and pointer button
bindings may be given in any order.
.PP
Titlebuttons specifications must include the name of the pixmap to use in
the button box and the function to be invoked when a pointer button is 
pressed within them:
.EX 0
\fBLeftTitleButton\fP "\fIbitmapname\fP"	= \fIfunction\fP
.EE
or
.EX 0
\fBLeftTitleButton\fP "\fIbitmapname\fP" {
    Button\fIi\fP : \fIfunction\fP
    ...
    Button\fIj\fP : \fIfunction\fP
}
.EE
or
.EX 0
\fBRightTitleButton\fP "\fIbitmapname\fP"	= \fIfunction\fP
.EE
or
.EX 0
\fBRightTitleButton\fP "\fIbitmapname\fP" {
    Button\fIi\fP : \fIfunction\fP
    ...
    Button\fIj\fP : \fIfunction\fP
}
.EE
The \fIbitmapname\fP may refer to one of the  built-in bitmaps
(which are scaled to match \fBTitleFont\fP) by using the appropriate
colon-prefixed name described above.
.PP
Key and pointer button specifications must give the modifiers that must
be pressed, over which parts of the screen the pointer must be, and what
function is to be invoked.  Keys are given as strings containing the 
appropriate
keysym name; buttons are given as the keywords \fBButton1\fP-\fBButton5\fP:
.EX 0
"FP1"		= \fImodlist\fP : \fIcontext\fP : \fIfunction\fP
\fBButton1\fP	= \fImodlist\fP : \fIcontext\fP : \fIfunction\fP
.EE
The \fImodlist\fP is any combination of the modifier names \fBshift\fP,
\fBcontrol\fP, \fBlock\fP, \fBmeta\fP, \fBmod1\fP, \fBmod2\fP, \fBmod3\fP,
\fBmod4\fP, or \fBmod5\fP (which may be abbreviated as 
\fBs\fP, \fBc\fP, \fBl\fP, \fBm\fP, \fBm1\fP, \fBm2\fP, \fBm3\fP, \fBm4\fP, 
\fBm5\fP, respectively) separated by a vertical bar (\(or).
Similarly, the \fIcontext\fP is any combination of 
\fBwindow\fP,
\fBtitle\fP,
\fBicon\fP,
\fBroot\fP,
\fBframe\fP,
\fBiconmgr\fP, their first letters (\fBiconmgr\fP abbreviation is \fBm\fP),
or \fBall\fP,
separated by a vertical bar.  The \fIfunction\fP is any of the \fBf.\fP 
keywords described below.  For example, the default startup
file contains the following bindings:
.EX 0
Button1	=	: root		: f.menu "TwmWindows"
Button1	= m	: window | icon	: f.function "move-or-lower"
Button2	= m	: window | icon	: f.iconify
Button3	= m	: window | icon	: f.function "move-or-raise"
Button1	=	: title		: f.function "move-or-raise"
Button2	=	: title		: f.raiselower
Button1	=	: icon		: f.function "move-or-iconify"
Button2	=	: icon		: f.iconify
Button1	=	: iconmgr	: f.iconify
Button2	=	: iconmgr	: f.iconify
.EE
A user who wanted to be able to manipulate windows from the keyboard could
use the following bindings:
.EX 0
"F1"		=	: all		: f.iconify
"F2"		=	: all		: f.raiselower
"F3"		=	: all		: f.warpring "next"
"F4"		=	: all		: f.warpto "xmh"
"F5"		=	: all		: f.warpto "emacs"
"F6"		=	: all		: f.colormap "next"
"F7"		=	: all		: f.colormap "default"
"F20"		=	: all		: f.warptoscreen "next"
"Left"		= m	: all		: f.backiconmgr
"Right"	= m | s	: all		: f.forwiconmgr
"Up"		= m	: all		: f.upiconmgr
"Down"	= m | s	: all		: f.downiconmgr
.EE
\fICtwm\fP provides many more window manipulation primitives than can be
conveniently stored in a titlebar, menu, or set of key bindings.  Although
a small set of defaults are supplied (unless the \fBNoDefaults\fP is 
specified), most users will want to have their most common operations
bound to key and button strokes.  To do this, \fIctwm\fP associates names
with each of the primitives and provides \fIuser-defined functions\fP for
building higher level primitives and \fImenus\fP for interactively selecting 
among groups of functions. 
.PP
User-defined functions contain the name by which they are referenced in
calls to \fBf.function\fP and a list of other functions to execute.  For
example:
.EX 0
Function "move-or-lower"	{ f.move f.deltastop f.lower }
Function "move-or-raise"	{ f.move f.deltastop f.raise }
Function "move-or-iconify"	{ f.move f.deltastop f.iconify }
Function "restore-colormap"	{ f.colormap "default" f.lower }
.EE
The function name must be used in \fBf.function\fP exactly as it appears in 
the function specification.
.PP
In the descriptions below, if the function is said to operate on the selected
window, but is invoked from a root menu, the cursor will be changed to
the \fBSelect\fP cursor and the next window to receive a button press will
be chosen:
.IP "\fB!\fP \fIstring\fP" 8
This is an abbreviation for \fBf.exec\fP \fIstring\fP.
.\"OBSOLETE - use a clipboard client
.\".IP "\fB^\fP \fIstring\fP" 8
.\"This is an abbreviation for \fBf.cut\fP \fIstring\fP.
.IP "\fBf.addtoworkspace\fP \fIstring\fP" 8
This function adds the selected window to the workspace whose name is
\fIstring\fP.
.IP "\fBf.adoptwindow\fP" 8
This function ask for the user to select a window with the mouse, and then
adopt this window is it doesn't belong to the current ctwm. Useful only
with the -w flag.
.IP "\fBf.altcontext\fP" 8
Set the alternate context. The next key or button event \fIctwm\fP reveives will
be interpreted using the alternate context. To define bindings in the alternate
context, use the keyword \fBalter\fP in the context field of the binding command.
For example:
.EX 0
"Return"= m	: all		: f.altcontext
"n"	= 	: alter		: f.nextworkspace
"p"	= 	: alter		: f.prevworkspace
.EE

.IP "\fBf.altkeymap\fP \fInumber\fP" 8
Set the alternate keymap \fBnumber\fP, where \fBnumber\fP is an integer
between 1 and 5 included. The next key or button event \fIctwm\fP reveives will
be interpreted using this alternate keymap. To define bindings in an alternate
keymap, use the keyword \fBa\fP followed by \fBnumber\fP in the modifier
field of the binding command. For example:
.EX 0
"Return"= c	: all		: f.altkeymap "1"
"i"	= a1	: window|icon|iconmgr	: f.iconify
"z"	= a1	: window	: f.zoom
"d"	= a1	: window|icon	: f.delete
"o"	= a1	: window|icon	: f.occupy
"r"	= a1	: window|icon	: f.refresh
.EE
.PP
When using an alternate keymaps, only the root, window, icon and iconmgr
contexts are allowed.

.IP "\fBf.autolower\fP" 8
This function toggles whether or not the selected window is lowered
whenever the pointer leaves it.  See the description of the variable
\fBAutoLower\fP.

.IP "\fBf.autoraise\fP" 8
This function toggles whether or not the selected window is raised whenever
entered by the pointer.  See the description of the variable \fBAutoRaise\fP.

.IP "\fBf.backmapiconmgr\fI" 8
This function warps the  pointer in the same manner as \fBf.backiconmgr\fP
but only stops at windows that are mapped.

.IP "\fBf.backiconmgr\fI" 8
This function warps the pointer to the previous column in the 
current icon manager, wrapping back to the previous row if necessary.

.IP "\fBf.beep\fP" 8
This function sounds the keyboard bell.

.IP "\fBf.bottomzoom\fP" 8
This function is similar to the \fBf.fullzoom\fP function, but
resizes the window to fill only the bottom half of the screen.

.IP "\fBf.circledown\fP" 8
This function lowers the top-most window that occludes another window.

.IP "\fBf.circleup\fP" 8
This function raises the bottom-most window that is occluded by another window.

.IP "\fBf.colormap\fP \fIstring\fP" 8
This function rotates the colormaps (obtained from the WM_COLORMAP_WINDOWS
property on the window) that \fIctwm\fP will display when the pointer
is in this window.  The argument \fIstring\fP may have one of the following 
values: \fB"next"\fP, \fB"prev"\fP, and \fB"default"\fP.  It should be noted
here that in general, the installed colormap is determined by keyboard focus.
A pointer driven keyboard focus will install a private colormap upon entry
of the window owning the colormap.  Using the click to type model, private
colormaps will not be installed until the user presses a mouse button on
the target window.
.\"OBSOLETE - should go away and use a clipboard.
.\".IP "\fBf.cut\fP \fIstring\fP" 8
.\"This function places the specified \fIstring\fP (followed by a newline
.\"character) into the root window property CUT_BUFFER0.  
.\".IP "\fBf.cutfile\fP" 8
.\"This function reads the file indicated by the contents of the CUT_BUFFER0
.\"window property and replaces the cut buffer.
.IP "\fBf.deiconify\fP" 8
This function deiconifies the selected window.  If the window is not an icon, 
this function does nothing.

.IP "\fBf.delete\fP" 8
This function sends the WM_DELETE_WINDOW message to the selected window if
the client application has requested it through the WM_PROTOCOLS window
property.  The application is supposed to respond to the message by removing
the indicated window.  If the window has not requested
WM_DELETE_WINDOW messages, the keyboard bell will be rung indicating that 
the user should choose an alternative method.  Note this is very different
from f.destroy.  The intent here is to delete a single window,  not 
necessarily the entire application.

.IP "\fBf.deleteordestroy\fP" 8
First tries to delete the window (send it WM_DELETE_WINDOW message),
or kills it, if the client doesn't accept such message.

.IP "\fBf.deltastop\fP" 8
This function allows a user-defined function to be aborted if the pointer has 
been moved more than \fIMoveDelta\fP pixels.  See the example definition
given for \fBFunction "move-or-raise"\fP at the beginning of the section.

.IP "\fBf.destroy\fP" 8
This function instructs the X server to close the display connection of the
client that created the selected window.  This should only be used as a last 
resort for shutting down runaway clients.  See also f.delete.

.IP "\fBf.downiconmgr\fI" 8
This function warps the pointer to the next row in the current icon manger,
wrapping to the beginning of the next column if necessary.

.IP "\fBf.downworkspace\fP" 8
Goto the workspace immediately underneath the current workspace in the workspace
manager. If the current workspace is the bottom one, goto the top one in the
same column. The result depends on the layout of the workspace manager.

.IP "\fBf.exec\fP \fIstring\fP" 8
This function passes the argument \fIstring\fP to /bin/sh for execution.
In multiscreen mode, if \fIstring\fP starts a new X client without
giving a display argument, the client will appear on the screen from
which this function was invoked. If the string "$currentworkspace" is present
inside the string argument, it will be substituated with the current workspace
name.

.\".IP "\fBf.file\fP \fIstring\fP" 8
.\"This function assumes \fIstring\fP is a file name.  This file is read into
.\"the window server's cut buffer.

.IP "\fBf.fill\fI \fIstring\fP" 8
Where string is either : "right", "left", "top" or "bottom".
The current window is resized in the specified direction until it
reaches an obstacle (either another window, or the screen border).

.IP "\fBf.focus\fP" 8
This function toggles the keyboard focus of the server to the
selected window, changing the focus rule from pointer-driven if necessary.
If the selected window already was focused, this function executes an
\fBf.unfocus\fP.  

.IP "\fBf.forcemove\fP" 8
This function is like \fBf.move\fP except that it ignores the \fBDontMoveOff\fP
variable.

.IP "\fBf.forwiconmgr\fI" 8
This function warps the pointer to the next column in the current icon
manager, wrapping to the beginning of the next row if necessary.

.IP "\fBf.forwmapiconmgr\fI" 8
This function warps the  pointer in the same manner as \fBf.forwiconmgr\fP
but only stops at windows that are mapped.

.IP "\fBf.fullzoom\fP" 8
This function resizes the selected window to the full size of the display or
else restores the original size if the window was already zoomed.

.IP "\fBf.function\fP \fIstring\fP" 8
This function executes the user-defined function whose name is specified
by the argument \fIstring\fP.  

.IP "\fBf.gotoworkspace\fP \fBworkspace_name\fP" 8
This function warps you to the workspace whose name is \fIworkspace_name\fP.

.IP "\fBf.hbzoom\fP" 8
This function is a synonym for \fBf.bottomzoom\fP.

.IP "\fBf.hideiconmgr\fP" 8
This function unmaps the current icon manager.

.IP "\fBf.hideworkspacemgr\fP" 8
Unmap the WorkSpace manager.

.IP "\fBf.horizoom\fP" 8
This variable is similar to the \fBf.zoom\fP function except that the 
selected window is resized to the full width of the display.

.IP "\fBf.htzoom\fP" 8
This function is a synonym for \fBf.topzoom\fP.

.IP "\fBf.hypermove\fP" 8
Use this function to "move" a window between 2 captives ctwm (or between a
captive and the root ctwm). Of course 2 Ctwm's are completely different
universes. You have to go in hyperspace to achieve this, hence the name.

.IP "\fBf.hzoom\fP" 8
This function is a synonym for \fBf.horizoom\fP.

.IP "\fBf.iconify\fP" 8
This function iconifies or deiconifies the selected window or icon, 
respectively.

.IP "\fBf.identify\fP" 8
This function displays a summary of the name and geometry of the
selected window.  Clicking the pointer or pressing a key in the window
will dismiss it.

.IP "\fBf.initsize\fP" 8
This function resets a window to its initial size given by the
WM_NORMAL_HINTS hints.

.IP "\fBf.jumpdown\fP \fIstep\fP" 8
This function is designed to be bound to a key, it moves the current window
(step * {X,Y}MoveGrid) pixels downward. stopping if the window encounters
another window or the screen border (ala f.pack).

.IP "\fBf.jumpleft\fP \fIstep\fP" 8
Leftward equivalent of f.jumpdown.

.IP "\fBf.jumpright\fP \fIstep\fP" 8
Rightward equivalent of f.jumpdown.

.IP "\fBf.jumpup\fP \fIstep\fP" 8
Upward equivalent of f.jumpdown.

.IP "\fBf.lefticonmgr\fI" 8
This function similar to \fBf.backiconmgr\fP except that wrapping does not
change rows.

.IP "\fBf.leftworkspace\fP" 8
Goto the workspace immediately on the left of the current workspace in the
workspace manager. If the current workspace is the leftest one, goto the
rightest one in the same row. The result depends on the layout of the workspace
manager.

.IP "\fBf.leftzoom\fP" 8
This variable is similar to the \fBf.bottomzoom\fP function but causes
the selected window is only resized to the left half of the display.

.IP "\fBf.lower\fP" 8
This function lowers the selected window.

.IP "\fBf.menu\fP \fIstring\fP" 8
This function invokes the menu specified by the argument \fIstring\fP.
Cascaded menus may be built by nesting calls to \fBf.menu\fP. When a menu
is popped up, you can use the arrow keys to move the cursor around it. "Down"
or space goes down, "Up" goes up, "Left" pops down the menu, and "Right"
activates the current entry. The first letter of an entry name activates this
entry (the first one if several entries match). If the first letter is ~ then
Meta-the-second-letter activates it, if this first letter is ^ then
Control-the-second-letter activates it, and if this first letter is space,
then the second letter activates it.

.IP "\fBf.move\fP" 8
This function drags an outline of the selected window (or the window itself
if the \fBOpaqueMove\fP variable is set) until the invoking pointer button
is released.  Double clicking within the number of milliseconds given by
\fBConstrainedMoveTime\fP warps
the pointer to the center of the window and
constrains the move to be either horizontal or vertical depending on which
grid line is crossed.
To abort a move, press another button before releasing the
first button.

.IP "\fBf.movepack\fP" 8
This function is like \fBf.move\fP except that it tries to avoid overlapping
of windows. When the moving window begin to overlap with another window, the
move is stopped. If you go too far over the other window (more that
\fIMovePackResistance\fP pixels), the move is resumed and the moving window
can overlap with the other window. Useful to pack windows closely.

.IP "\fBf.movepush\fP" 8
This function is like \fBf.move\fP except that it tries to avoid overlapping
of windows. When the moving window begin to overlap with another window, the
other window is pushed. If you go too far over the other window (more that
\fIMovePackResistance\fP pixels), there is no push and the moving window
can overlap with the other window. Only available if \fIOpaqueMove\fP is
active.

.IP "\fBf.moveresize\fP \fIgeometry\fP" 8
Takes one string argument which is a geometry with the
standard X geometry syntax (e.g. 200x300+150-0). Sets the current window
to the specified geometry. The width and height are to be given in pixel,
no base size or resize increment are used.

.IP "\fBf.nexticonmgr\fI" 8
This function warps the pointer to the next icon manager containing any windows
on the current or any succeeding screen.

.IP "\fBf.nextworkspace\fP" 8
Goto the next workspace in the list, using the order given in the \fI.ctwmrc\fP file.

.IP "\fBf.nop\fP" 8
This function does nothing and is typically used with the \fBDefaultFunction\fP
or \fBWindowFunction\fP variables or to introduce blank lines in menus.

.IP "\fBf.occupy\fP" 8
This function pops up a window for the user to choose which workspaces a window
belongs to.

.IP "\fBf.occupyall\fP" 8
This function makes the specified window occupy all the workspaces.

.IP "\fBf.pack\fI \fIstring\fP" 8
Where string is either : "right", "left", "top" or "bottom"
The current window is moved in the specified direction until it reaches
an obstacle (either another window, or the screen border). The pointer
follows the window. Example :

.IP "\fBf.previconmgr\fI" 8
This function warps the pointer to the previous icon manager containing any
windows on the current or preceding screens.

.IP "\fBf.prevworkspace\fP" 8
Goto the previous workspace in the list, using the order given in the \fI.ctwmrc\fP file.

.IP "\fBf.pin\fP" 8
Valid only in a root menu. Make a menu permanent on the screen. This is a toggle
function, if you select it while the menu is already permanent, it becomes
non-permanent.

.IP "\fBf.quit\fP" 8
This function causes \fIctwm\fP to restore the window's borders and exit.  If
\fIctwm\fP is the first client invoked from \fIxdm\fP, this will result in a
server reset.

.IP "\fBf.raiseicons\fP" 8
This function raises all the icons in the current workspace.

.IP "\fBf.raise\fP" 8
This function raises the selected window.

.IP "\fBf.raiselower\fP" 8
This function raises the selected window to the top of the stacking order if
it is occluded by any windows, otherwise the window will be lowered.

.IP "\fBf.removefromworkspace\fP \fIstring\fP" 8
This function removes the selected window from the workspace whose name
is \fIstring\fP.

.IP "\fBf.refresh\fP" 8
This function causes all windows to be refreshed.

.IP "\fBf.resize\fP" 8
This function displays an outline of the selected window.  Crossing a border
(or setting \fBAutoRelativeResize\fP) will cause the outline to begin to 
rubber band until the invoking button is released.  To abort a resize,
press another button before releasing the first button.

.IP "\fBf.restart\fP" 8
This function kills and restarts \fIctwm\fP.

.IP "\fBf.restoregeometry\fP" 8
Restore the current window geometry to what was saved in the last
call to f.savegeometry.

.IP "\fBf.righticonmgr\fI" 8
This function is similar to \fBf.nexticonmgr\fP except that wrapping does
not change rows.

.IP "\fBf.rightworkspace\fP" 8
Goto the workspace immediately on the right of the current workspace in the
workspace manager. If the current workspace is the rightest one, goto the
leftest one in the same row. The result depends on the layout of the workspace
manager.

.IP "\fBf.rightzoom\fP" 8
This variable is similar to the \fBf.bottomzoom\fP function except that
the selected window is only resized to the right half of the display.

.IP "\fBf.ring\fP" 8
Selects a window and adds it to the WarpRing, or removes it if it
was already in the ring. This command makes \fBf.warpring\fP \fI much \fP more
useful, by making its configuration dynamic.

.IP "\fBf.savegeometry\fP" 8
The geometry of the current window is saved. The next call to
f.restoregeometry will restore this window to this geometry.

.IP "\fBf.saveyourself\fP" 8
This function sends a WM_SAVEYOURSELF message to the selected window if it
has requested the message in its WM_PROTOCOLS window property.  Clients that
accept this message are supposed to checkpoint all state associated with the
window and update the WM_COMMAND property as specified in the ICCCM.  If
the selected window has not selected for this message, the keyboard bell
will be rung.

.IP "\fBf.separator\fP" 8
Valid only in menus. The effect is to add a line separator between the
previous and the following entry. The name selector part in the menu is not
used (but must be present).

.IP "\fBf.setbuttonsstate\fP" 8
Set the WorkSpace manager in button state.

.IP "\fBf.setmapstate\fP" 8
Set the WorkSpace manager in map state.

.IP "\fBf.showiconmgr\fP" 8
This function maps the current icon manager.

.IP "\fBf.sorticonmgr\fP" 8
This function sorts the entries in the current icon manager alphabetically.
See the variable \fBSortIconManager\fP.
.\".IP "\fBf.source\fP \fIstring\fP" 8
.\"This function assumes \fIstring\fP is a file name.  The file is read 
.\"and parsed as a \fIctwm\fP startup file.
.\"This
.\"function is intended to be used only to re-build pull-down menus.  None
.\"of the \fIctwm\fP variables are changed.

.IP "\fBf.showworkspacemgr\fP" 8
Map the WorkSpace manager.

.IP "\fBf.slowdownanimation\fP" 8
Decrease \fIAnimationSpeed\fP by 1.

.IP "\fBf.speedupanimation\fP" 8
Increase \fIAnimationSpeed\fP by 1.

.IP "\fBf.squeeze\fP" 8
f.squeeze squeezes a window to a null vertical size. Works only for windows
with either a title, or a 3D border (in order to have something left on the
screen). If the window is already squeezed, it is unsqueezed.

.IP "\fBf.startanimation\fP" 8
Restart freezed animations (if any).

.IP "\fBf.stopanimation\fP" 8
Freeze animations (if any).

.IP "\fBf.title\fP" 8
This function provides a centered, unselectable item in a menu definition.  It
should not be used in any other context.

.IP "\fBf.toggleoccupation\fP \fIstring\fP" 8
This function adds the selected window to the workspace whose name
is \fIstring\fP if it doesn't already belongs to it, and removes it
from this workspace if not.

.IP "\fBf.togglestate\fP" 8
Toggle the state of the WorkSpace manager.

.IP "\fBf.toggleworkspacemgr\fP" 8
Toggle the presence of the WorkSpaceManager. If
it is mapped, it will be unmapped and vice versa.

.IP "\fBf.topzoom\fP" 8
This variable is similar to the \fBf.bottomzoom\fP function except that 
the selected window is only resized to the top half of the display.

.\".IP "\fBf.ctwmrc\fP" 8
.\"This function causes the startup customization file to be re-read.  This
.\"function is exactly like the \fBf.source\fP function without having to
.\"specify the filename.

.IP "\fBf.unfocus\fP" 8
This function resets the focus back to pointer-driven.  This should be used
when a focused window is no longer desired.

.IP "\fBf.upiconmgr\fI" 8
This function warps the pointer to the previous row in the current icon
manager, wrapping to the last row in the same column if necessary.

.IP "\fBf.upworkspace\fP" 8
Goto the workspace immediately above the current workspace in the workspace
manager. If the current workspace is the top one, goto the bottom one in the
same column. The result depends on the layout of the workspace manager.

.IP "\fBf.vanish\fP" 8
The specified window vanishes from the current workspace if it occupies at least
one other WorkSpace. Do nothing in the others cases.
.\".IP "\fBf.version\fI" 8
.\"This function causes the \fIctwm\fP version window to be displayed.  This
.\"window will be displayed until a pointer button is pressed or the
.\"pointer is moved from one window to another.
.IP "\fBf.vlzoom\fP" 8
This function is a synonym for \fBf.leftzoom\fP.

.IP "\fBf.vrzoom\fP" 8
This function is a synonym for \fBf.rightzoom\fP.

.IP "\fBf.warphere\fP \fIwin_name\fP" 8
This function adds the window which has a name or class that matches string
to the current workspace and warps the pointer to it. If the window is iconified,
it will be deiconified if the variable WarpUnmapped is set or else ignored.

.IP "\fBf.warpring\fP \fIstring\fP" 8
This function warps the pointer to the next or previous window (as indicated
by the argument \fIstring\fP, which may be \fB"next"\fP or \fB"prev"\fP) 
specified in the \fBWindowRing\fP variable.

.IP "\fBf.warpto\fP \fIstring\fP" 8
This function warps the pointer to the window which has a name or class 
that matches \fIstring\fP.  If the window is iconified, it will be deiconified
if the variable \fBWarpUnmapped\fP is set or else ignored.

.IP "\fBf.warptoiconmgr\fP \fIstring\fP" 8
This function warps the pointer to the icon manager entry 
associated with the window containing the pointer in the icon manager
specified by the argument \fIstring\fP.  If \fIstring\fP is empty (i.e. ""),
the current icon manager is chosen.

.IP "\fBf.warptoscreen\fP \fIstring\fP" 8
This function warps the pointer to the screen specified by the
argument \fIstring\fP.  \fIString\fP may be a number (e.g. \fB"0"\fP or
\fB"1"\fP), the word \fB"next"\fP (indicating the current screen plus 1,
skipping over any unmanaged screens), 
the word \fB"back"\fP (indicating the current screen minus 1, skipping over
any unmanaged screens), or the word
\fB"prev"\fP (indicating the last screen visited.
.IP "\fBf.winrefresh\fP" 8
This function is similar to the \fBf.refresh\fP function except that only the
selected window is refreshed.
.IP "\fBf.zoom\fP" 8
This function is similar to the \fBf.fullzoom\fP function, except that
the only the height of the selected window is changed.
.SH MENUS
.PP
Functions may be grouped and interactively selected using pop-up
(when bound to a pointer button) or pull-down (when associated
with a titlebutton) menus.  Each menu specification contains the name of the 
menu as it will be referred to by \fBf.menu\fP, optional default 
foreground and background colors, the list of item names and the functions
they should invoke, and optional foreground and background colors for 
individual items:
.EX 0
\fBMenu\fP "\fImenuname\fP" [ ("\fIdeffore\fP":"\fIdefback\fP") ]
{
	\fIstring1\fP	[ ("\fIfore1\fP":"\fIbackn\fP")]	\fIfunction1\fP
	\fIstring2\fP	[ ("\fIfore2\fP":"\fIbackn\fP")]	\fIfunction2\fP
		.
		.
		.
	\fIstringN\fP	[ ("\fIforeN\fP":"\fIbackN\fP")]	\fIfunctionN\fP
}
.EE
.PP
The \fImenuname\fP is case-sensitive.
The optional \fIdeffore\fP and \fIdefback\fP arguments specify the foreground
and background colors used on a color display 
to highlight menu entries.
The \fIstring\fP portion
of each menu entry will be the text which will appear in the menu.
The optional \fIfore\fP and \fIback\fP arguments specify the foreground
and background colors of the menu entry when the pointer is not in
the entry.  These colors will only be used on a color display.  The
default is to use the colors specified by the 
\fBMenuForeground\fP and \fBMenuBackground\fP variables.
The \fIfunction\fP portion of the menu entry is one of the functions,
including any user-defined functions, or additional menus.
.PP
There is 3 special menus. \fBTwmWindows\fP contains the names of
all of the client and \fIctwm\fP-supplied windows in the current workspace.
Selecting an entry will cause the \fBWindowFunction\fP to be executed on that
window.  If \fBWindowFunction\fP hasn't been set, the window will be deiconified
and raised. \fBTwmWorkspaces\fP contains the names of your workspaces, selecting
an entry goto this workspace. In addition, these entries have submenus containing
the names of all windows occupying this workspace, selecting such an entry
executes f.warpto on this window. And finally, \fBTwmAllWindows\fP contains the names
of all the windows \fIctwm\fP manages. Selectting an entry executes f.warpto on
this window.
.PP
If an entry name begins with a '*' (star), this star won't be displayed and
the corresponding entry will be the default entry for this menu. When a menu
has a default entry and is used as a submenu of another menu, this default entry
action will be executed automatically when this submenu is selected without beeing
displayed. It's hard to explain, but easy to understand.
.SH ICONS
\fICtwm\fP supports several different ways of manipulating iconified windows.
The common pixmap-and-text style may be laid out by hand or automatically
arranged as described by the \fBIconRegion\fP variable.  In addition, a
terse grid of icon names, called an icon manager, provides a more efficient
use of screen space as well as the ability to navigate among windows from
the keyboard.
.PP
An icon manager is a window that contains names of selected or all
windows currently on the display.  In addition to the window name,
a small button using the default iconify symbol will be displayed to the 
left of the name when the window is iconified.  By default, clicking on an 
entry in the icon manager performs \fBf.iconify\fP.
To change the actions taken in the icon manager, use the 
the \fBiconmgr\fP context when specifying button and keyboard bindings.
.PP
Moving the pointer into the icon manager also directs keyboard focus to
the indicated window (setting the focus explicitly or else sending synthetic
events \fBNoTitleFocus\fP is set).
Using the \fBf.upiconmgr\fP, \fBf.downiconmgr\fP
\fBf.lefticonmgr\fP, and
\fBf.righticonmgr\fP functions,
the input focus can be changed between windows directly from the keyboard.
.SH BUGS
The resource manager should have been used instead of all of the window
lists.
.PP
The \fBIconRegion\fP variable should take a list.
.PP
Double clicking very fast to get the constrained move function will sometimes
cause the window to move, even though the pointer is not moved.
.PP
If \fBIconifyByUnmapping\fP is on and windows are listed in 
\fBIconManagerDontShow\fP but not in \fBDontIconifyByUnmapping\fP, 
they may be lost if they are iconified and no bindings to 
\fBf.menu "TwmWindows"\fP or \fBf.warpto\fP are setup.
.SH FILES
.PP
.nf
 $HOME/.ctwmrc.<screen number>
 $HOME/.ctwmrc
 /usr/lib/X11/twm/system.ctwmrc
$HOME/.twmrc
.fi
.SH "ENVIRONMENT VARIABLES"
.IP "DISPLAY" 8
This variable is used to determine which X server to use.  It is also set
during \fBf.exec\fP so that programs come up on the proper screen.
.IP "HOME" 8
This variable is used as the prefix for files that begin with a tilde and
for locating the \fIctwm\fP startup file.
.SH "SEE ALSO"
.PP
X(1), Xserver(1), xdm(1), xrdb(1)
.SH COPYRIGHT
Portions copyright 1988 Evans & Sutherland Computer Corporation; portions
copyright 1989 Hewlett-Packard Company and the Massachusetts Institute of
Technology,  See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Tom LaStrange, Solbourne Computer; Jim Fulton, MIT X Consortium;
Steve Pitschke, Stardent Computer; Keith Packard, MIT X Consortium;
Dave Sternlicht, MIT X Consortium; Dave Payne, Apple Computer.
Claude Lecommandeur, Swiss Polytechnical Institute of Lausanne (lecom@sic.epfl.ch).
