const ID = '{4C4D8A1D-1E3C-439e-9298-16073A5C4851}';
var unreg;

function init()
{
	document.getElementById('expertCheck').checked = ExtCommonUtils.getPref('ctxextensions.enable.expert_prefs');



	var box = document.getElementById('uninstallBox');
	try {
		const ExtensionManager = Components.classes['@mozilla.org/extensions/manager;1'].getService(Components.interfaces.nsIExtensionManager);
		var item = ExtensionManager.getItemList(ID, Components.interfaces.nsIUpdateItem.TYPE_EXTENSION, {});

		if (item && item[0] && item[0].version) {
			box.setAttribute('hidden',true);
			return;
		}
	}
	catch(e) {
	}
	box.removeAttribute('hidden',true);

	unreg = new exUnregisterer(
		'chrome://ctxextensions/content/contents.rdf',
		'jar:%chromeFolder%ctxextensions.jar!/locale/en-US/ctxextensions/contents.rdf',
		'jar:%chromeFolder%ctxextensions.jar!/locale/ja-JP/ctxextensions/contents.rdf'
	);
}


function Unregister(button)
{
	if (!ExtCommonUtils.PromptService.confirm(
			window,
			ExtCommonUtils.getMsg('pref_uninstall_title'),
			ExtCommonUtils.getMsg('pref_uninstall_confirm')
		)) return;

	var result = ExtCommonUtils.PromptService.confirmEx(
			window,
			ExtCommonUtils.getMsg('pref_uninstall_title'),
			ExtCommonUtils.getMsg('pref_uninstall_userdata_confirm'),
			(
				(ExtCommonUtils.PromptService.BUTTON_TITLE_YES * ExtCommonUtils.PromptService.BUTTON_POS_0) +
				(ExtCommonUtils.PromptService.BUTTON_TITLE_CANCEL * ExtCommonUtils.PromptService.BUTTON_POS_1) +
				(ExtCommonUtils.PromptService.BUTTON_TITLE_NO * ExtCommonUtils.PromptService.BUTTON_POS_2)
			),
			null, null, null,
			null,
			{}
		);
	if (result == 2) {
		ExtCommonUtils.datasourceFile.remove(true);

		var defPref = ExtCommonUtils.getFileFromURLSpec(ExtCommonUtils.getURISpecFromKey('PrfDef')+'ctxextensions.js');
		if (defPref.exists()) {
			defPref.remove(true);
		}
		else {
			var uchromeDefPref = ExtCommonUtils.getFileFromURLSpec(ExtCommonUtils.getURISpecFromKey('UChrm')+'ctxextensions.js');
			if (uchromeDefPref.exists()) uchromeDefPref.remove(true);
		}

		window.unreg.removePrefs('ctxextensions');
	}
	else if (result == 1)
		return;

	window.unreg.unregister();

/*
	const LOCALFILE = Components.classes['@mozilla.org/file/local;1'].getService(Components.interfaces.nsILocalFile);
	LOCALFILE.initWithPath(document.getElementById('installedFilePath').getAttribute('value'));
	LOCALFILE.remove(true);

	ExtCommonUtils.PromptService.alert(
		window,
		ExtCommonUtils.getMsg('pref_uninstall_title'),
		ExtCommonUtils.getMsg('pref_uninstall_finish')
	);
*/

	var path = window.unreg.getFilePathFromURLSpec((window.unreg.exists(window.unreg.UChrome+'ctxextensions.jar') ? window.unreg.UChrome+'ctxextensions.jar' : window.unreg.Chrome+'ctxextensions.jar' ));

	ExtCommonUtils.PromptService.alert(
		window,
		ExtCommonUtils.getMsg('pref_uninstall_title'),
		ExtCommonUtils.getMsg('pref_uninstall_removefile').replace(/%S/i, path)
	);

	button.setAttribute('disabled', true);
}


function chooseExtensionsData(textboxId)
{
	var file = chooseRDFDataSource();
	if (file) document.getElementById(textboxId).value = file.path;
}

function importRDFData()
{
	var file = chooseRDFDataSource();
	if (!file) return;

	var uri         = ExtCommonUtils.getURLSpecFromFilePath(file.path);
	var dsource_uri = ExtCommonUtils.datasourceURI;
	if (uri == dsource_uri) return;

	window.openDialog('chrome://ctxextensions/content/pref/importRDFData.xul', '_blank', 'chrome,modal,resizable=no,titlebar=no,centerscreen', uri);

	ExtCommonUtils.PromptService.alert(
		window,
		ExtCommonUtils.getMsg('pref_importRDF_title'),
		ExtCommonUtils.getMsg('pref_importRDF_finish')
	);
}


function chooseRDFDataSource()
{
	var file = ExtCommonUtils.chooseFile(
			ExtCommonUtils.getMsg('filePicker_title_datafile'),
			'ctxextensions.rdf',
			[
				ExtCommonUtils.getMsg('filePicker_filter_rdf'),
				'*.rdf'
			]
		);
	if (!file) return null;

	var content;
	try {
		content = ExtCommonUtils.readFrom(file);
	}
	catch(e) {
	}
	if (!content || !content.match(/xmlns(:[^=]+)?=("|')http:\/\/www\.w3\.org\/1999\/02\/22-rdf-syntax-ns#("|')/)) {
		ExtCommonUtils.PromptService.alert(
			window,
			ExtCommonUtils.getMsg('pref_importRDF_notDataSource_title'),
			ExtCommonUtils.getMsg('pref_importRDF_notDataSource')
		);
		return null;
	}
	return file;
}

