/***************************************************************************
                          blopgitter.h  -  description
                             -------------------
    begin                : Thu Jul 12 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BLOPGITTER_H
#define BLOPGITTER_H

#include "inkompatibel.h"

#include "blop.h"
#include "blopbesitzer.h"

/**Array, in dem die (festen) Blops eines Spielfelds gespeichert werden.
  *@author Immi
  */

class BlopGitter: public BlopBesitzer {
 public:
  BlopGitter();
  ~BlopGitter();

  /* Animiert alle Blops. Liefert true, wenn grad welche am platzen sind */
  bool animiere();
		
  /** Liefert ein Feldinhalt zurck */
  const Blop & getFeld(int x, int y) const {
    ASSERT(koordOK(x, y));
    return mDaten[x][y];
  }

  /** Liefert ein Feldinhalt zurck */
  Blop & getFeld(int x, int y) {
    ASSERT(koordOK(x, y));
    return mDaten[x][y];
  }

  /** Setzt mUpdate[...] auf true. Wird vom Blop selbst aufgerufen. */
  void besitzGeaendert(int x, int y, bool auch_nachbarn) {
    setUpdateFeld(x, y);
    if (auch_nachbarn) {
      setUpdateNachbarn(x, y);
      mTestPlatz = true;
    }
  }

  /** liefert true, wenn der Blob bei x, y sich mit b verbinden kann.
      Bezieht sich ggf. auf's Feuer. */
  bool getFeldVerbindbar(int x, int y, const Blop & b,
			 bool feuer = false) const;
	
  /** liefert die Feldart bei x, y; (d. h. grau oder gras oder leer
      oder normaler Stein oder auerhalb vom Spielfeld). */
  int getFeldArt(int x, int y) const;

  /** liefert die Farbe vom Feld bei x, y. */
  //int getFeldFarbe(int x, int y) const;
	
  /** Lscht alles */
  void init();

  /** verschiebt einen Blop (auch wenn er explodiert oder
      sonstwie grad animiert ist). Was dort hin soll, von wo der Blop weg ist
      (z. B. blopart_wirklich_keins) kann bergeben werden. */
  void verschiebBlop(int x1, int y1, int x2, int y2
		     /*,int bg_sorte = blopart_keins*/);

  /** liefert eine VerbindungsBitliste fr den Blop bei x, y. Bezieht sich
      ggf. auf's Feuer. */
  int getBesitzVerbindungen(int x, int y, bool feuer = false) const;
  /** liefert true, wenn (x,y) im Spielfeld liegt */
  bool koordOK(int x, int y) const;
  /** Setzt, ob die Rberreihe existiert. */
  void setRueberReihe(bool ex);
  /** Liefert die Anzahl der Zeilen zurck, d. h. normalerweise
      gry; aber wenn die Rbergebreihe existiert, dann eins mehr. */
  int getGrY() const;
  /** Liefert true, wenn man mal wieder testen sollte, ob was
      platzt. Achtung: Das Flag wird bei diesem Aufruf gleich
      gelscht. */
  bool getTestPlatz();
  /** Liefert true, wenn (x, y) und alle darber liegenden
      Felder frei sind. Wird von Fall bentigt. */
  bool testPlatzSpalte(int x, int y);

 protected:
  /** Wenn das Feld bei x,y geupdatet werden muss... */
  void setUpdateFeld(int x, int y) {mUpdaten[x][y] = true;}
	
  /** Aufrufen, wenn sich der Blop bei x, y gendert hat und vorher alt war.
      Updatet - falls ntig - die Nachbarn. */
  void setUpdateNachbarn(int x, int y);




  /** _die_ Spielfelddaten. Letzte Zeile fr die Rberreihe. */
  Blop mDaten[grx][gry + 1];

  /** True, wenn mal wieder getestet werden sollte, ob was platzt. */
  bool mTestPlatz;
	
  /** Existiert die Rberreihe? */
  bool mRueberReihe;
		
 public: // provisorisch	
  /** Welche Blops mssen geupdatet werden? */
  bool mUpdaten[grx][gry + 1];
};

#endif
