/***************************************************************************
                          leveldaten.h  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LEVELDATEN_H
#define LEVELDATEN_H

#include "inkompatibel.h"

#include <qcolor.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qimage.h>
#include <qstrlist.h>

#include "configdatei.h"

#include "sorte.h"


/***** Konstanten, die irgend was einstellen *****/

/* Gre des Levels */
#define grx 10
#define gry 20

#define platzbild_anzahl 8 // Anzahl der Bildchen der Platz-Animation

#define max_farben_zahl 16 // Max. Anzahl der Farben in einem Level

/* Wofr gibt es wie viele Punkte */
#define punkte_fuer_normales 1
#define punkte_fuer_graues 0
#define punkte_fuer_gras 20
#define punkte_fuer_kettenreaktion 10

/* Pixel pro Schritt: Bonus-Hetzrand-Geschwindigkeit */
#define bonus_geschwindigkeit 16
/* Punkte pro Zeitschritt der Bonus-Animation */
#define punkte_fuer_zeitbonus 5



/***** Konstanten, die einfach nur was bedeuten *****/

#define zufallsgraue_keine -1


/* Zur bergabe an laden(), um den Titel-Level zu laten */
#define level_titel -1

/* nachbarschaft_... steht in sorte.h */


#define hifea_nix 0
#define hifea_rochade 1



/**(Einziges globales) Objekt enthlt alle Informationen ber
den aktuellen Level
  *@author Immi
  */


class LevelDaten {
  friend void Sorte::laden(__String name, int verbart, bool vmr);
	
 public:
  LevelDaten();
  ~LevelDaten();
  /** Ld die Levelconf (neu). Wird vom Konstruktor aufgerufen. Und
      vielleicht im Debug-Modus ab und zu... */
  void ladLevelConf();
  /** fllt alle Daten in diesem Objekt fr Level nr aus; throwt bei Fehler */
  void ladLevel(int nr, int spz);
  /** liefert zurck, wie viel Gras am Anfang des Levels
      da ist */
  int getGrasAnzahl();
  /** Sollte einmal pro Spielschritt aufgerufen werden (bevor
      Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich ggf. um
      die Synchron-Animation */
  void spielSchritt() const;

  /** Liefert zurck, wie viele Level es gibt. */
  int getLevelAnz() const;

  /** Liefert den Namen von Level nr zurck. Liefert "???" bei Fehler. */
  __String getLevelName(int nr) const;

  /** Liefert den internen Namen von Level nr zurck. */
  __String getIntLevelName(int nr) const;

 protected:
  ConfigDatei * mLevelConf;
  /** Pfad und Name der level.descr-Datei (um Fehlermeldungen auszugeben) */
  __String mLevelConfPfad;
  /** Liste der internen Levelnamen. (Mutable, weil man sonst gar nicht
      drauf zugreifen kann.) */
  mutable QStrList mIntLevelNamen;
 public:

  /* Allgemeines */
  int mSpielerZahl;
  __String mLevelName;
  /** Beschreibungstext fr den Level */
  __String mBeschreibung;
  QColor mHintergrundFarbe;
  bool mMitHintergrundbildchen;
  Bilddatei bhintergrund;
  QColor schriftFarbe;
  bool mGrasBeiKettenreaktion;
  Bilddatei bbumm;
  Sorte mGrauSorte;
  int mPlatzAnzahl;
	
  /* Farbbildchen */
  int mAnzFarben;
  Sorte mFarbSorten[max_farben_zahl];

  /* Hetzrand */	
  QColor hetzrandFarbe;
  int hetzrandZeit;
  bool mMitHetzbildchen;
  Bilddatei bhetz;
  int mHetzrandUeberlapp;

  /* Gras */
  Sorte mGrasSorte;
  QStrList anfangszeilen;
	
  /* Sonderfeatures */	
  bool mSpiegeln;
  bool mMitBlaeschen;
  Sorte mBlaeschenSorte;
  bool mMitFeuer;
  Sorte mFeuerSorte;
  int mNachbarschaft; // Default-Wert fr die Sorten
  /** true bei Sechseckraster. Wird direkt aus mNachbarschaft bestimmt. */
  bool mSechseck;
  int mDrehWechsel[max_farben_zahl];
  bool mMitLeerBildchen;
  Sorte mLeerSorte;
  int mZufallsGraue;
  int mHiddenFeature;
  	
  /* Achtung: Beim Hinzufgen neuer Sorten auch spielSchritt() ndern */
		
 protected: // Protected methods
  /** Throwt, wenn der angegebene Schlssel in level.descr nicht existiert. */
  void verlangeSchluessel(const char * s) const;


  /* Setzt den akt. Abschnitt von mLevelConf auf Level nr. Throwt bei
     Fehler. */
  void setLevelAbschnitt(int nr) const;
};

/* Definition in leveldaten.cpp */
extern LevelDaten * ld;


#endif
