/***************************************************************************
                          startatdlg.cpp  -  description
                             -------------------
    begin                : Wed Jun 13 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cuyointl.h"
#include "startatdlg.h"

StartAtDlg::StartAtDlg(QWidget *parent, const char *name ) : QDialog(parent,name,true) {
  initDialog();
}
StartAtDlg::~StartAtDlg(){
}


#define leli_br 200
#define leli_hoe 180
void  StartAtDlg::initDialog(){
  this->resize(leli_br + 20,leli_hoe + 60);
  this->setMinimumSize(0,0);
  this->setCaption(_("Start at Level"));

  mOK= new QPushButton(this,"ok");
  mOK->setGeometry(leli_br - 90,leli_hoe + 20,100,30);
  mOK->setText(_("OK"));
  mOK->setDefault(true);
  mOK->setEnabled(false);
  connect(mOK, SIGNAL(clicked()), SLOT(accept()));

  mAbbrechen= new QPushButton(this,"abbrechen");
  mAbbrechen->setGeometry(10,leli_hoe + 20,100,30);
  mAbbrechen->setText(_("Cancel"));
  connect(mAbbrechen, SIGNAL(clicked()), SLOT(reject()));

  mLevelListe = new QListBox(this, "levelliste");
  mLevelListe->setGeometry(10, 10, leli_br, leli_hoe);
  connect(mLevelListe, SIGNAL(selected(int)), SLOT(levelListeSelect(int)));
  connect(mLevelListe, SIGNAL(highlighted(int)), SLOT(levelListeHighlight(int)));
}

/** Wenn in der Levelliste was selektiert (doppelgeklickt)
wird... (Wenn da kein in bergeben wrde, knnte man
direkt mit accept() connecten.) */
void StartAtDlg::levelListeSelect(int){
  accept();
}
/** Wenn in der LevelListe was gehighlightet wird,
den OK-Button neu enablen oder disablen. */
void StartAtDlg::levelListeHighlight(int nr){
  mOK->setEnabled(nr != -1);
}
