#
#   Copyright 2005 by Mark Weyer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

BreakOut = {
  name="Breakout"
  author="Mark Weyer"
  numexplode=2
  chaingrass=1
  neighbours=7   # Verbindungen? Wer braucht Verbindungen?
  mirror=1
  pics = schlaeger, stuetze
  greypic = inGelb.xpm
  emptypic = nichts
  startpic = gras
  startdist = "B........B","BB......BB","BBB....BBB","AAA....AAA","BBBB..BBBB","BBBB..BBBB","BBBB..BBBB","AAAA..AAAA","CCCC..CCCC","CCCC..CCCC","CCCC..CCCC","BBBBBBBBBB","BDDDDDDDDB","BDDDDDDDDB","BDDDDDDDDB","BBBBBBBBBB"
  bgcolor = 0,0,0
  textcolor = 255,255,0
  toptime = 10000

  <<
    var ball_x,ball_y,ball_richt,ball_richt_zurueck,ball_dx,ball_dy;
      # Richtung: 1=nach unten und dann in Zwlfteln im Uhrzeigersinn
      #           0: Ball ist drauen
    var schlaeger_richt;
               # Ausrichtung: 0=nach rechts, dann im Uhrzeigersinn
               # Im global-blop: nur 0 oder 1
               #   (quivalenzklassen waagerecht/senkrecht)
    var straf_x = -1;
    var schlaeger_x1, schlaeger_y1, schlaeger_x2, schlaeger_y2,
        schlaeger_x3, schlaeger_y3, schlaeger_x4, schlaeger_y4,
        schlaeger_xx, schlaeger_yy, schlaeger_xx_alt, schlaeger_yy_alt,
        spiegel_xx0, spiegel_yy0, spiegel_dxx, spiegel_dyy,
        spiegel_richt, spiegel_schlaeger, spiegel_stein,
        ball_xx_zaehler, ball_yy_zaehler, ball_xxyy_nenner, ball_dxx, ball_dyy,
        ball_t_bisher_zaehler, ball_t_bisher_nenner,
        t_zaehler, t_nenner, u_zaehler, u_nenner,
        erstes_t_zaehler, erstes_t_nenner,
        erstes_richt, erstes_schlaeger, erstes_stein;
               # *_richt*: In 15 Grad Schritten im Uhrzeigersinn,
               #   dabei 0: waagerecht, mit Innerem unten
               # *_stein: Stein in der Umgebung: 1=oben, dann im Uhrzeigersinn
    var frei,farbe;
    var getroffen;  # Wurde Gras/Schlger vom Ball getroffen
    var ggT;


    global = {
      if ball_richt_zurueck==0 -> {   # Ball ist raus: soll wieder rein
        ball_x = 9+rnd(2);
        ball_y = 18;
        ball_richt = (rnd(5)+10)%12+1;
        straf_x = rnd(10);
      } else
        ball_richt = ball_richt_zurueck;
      ball_richt_zurueck = 0; # Wir behaupten, der Ball ist weg.
                              # Wer ihn findet, wird uns das schon mitteilen
                              # (und seine eigentliche Richtung kennen).
    };



    spiel_spiegel = {
      # Argumente:
      #   spiegel_xx0, spiegel_yy0 : Koordinaten eines Endes des Spiegels
      #   spiegel_dxx, spiegel_dyy : Differenz zum anderen Ende
      #   spiegel_schlaeger : Gehrt der Spiegel zum Schlger?
      #   ball_xx, ball_yy : Koordinaten des Balls
      #   ball_dxx, ball_dyy : Differenz bis zum Ende der Bewegung
      #   ball_t_bisher_zaehler, ball_t_bisher_nenner : als Bruch die bisher
      #     absolvierte Laufzeit des Balls im aktuellen Zeitschritt
      #
      # Vernderliche Argumente:
      #   erstes_t_zaehler, erstes_t_nenner: als Bruch das erste t,
      #     so da der Ball nach Anteil t von ball_dxx,ball_dyy
      #     einen Spiegel trifft
      #   erstes_richt: Ausrichtung dieses Spiegels
      #   erstes_schlaeger: wie spiegel_schlaeger

      # Der Spiegel bewegt sich mit - hier rechnen wir einen Korrekturterm ein
      if spiegel_schlaeger -> {
        spiegel_xx0 -= schlaeger_xx-schlaeger_xx_alt;
        spiegel_yy0 -= schlaeger_yy-schlaeger_yy_alt;
      };

      # Jetzt rechnen wir t und u so aus, da
      #   ball_xy + t*ball_dxy = spiegel_xy0 + u*spiegel_dxy 
      # Das sind die Schnittparameter von Ball-Bahn und Spiegel-Linie
      # Genauer: t*D = (spiegel_yy0-ball_yy) * spiegel_dxx
      #              - (spiegel_xx0-ball_xx) * spiegel_dyy
      #          u*D = (spiegel_yy0-ball_yy) * ball_dxx
      #              - (spiegel_xx0-ball_xx) * ball_dyy
      #      mit   D = ball_dyy*spiegel_dxx - ball_dxx*spiegel_dyy
      ggT = gcd(spiegel_dxx,spiegel_dyy);
      t_zaehler =
        (spiegel_yy0*ball_xxyy_nenner-ball_yy_zaehler) * (spiegel_dxx/ggT)
        - (spiegel_xx0*ball_xxyy_nenner-ball_xx_zaehler) * (spiegel_dyy/ggT);
      t_nenner = (ball_dyy*(spiegel_dxx/ggT)-ball_dxx*(spiegel_dyy/ggT))
        * ball_xxyy_nenner;
      ggT = gcd(t_zaehler,t_nenner);
      t_zaehler /= ggT;
      t_nenner /= ggT;
      if t_nenner<0 -> {
        t_zaehler = -t_zaehler;
        t_nenner = -t_nenner;
      };

      ggT = gcd(ball_dxx,ball_dyy);
      u_zaehler =
        (spiegel_yy0*ball_xxyy_nenner-ball_yy_zaehler) * (ball_dxx/ggT)
        - (spiegel_xx0*ball_xxyy_nenner-ball_xx_zaehler) * (ball_dyy/ggT);
      u_nenner = ((ball_dyy/ggT)*spiegel_dxx-(ball_dxx/ggT)*spiegel_dyy)
        * ball_xxyy_nenner;
      ggT = gcd(u_zaehler,u_nenner);
      u_zaehler /= ggT;
      u_nenner /= ggT;
      if u_nenner<0 -> {
        u_zaehler = -u_zaehler;
        u_nenner = -u_nenner;
      };

      if t_zaehler*ball_t_bisher_nenner>ball_t_bisher_zaehler*t_nenner
          && t_zaehler<=t_nenner
          && u_zaehler>=0 && u_zaehler<=u_nenner
          && t_zaehler*erstes_t_nenner<=t_nenner*erstes_t_zaehler
          # bersetzung: t_bisher<t<=1, 0<=u<1, t<=erstes_t
          -> {
        erstes_t_zaehler = t_zaehler;
        erstes_t_nenner = t_nenner;
        erstes_richt = spiegel_richt;
        erstes_schlaeger = spiegel_schlaeger;
        erstes_stein = spiegel_stein;
      };
    };

    spiel_ball_richtung = {
      switch {
        ball_richt==1 ->  {ball_dx=0;  ball_dy=2};
        ball_richt==2 ->  {ball_dx=1;  ball_dy=2};
        ball_richt==3 ->  {ball_dx=2;  ball_dy=1};
        ball_richt==4 ->  {ball_dx=2;  ball_dy=0};
        ball_richt==5 ->  {ball_dx=2;  ball_dy=-1};
        ball_richt==6 ->  {ball_dx=1;  ball_dy=-2};
        ball_richt==7 ->  {ball_dx=0;  ball_dy=-2};
        ball_richt==8 ->  {ball_dx=-1; ball_dy=-2};
        ball_richt==9 ->  {ball_dx=-2; ball_dy=-1};
        ball_richt==10 -> {ball_dx=-2; ball_dy=0};
        ball_richt==11 -> {ball_dx=-2; ball_dy=1};
        ball_richt==12 -> {ball_dx=-1; ball_dy=2};
      };
      ball_dxx = -ball_dx*16;
      ball_dyy = -ball_dy*16;
    };

    spiel_kein_spiegel = {
      erstes_t_zaehler = 1;
      erstes_t_nenner = 1;
    };

    spiel_spiegel_alle = {
      erstes_t_zaehler = 2;
      erstes_t_nenner = 1;
      erstes_richt = -1;

      # Globale Wnde

      spiegel_schlaeger = 0;
      spiegel_stein = -1;

      spiegel_xx0 = 320;
      spiegel_yy0 = 0;
      spiegel_dxx = 0;
      spiegel_dyy = 640;
      spiegel_richt = 18;
      spiel_spiegel;

      spiegel_xx0 = 320;
      spiegel_yy0 = 640;
      spiegel_dxx = -320;
      spiegel_dyy = 0;
      spiegel_richt = 12;
      spiel_spiegel;

      spiegel_xx0 = 0;
      spiegel_yy0 = 640;
      spiegel_dxx = 0;
      spiegel_dyy = -640;
      spiegel_richt = 6;
      spiel_spiegel;

      # Steine

      # links
      spiegel_dxx=0;
      spiegel_dyy=-32;
      spiegel_xx0=32*(9-loc_x);
      spiegel_yy0=32*(19-loc_y);
      spiegel_richt=6;
      spiegel_stein=6;
      if kind@(-1,1)==gras -> spiel_spiegel;
      spiegel_yy0+=32;
      spiegel_stein=7;
      if kind@(-1,0)==gras -> spiel_spiegel;
      spiegel_yy0+=32;
      spiegel_stein=8;
      if kind@(-1,-1)==gras -> spiel_spiegel;

      # rechts
      spiegel_dyy=32;
      spiegel_xx0+=32;
      spiegel_yy0-=32;
      spiegel_richt=18;
      spiegel_stein=2;
      if kind@(1,-1)==gras -> spiel_spiegel;
      spiegel_yy0-=32;
      spiegel_stein=3;
      if kind@(1,0)==gras -> spiel_spiegel;
      spiegel_yy0-=32;
      spiegel_stein=4;
      if kind@(1,1)==gras -> spiel_spiegel;

      # oben
      spiegel_dxx=-32;
      spiegel_dyy=0;
      spiegel_xx0=32*(9-loc_x);
      spiegel_yy0=32*(20-loc_y);
      spiegel_richt=12;
      spiegel_stein=8;
      if kind@(-1,-1)==gras -> spiel_spiegel;
      spiegel_xx0+=32;
      spiegel_stein=1;
      if kind@(0,-1)==gras -> spiel_spiegel;
      spiegel_xx0+=32;
      spiegel_stein=2;
      if kind@(1,-1)==gras -> spiel_spiegel;

      # unten
      spiegel_dxx=32;
      spiegel_xx0-=32;
      spiegel_yy0-=32;
      spiegel_richt=0;
      spiegel_stein=4;
      if kind@(1,1)==gras -> spiel_spiegel;
      spiegel_xx0-=32;
      spiegel_stein=5;
      if kind@(0,1)==gras -> spiel_spiegel;
      spiegel_xx0-=32;
      spiegel_stein=6;
      if kind@(-1,1)==gras -> spiel_spiegel;

      # Schlger

      spiegel_stein=-1;
      if schlaeger_richt@ != -1 -> {
        spiegel_schlaeger = 1;
        ball_dxx -= schlaeger_xx-schlaeger_xx_alt;
        ball_dyy -= schlaeger_yy-schlaeger_yy_alt;

        spiegel_xx0 = schlaeger_x1;
        spiegel_yy0 = schlaeger_y1;
        spiegel_dxx = schlaeger_x2-schlaeger_x1;
        spiegel_dyy = schlaeger_y2-schlaeger_y1;
        spiegel_richt = schlaeger_richt;
        spiel_spiegel;

        spiegel_xx0 = schlaeger_x2;
        spiegel_yy0 = schlaeger_y2;
        spiegel_dxx = schlaeger_x3-schlaeger_x2;
        spiegel_dyy = schlaeger_y3-schlaeger_y2;
        spiegel_richt = schlaeger_richt+2;
        spiel_spiegel;

        spiegel_xx0 = schlaeger_x3;
        spiegel_yy0 = schlaeger_y3;
        spiegel_dxx = schlaeger_x4-schlaeger_x3;
        spiegel_dyy = schlaeger_y4-schlaeger_y3;
        spiegel_richt = schlaeger_richt+12;
        spiel_spiegel;

        spiegel_xx0 = schlaeger_x4;
        spiegel_yy0 = schlaeger_y4;
        spiegel_dxx = schlaeger_x1-schlaeger_x4;
        spiegel_dyy = schlaeger_y1-schlaeger_y4;
        spiegel_richt = schlaeger_richt+14;
        spiel_spiegel;

        ball_dxx += schlaeger_xx-schlaeger_xx_alt;
        ball_dyy += schlaeger_yy-schlaeger_yy_alt;
      };

      if erstes_richt==-1 -> spiel_kein_spiegel
      else {
        ball_richt = (erstes_richt-ball_richt+19)%12+1;
        if erstes_stein != -1 -> switch {
          erstes_stein == 1 -> getroffen@(0,-1)=1;
          erstes_stein == 2 -> getroffen@(1,-1)=1;
          erstes_stein == 3 -> getroffen@(1,0)=1;
          erstes_stein == 4 -> getroffen@(1,1)=1;
          erstes_stein == 5 -> getroffen@(0,1)=1;
          erstes_stein == 6 -> getroffen@(-1,1)=1;
          erstes_stein == 7 -> getroffen@(-1,0)=1;
          erstes_stein == 8 -> getroffen@(-1,-1)=1;
        };
        if erstes_schlaeger -> {
          if turn@0!=0 -> {bonus(10); message("Angeschnitten!");};
          getroffen@0=1;
          getroffen@1=1;
        };
      };
    };

    spiel_bewege_ball = {
      # Der Ball wird bis erstes_t, also bis zum ersten Spiegel, den er trifft,
      # weiterbewegt.
      # Genauer: ball_xx += ball_dxx*(erstes_t-t_bisher), entsprechend ball_yy
      ggT = gcd(ball_t_bisher_nenner,erstes_t_nenner);
      ball_xx_zaehler =
        ball_xx_zaehler*erstes_t_nenner*(ball_t_bisher_nenner/ggT)
        + ball_dxx*ball_xxyy_nenner
          * (erstes_t_zaehler*(ball_t_bisher_nenner/ggT)
            - ball_t_bisher_zaehler*(erstes_t_nenner/ggT));
      ball_yy_zaehler =
        ball_yy_zaehler*erstes_t_nenner*(ball_t_bisher_nenner/ggT)
        + ball_dyy*ball_xxyy_nenner
          * (erstes_t_zaehler*(ball_t_bisher_nenner/ggT)
            - ball_t_bisher_zaehler*(erstes_t_nenner/ggT));
      ball_xxyy_nenner *= erstes_t_nenner*(ball_t_bisher_nenner/ggT);
      ggT = gcd(gcd(ball_xx_zaehler,ball_yy_zaehler),ball_xxyy_nenner);
      ball_xx_zaehler /= ggT;
      ball_yy_zaehler /= ggT;
      ball_xxyy_nenner /= ggT;
      ball_t_bisher_zaehler = erstes_t_zaehler;
      ball_t_bisher_nenner = erstes_t_nenner;
    };

    spiel = {
      if loc_y==19 && loc_x==straf_x@ -> 
        {kind=gras; farbe=3; frei=0; straf_x@=-1;};

      if (getroffen@0 || getroffen@1)
          && loc_x+loc_x@0==8..10 && loc_y+loc_y@0<=19
          && loc_y<=17 && frei ->
        kind=stuetze;

      if (loc_x==ball_x@/2) && (loc_y==ball_y@/2) -> {
                 # Ich mu mich um den Ball kmmern

        #
        # Variablen abholen
        #

        ball_x=ball_x@;
        ball_y=ball_y@;
        ball_richt=ball_richt@;
        schlaeger_xx_alt = schlaeger_xx_alt@0;
        schlaeger_yy_alt = schlaeger_yy_alt@0;

        #
        # Bewegen und kollidieren mit Schlger
        #

        schlaeger_xx = (loc_xx@0+loc_xx@1)/2;
        schlaeger_yy = (loc_yy@0+loc_yy@1)/2;
        if schlaeger_xx_alt == -1 -> {
          schlaeger_xx_alt = schlaeger_xx;
          schlaeger_yy_alt = schlaeger_yy;
        };

        if schlaeger_richt@0==0 # Schlger ist waagerecht
          -> switch {
            turn@0 == 0 -> {
              schlaeger_x1 = loc_xx@0+5;
              schlaeger_y1 = loc_yy@0+16;
              schlaeger_x2 = loc_xx@0+32;
              schlaeger_y2 = loc_yy@0+23;
              schlaeger_x3 = loc_xx@1+27;
              schlaeger_y3 = loc_yy@1+16;
              schlaeger_x4 = loc_xx@1+0;
              schlaeger_y4 = loc_yy@1+9;
              schlaeger_richt = 23;
            };
            turn@0 == 1 -> {
              schlaeger_x1 = loc_xx@0+10;
              schlaeger_y1 = loc_yy@0+6;
              schlaeger_x2 = loc_xx@1+1;
              schlaeger_y2 = loc_yy@1+6;
              schlaeger_x3 = loc_xx@1+22;
              schlaeger_y3 = loc_yy@1+26;
              schlaeger_x4 = loc_xx@0+31;
              schlaeger_y4 = loc_yy@0+26;
              schlaeger_richt = 20;
            };
            turn@0 == 2 -> {
              schlaeger_x1 = loc_xx@0+6;
              schlaeger_y1 = loc_yy@0+10;
              schlaeger_x2 = loc_xx@0+26;
              schlaeger_y2 = loc_yy@0+31;
              schlaeger_x3 = loc_xx@1+26;
              schlaeger_y3 = loc_yy@1+22;
              schlaeger_x4 = loc_xx@1+6;
              schlaeger_y4 = loc_yy@1+1;
              schlaeger_richt = 22;
            };
          }
          else switch {
            turn@0 == 0 -> {
              schlaeger_x1 = loc_xx@1+16;
              schlaeger_y1 = loc_yy@1+27;
              schlaeger_x2 = loc_xx@1+23;
              schlaeger_y2 = loc_yy@1+0;
              schlaeger_x3 = loc_xx@0+16;
              schlaeger_y3 = loc_yy@0+5;
              schlaeger_x4 = loc_xx@0+9;
              schlaeger_y4 = loc_yy@0+32;
              schlaeger_richt = 5;
            };
            turn@0 == 1 -> {
              schlaeger_x1 = loc_xx@1+6;
              schlaeger_y1 = loc_yy@1+22;
              schlaeger_x2 = loc_xx@0+6;
              schlaeger_y2 = loc_yy@0+31;
              schlaeger_x3 = loc_xx@0+26;
              schlaeger_y3 = loc_yy@0+10;
              schlaeger_x4 = loc_xx@1+26;
              schlaeger_y4 = loc_yy@1+1;
              schlaeger_richt = 2;
            };
            turn@0 == 2 -> {
              schlaeger_x1 = loc_xx@1+10;
              schlaeger_y1 = loc_yy@1+26;
              schlaeger_x2 = loc_xx@1+31;
              schlaeger_y2 = loc_yy@1+6;
              schlaeger_x3 = loc_xx@0+22;
              schlaeger_y3 = loc_yy@0+6;
              schlaeger_x4 = loc_xx@0+1;
              schlaeger_y4 = loc_yy@0+26;
              schlaeger_richt = 4;
            };
          };

        ball_xx_zaehler = 312-ball_x*16;
        ball_yy_zaehler = 632-ball_y*16;
        ball_xxyy_nenner = 1;
        ball_t_bisher_zaehler = 0;
        ball_t_bisher_nenner = 1;

        spiel_ball_richtung;
        spiel_spiegel_alle;
        spiel_bewege_ball;
        spiel_ball_richtung;
        spiel_spiegel_alle;
        spiel_bewege_ball;
        spiel_ball_richtung;
        spiel_spiegel_alle;
        spiel_bewege_ball;
        spiel_ball_richtung;
        spiel_spiegel_alle;
        spiel_bewege_ball;
        spiel_ball_richtung;
        spiel_kein_spiegel;
        spiel_bewege_ball;

        ball_x = (320*ball_xxyy_nenner-ball_xx_zaehler)/(16*ball_xxyy_nenner);
        ball_y = (640*ball_xxyy_nenner-ball_yy_zaehler)/(16*ball_xxyy_nenner);

        #
        # Malen
        #

        switch {
          ball_y==2*loc_y-2 -> switch {
            ball_x==2*loc_x-2 -> {C*@(1,-2); D*@(2,-2); G*@(1,-1); H*@(2,-1)};
            ball_x==2*loc_x-1 -> {A*@(0,-2); B*@(1,-2); E*@(0,-1); F*@(1,-1)};
            ball_x==2*loc_x-0 -> {C*@(0,-2); D*@(1,-2); G*@(0,-1); H*@(1,-1)};
            ball_x==2*loc_x+1 -> {A*@(-1,-2); B*@(0,-2); E*@(-1,-1); F*@(0,-1)};
            ball_x==2*loc_x+2 -> {C*@(-1,-2); D*@(0,-2); G*@(-1,-1); H*@(0,-1)};
            ball_x==2*loc_x+3 -> {A*@(-2,-2); B*@(-1,-2); E*@(-2,-1); F*@(-1,-1)};
          };
          ball_y==2*loc_y-1 -> switch {
            ball_x==2*loc_x-2 -> {K*@(1,-1); L*@(2,-1); O*@(1,0); P*@(2,0)};
            ball_x==2*loc_x-1 -> {I*@(0,-1); J*@(1,-1); M*@(0,0); N*@(1,0)};
            ball_x==2*loc_x-0 -> {K*@(0,-1); L*@(1,-1); O*@(0,0); P*@(1,0)};
            ball_x==2*loc_x+1 -> {I*@(-1,-1); J*@(0,-1); M*@(-1,0); N*@(0,0)};
            ball_x==2*loc_x+2 -> {K*@(-1,-1); L*@(0,-1); O*@(-1,0); P*@(0,0)};
            ball_x==2*loc_x+3 -> {I*@(-2,-1); J*@(-1,-1); M*@(-2,0); N*@(-1,0)};
          };
          ball_y==2*loc_y-0 -> switch {
            ball_x==2*loc_x-2 -> {C*@(1,-1); D*@(2,-1); G*@(1,0); H*@(2,0)};
            ball_x==2*loc_x-1 -> {A*@(0,-1); B*@(1,-1); E*@(0,0); F*@(1,0)};
            ball_x==2*loc_x-0 -> {C*@(0,-1); D*@(1,-1); G*@(0,0); H*@(1,0)};
            ball_x==2*loc_x+1 -> {A*@(-1,-1); B*@(0,-1); E*@(-1,0); F*@(0,0)};
            ball_x==2*loc_x+2 -> {C*@(-1,-1); D*@(0,-1); G*@(-1,0); H*@(0,0)};
            ball_x==2*loc_x+3 -> {A*@(-2,-1); B*@(-1,-1); E*@(-2,0); F*@(-1,0)};
          };
          ball_y==2*loc_y+1 -> switch {
            ball_x==2*loc_x-2 -> {K*@(1,0); L*@(2,0); O*@(1,1); P*@(2,1)};
            ball_x==2*loc_x-1 -> {I*@(0,0); J*@(1,0); M*@(0,1); N*@(1,1)};
            ball_x==2*loc_x-0 -> {K*@(0,0); L*@(1,0); O*@(0,1); P*@(1,1)};
            ball_x==2*loc_x+1 -> {I*@(-1,0); J*@(0,0); M*@(-1,1); N*@(0,1)};
            ball_x==2*loc_x+2 -> {K*@(-1,0); L*@(0,0); O*@(-1,1); P*@(0,1)};
            ball_x==2*loc_x+3 -> {I*@(-2,0); J*@(-1,0); M*@(-2,1); N*@(-1,1)};
          };
          ball_y==2*loc_y+2 -> switch {
            ball_x==2*loc_x-2 -> {C*@(1,0); D*@(2,0); G*@(1,1); H*@(2,1)};
            ball_x==2*loc_x-1 -> {A*@(0,0); B*@(1,0); E*@(0,1); F*@(1,1)};
            ball_x==2*loc_x-0 -> {C*@(0,0); D*@(1,0); G*@(0,1); H*@(1,1)};
            ball_x==2*loc_x+1 -> {A*@(-1,0); B*@(0,0); E*@(-1,1); F*@(0,1)};
            ball_x==2*loc_x+2 -> {C*@(-1,0); D*@(0,0); G*@(-1,1); H*@(0,1)};
            ball_x==2*loc_x+3 -> {A*@(-2,0); B*@(-1,0); E*@(-2,1); F*@(-1,1)};
          };
          ball_y==2*loc_y+3 -> switch {
            ball_x==2*loc_x-2 -> {K*@(1,1); L*@(2,1); O*@(1,2); P*@(2,2)};
            ball_x==2*loc_x-1 -> {I*@(0,1); J*@(1,1); M*@(0,2); N*@(1,2)};
            ball_x==2*loc_x-0 -> {K*@(0,1); L*@(1,1); O*@(0,2); P*@(1,2)};
            ball_x==2*loc_x+1 -> {I*@(-1,1); J*@(0,1); M*@(-1,2); N*@(0,2)};
            ball_x==2*loc_x+2 -> {K*@(-1,1); L*@(0,1); O*@(-1,2); P*@(0,2)};
            ball_x==2*loc_x+3 -> {I*@(-2,1); J*@(-1,1); M*@(-2,2); N*@(-1,2)};
          };
        };

        #
        # Variablen zurckgeben
        #

        schlaeger_xx_alt@0=schlaeger_xx;
        schlaeger_yy_alt@0=schlaeger_yy;
        schlaeger_xx_alt@1=schlaeger_xx;
        schlaeger_yy_alt@1=schlaeger_yy;

        ball_x@=ball_x;
        ball_y@=ball_y;
        ball_richt_zurueck@=ball_richt;
      };
    };

    schlaeger_init = {
      schlaeger_richt@=0;
      schlaeger_xx_alt = -1;
      if loc_x==4
        -> schlaeger_richt=0
        else schlaeger_richt=2;
    };

    nichts_init={frei=1;};
  >>

  gras = {
    pics = mbrBall.xpm, mbrStein.xpm
    <<
      gras = {
        if getroffen -> {farbe-=1; getroffen=0;};
        pos=farbe; 1*; 0;
        if farbe==0 -> {kind=stuetze; frei=1;};
        spiel;
      };

      gras.init = {farbe=version};
    >>
  }

  stuetze = {
    pics = mbrBall.xpm
    <<
      stuetze = {
        if kind@(0,1)==nichts || kind@(0,1)==outside -> kind=nichts;
        spiel;
      };

      stuetze.init = {kind=schlaeger; schlaeger_init;};
    >>
  }

  schlaeger = {
    numexplode=2
    pics = mbrBall.xpm, mbrSchlaeger.xpm
    <<
      schlaeger = {
        if falling
        -> {1;pos=schlaeger_richt+4*turn;*;}
        else spiel;
      };

      schlaeger.land = {
        if getroffen -> bonus(1);
        schlaeger_richt@=-1;
        kind = stuetze;
        frei = 1;
      };

      schlaeger.init = {schlaeger_init;};

      schlaeger.turn = {
        schlaeger_richt@=1-schlaeger_richt@;
        schlaeger_richt=(schlaeger_richt+1)%4;
      };
    >>
  }

  nichts = {
    pics = mbrBall.xpm
    <<
      nichts = spiel;
      nichts.init = nichts_init;
    >>
  }

}

