/* PlaylistController.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002-2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef PlaylistController_H
#define PlaylistController_H

@class InfoDisplayController;
@class CynthiuneController;
@class Player;
@class Playlist;
@class TableViewController;

@protocol Player;

#define STICK_DELTA 20.0

@interface PlaylistController : NSObject
{
  id previousButton;
  id playButton;
  id pauseButton;
  id stopButton;
  id ejectButton;
  id nextButton;

  id muteButton;
  id repeatButton;
  id shuffleButton;

  id muteMenuItem;
  id repeatMenuItem;
  id shuffleMenuItem;

  id timerButton;

  id addPopup;
  id removePopup;
  id savePopup;
  id progressSlider;

  /* non-ui */
  InfoDisplayController *infoDisplayController;
  TableViewController *tableViewController;

  Player <Player> *player;
  NSTimer *timer;
  BOOL timerShouldBeReset;

  Playlist *playlist;
  NSString *playlistFilename;
  Song *currentPlayerSong;
}

/* player console */
- (void) previousSong: (id) sender;
- (void) startPlayer: (id) sender;
- (void) pausePlayer: (id) sender;
- (void) stopPlayer: (id) sender;
- (void) nextSong: (id) sender;
- (void) eject: (id) sender;

- (void) songCursorChange: (id) sender;

- (void) changeTimeDisplay: (id) sender;

- (void) toggleMute: (id) sender;

- (void) toggleRepeat: (id) sender;
- (void) toggleShuffle: (id) sender;

/* playlist popup menus */
- (void) addSong: (id) sender;
- (void) removeSong: (id) sender;
- (void) saveListFromPopupMenu: (id) sender;

/* menu actions */
- (void) addSongs: (id) sender;
- (void) addSongsFolders: (id) sender;

- (void) removeSelectedSongs: (id) sender;
- (void) removeAllSongs: (id) sender;
- (void) cleanupPlaylist: (id) sender;

- (void) saveList: (id) sender;
- (void) saveListAs: (id) sender;

/* interface for CynthiuneController */
- (void) initializeWidgets;

- (void) addSongFromNSApp: (id) sender;
- (BOOL) openSongFromNSApp: (Song *) aSong;

- (id) validRequestorForSendType: (NSString *) sendType
                      returnType: (NSString *) returnType;

@end

#endif /* PlaylistController_H */
